/*
 * Decompiled with CFR 0.152.
 */
package org.ojai;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Public
public interface Value {
    public static final byte TYPE_CODE_NULL = 1;
    public static final byte TYPE_CODE_BOOLEAN = 2;
    public static final byte TYPE_CODE_STRING = 3;
    public static final byte TYPE_CODE_BYTE = 4;
    public static final byte TYPE_CODE_SHORT = 5;
    public static final byte TYPE_CODE_INT = 6;
    public static final byte TYPE_CODE_LONG = 7;
    public static final byte TYPE_CODE_FLOAT = 8;
    public static final byte TYPE_CODE_DOUBLE = 9;
    public static final byte TYPE_CODE_DECIMAL = 10;
    public static final byte TYPE_CODE_DATE = 11;
    public static final byte TYPE_CODE_TIME = 12;
    public static final byte TYPE_CODE_TIMESTAMP = 13;
    public static final byte TYPE_CODE_INTERVAL = 14;
    public static final byte TYPE_CODE_BINARY = 15;
    public static final byte TYPE_CODE_MAP = 16;
    public static final byte TYPE_CODE_ARRAY = 17;

    public Type getType();

    public byte getByte();

    public short getShort();

    public int getInt();

    public long getLong();

    public float getFloat();

    public double getDouble();

    public BigDecimal getDecimal();

    public boolean getBoolean();

    public String getString();

    public OTimestamp getTimestamp();

    public long getTimestampAsLong();

    public ODate getDate();

    public int getDateAsInt();

    public OTime getTime();

    public int getTimeAsInt();

    public OInterval getInterval();

    public long getIntervalAsLong();

    public ByteBuffer getBinary();

    public Map<String, Object> getMap();

    public List<Object> getList();

    public Object getObject();

    public DocumentReader asReader();

    public static enum Type {
        NULL(1),
        BOOLEAN(2),
        STRING(3),
        BYTE(4),
        SHORT(5),
        INT(6),
        LONG(7),
        FLOAT(8),
        DOUBLE(9),
        DECIMAL(10),
        DATE(11),
        TIME(12),
        TIMESTAMP(13),
        INTERVAL(14),
        BINARY(15),
        MAP(16),
        ARRAY(17);

        private byte code;

        private Type(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }

        public boolean isScalar() {
            return this != MAP && this != ARRAY;
        }

        public static Type valueOf(int typeCode) {
            switch (typeCode) {
                case 1: {
                    return NULL;
                }
                case 2: {
                    return BOOLEAN;
                }
                case 3: {
                    return STRING;
                }
                case 4: {
                    return BYTE;
                }
                case 5: {
                    return SHORT;
                }
                case 6: {
                    return INT;
                }
                case 7: {
                    return LONG;
                }
                case 8: {
                    return FLOAT;
                }
                case 9: {
                    return DOUBLE;
                }
                case 10: {
                    return DECIMAL;
                }
                case 11: {
                    return DATE;
                }
                case 12: {
                    return TIME;
                }
                case 13: {
                    return TIMESTAMP;
                }
                case 14: {
                    return INTERVAL;
                }
                case 15: {
                    return BINARY;
                }
                case 16: {
                    return MAP;
                }
                case 17: {
                    return ARRAY;
                }
            }
            return null;
        }
    }
}

