/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.impl.JsonDocumentStream;
import org.ojai.json.impl.JsonStreamDocumentReader;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Types;
import org.ojai.util.Values;

@API.Internal
public class TypeMappedJsonDocumentReader
extends JsonStreamDocumentReader {
    private final Map<FieldPath, Value.Type> typeMap;
    private final Stack<Object> fieldSegmentStack = new Stack();
    private FieldPath currentFieldPath = null;
    private String currentFieldName;

    TypeMappedJsonDocumentReader(JsonDocumentStream stream, Map<FieldPath, Value.Type> hashMap) {
        super(stream);
        if (hashMap == null) {
            throw new IllegalArgumentException("A FieldPath => Type map must be provided.");
        }
        for (Map.Entry<FieldPath, Value.Type> entry : hashMap.entrySet()) {
            for (FieldSegment seg : entry.getKey()) {
                if (!seg.isArray()) continue;
                throw new IllegalArgumentException("A FieldPath with indexed segment is not supported.");
            }
            if (entry.getValue().isScalar()) continue;
            throw new IllegalArgumentException("A mapping to a container type (ARRAY, MAP) is not supported.");
        }
        this.typeMap = hashMap;
    }

    @Override
    public DocumentReader.EventType next() {
        DocumentReader.EventType et = super.next();
        if (et != null) {
            switch (et) {
                case END_MAP: {
                    if (this.fieldSegmentStack.isEmpty()) break;
                    this.fieldSegmentStack.pop();
                    break;
                }
                default: {
                    Value.Type currentFieldType;
                    if (!this.inMap()) break;
                    this.currentFieldName = this.getFieldName();
                    this.calculateCurrentFieldPath();
                    if (et == DocumentReader.EventType.START_MAP) {
                        if (this.currentFieldName == null) break;
                        this.fieldSegmentStack.push(this.currentFieldName);
                        break;
                    }
                    Value.Type mappedType = this.typeMap.get(this.currentFieldPath);
                    if (mappedType == null || (et = Types.getEventTypeForType(currentFieldType = mappedType)) == this.getCurrentEventType()) break;
                    this.updateCurrentValue(et);
                    this.setCurrentEventType(et);
                }
            }
        }
        return et;
    }

    private void updateCurrentValue(DocumentReader.EventType evt) {
        DocumentReader.EventType oldEvt = this.getCurrentEventType();
        switch (evt) {
            case BOOLEAN: {
                this.setCurrentObj(this.convertValueToBoolean(oldEvt, evt));
                break;
            }
            case STRING: {
                this.setCurrentObj(this.isExtended() ? this.convertValueToString(oldEvt, evt) : this.getValueAsString());
                break;
            }
            case BYTE: {
                this.setCurrentLongValue(this.convertValueToLong(oldEvt, evt) & 0xFFL);
                break;
            }
            case SHORT: {
                this.setCurrentLongValue(this.convertValueToLong(oldEvt, evt) & 0xFFFFL);
                break;
            }
            case INT: {
                this.setCurrentLongValue(this.convertValueToLong(oldEvt, evt) & 0xFFFFFFFFFFFFFFFFL);
                break;
            }
            case LONG: 
            case INTERVAL: {
                this.setCurrentLongValue(this.convertValueToLong(oldEvt, evt));
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                this.setCurrentDoubleValue(this.convertValueToDouble(oldEvt, evt));
                break;
            }
            case DECIMAL: {
                this.setCurrentObj(this.convertValueToDecimal(oldEvt, evt));
                break;
            }
            case DATE: {
                this.setCurrentObj(this.convertValueToDate(oldEvt, evt));
                break;
            }
            case TIME: {
                this.setCurrentObj(this.convertValueToTime(oldEvt, evt));
                break;
            }
            case TIMESTAMP: {
                this.setCurrentObj(this.convertValueToTimestamp(oldEvt, evt));
                break;
            }
            case BINARY: {
                this.setCurrentObj(this.convertValueToBinary(oldEvt, evt));
                break;
            }
        }
    }

    private ByteBuffer convertValueToBinary(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case STRING: {
                return Values.parseBinary((String)this.getCurrentObj());
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private BigDecimal convertValueToDecimal(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return BigDecimal.valueOf(this.getCurrentLongValue());
            }
            case FLOAT: 
            case DOUBLE: {
                return BigDecimal.valueOf(this.getCurrentDoubleValue());
            }
            case STRING: {
                return Values.parseBigDecimal((String)this.getCurrentObj());
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private ODate convertValueToDate(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new ODate(this.getCurrentLongValue());
            }
            case STRING: {
                return ODate.parse((String)this.getCurrentObj());
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private OTime convertValueToTime(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new OTime(this.getCurrentLongValue());
            }
            case STRING: {
                return OTime.parse((String)this.getCurrentObj());
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private OTimestamp convertValueToTimestamp(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new OTimestamp(this.getCurrentLongValue());
            }
            case STRING: {
                return OTimestamp.parse((String)this.getCurrentObj());
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private Object convertValueToString(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case INTERVAL: {
                return String.valueOf(this.getCurrentLongValue());
            }
            case FLOAT: 
            case DOUBLE: {
                return String.valueOf(this.getCurrentDoubleValue());
            }
        }
        return String.valueOf(this.getCurrentObj());
    }

    private Boolean convertValueToBoolean(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (oldEvt) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return this.getCurrentLongValue() != 0L;
            }
            case FLOAT: 
            case DOUBLE: {
                return this.getCurrentDoubleValue() != 0.0;
            }
            case STRING: {
                return Boolean.valueOf((String)this.getCurrentObj());
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private double convertValueToDouble(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (this.getCurrentEventType()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case INTERVAL: {
                return this.getCurrentLongValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return this.getCurrentDoubleValue();
            }
            case STRING: {
                return Double.valueOf((String)this.getCurrentObj());
            }
            case DECIMAL: {
                return ((BigDecimal)this.getCurrentObj()).doubleValue();
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private long convertValueToLong(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        switch (this.getCurrentEventType()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case INTERVAL: {
                return this.getCurrentLongValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return (long)this.getCurrentDoubleValue();
            }
            case STRING: {
                return Long.valueOf((String)this.getCurrentObj());
            }
            case DECIMAL: {
                return ((BigDecimal)this.getCurrentObj()).longValue();
            }
        }
        throw this.unsupportedConversion(oldEvt, evt);
    }

    private DecodingException unsupportedConversion(DocumentReader.EventType oldEvt, DocumentReader.EventType evt) {
        return new DecodingException(String.format("A value of type %s cannot be converted as %s.", new Object[]{Types.getTypeForEventType(oldEvt), Types.getTypeForEventType(evt)}));
    }

    private void calculateCurrentFieldPath() {
        StringBuilder sb = new StringBuilder();
        for (Object e : this.fieldSegmentStack) {
            if (e instanceof Number) {
                sb.append('[').append(e).append(']');
                continue;
            }
            sb.append('`').append(e).append('`').append('.');
        }
        this.currentFieldPath = FieldPath.parseFrom(sb.append('`').append(this.currentFieldName).append('`').toString());
    }
}

