/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;

@API.Public
public class Values {
    public static byte asByte(Value value) {
        return Values.asNumber(value).byteValue();
    }

    public static short asShort(Value value) {
        return Values.asNumber(value).shortValue();
    }

    public static int asInt(Value value) {
        return Values.asNumber(value).intValue();
    }

    public static long asLong(Value value) {
        return Values.asNumber(value).longValue();
    }

    public static float asFloat(Value value) {
        return Values.asNumber(value).floatValue();
    }

    public static double asDouble(Value value) {
        return Values.asNumber(value).doubleValue();
    }

    public static BigDecimal asDecimal(Value value) {
        Number val = Values.asNumber(value);
        return val instanceof BigDecimal ? (BigDecimal)val : (val instanceof Long ? new BigDecimal(val.longValue()) : new BigDecimal(val.doubleValue()));
    }

    public static Number asNumber(Value value) {
        switch (value.getType()) {
            case BYTE: {
                return value.getByte();
            }
            case SHORT: {
                return value.getShort();
            }
            case INT: {
                return value.getInt();
            }
            case LONG: {
                return value.getLong();
            }
            case FLOAT: {
                return Float.valueOf(value.getFloat());
            }
            case DOUBLE: {
                return value.getDouble();
            }
            case DECIMAL: {
                return value.getDecimal();
            }
        }
        throw new TypeException((Object)((Object)value.getType()) + " can not be converted to a Number.");
    }

    public static BigDecimal parseBigDecimal(String s) {
        return new BigDecimal(s);
    }

    public static ByteBuffer parseBinary(String s) {
        return ByteBuffer.wrap(BaseEncoding.base64().decode((CharSequence)s));
    }

    public static String asJsonString(Value value) {
        return Json.toJsonString(value.asReader(), JsonOptions.WITH_TAGS);
    }
}

