/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public class OracleTypeDATE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5858803341118747965L;
    static boolean DEBUG = false;

    public OracleTypeDATE() {
    }

    public OracleTypeDATE(int n) {
        super(n);
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 11);
            this.align_for_lds = Util.FDO_get_align(byArray, 11);
        }
        return this.align_for_lds;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 11);
            this.align_for_lds = Util.FDO_get_align(byArray, 11);
        }
        return this.size_for_lds;
    }

    public int getTypeCode() {
        return 91;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeDATE::readObject");
        }
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        DATE dATE;
        block2: {
            dATE = null;
            if (object == null) break block2;
            try {
                dATE = object instanceof DATE ? (DATE)object : new DATE(object);
            }
            catch (SQLException sQLException) {
                DBError.check_error(59, object);
            }
        }
        return dATE;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n2 = (int)(n == -1 ? (long)cArray.length : Math.min((long)cArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                int n3 = 0;
                while (n3 < n2) {
                    datumArray[n3] = this.toDatum(new String(cArray[(int)l + n3 - 1]), oracleConnection);
                    ++n3;
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l, n);
                }
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n == 1) {
            return new DATE(byArray);
        }
        if (n == 2) {
            return DATE.toTimestamp(byArray);
        }
        if (n == 3) {
            return byArray;
        }
        DBError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        if (n == 1) {
            if (unpickleContext.is_null(this.null_offset)) {
                return null;
            }
            unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
        } else if ((unpickleContext.read_byte() & 1) == 1) {
            unpickleContext.skip_bytes(8);
            return null;
        }
        if (n2 == 9) {
            unpickleContext.skip_bytes(8);
            return null;
        }
        byte[] byArray = unpickleContext.image();
        int n3 = unpickleContext.absolute_offset();
        byte[] byArray2 = new byte[7];
        int n4 = unpickleContext.m_bigEndian ? (byArray[n3] & 0xFF) * 256 + (byArray[n3 + 1] & 0xFF) : (byArray[n3 + 1] & 0xFF) * 256 + (byArray[n3] & 0xFF);
        if (n4 < 0) {
            byArray2[0] = (byte)(100 - -n4 / 100);
            byArray2[1] = (byte)(100 - -n4 % 100);
        } else {
            byArray2[0] = (byte)(n4 / 100 + 100);
            byArray2[1] = (byte)(n4 % 100 + 100);
        }
        byArray2[2] = byArray[n3 + 2];
        byArray2[3] = byArray[n3 + 3];
        byArray2[4] = (byte)(byArray[n3 + 4] + 1);
        byArray2[5] = (byte)(byArray[n3 + 5] + 1);
        byArray2[6] = (byte)(byArray[n3 + 6] + 1);
        unpickleContext.skip_bytes(8);
        return this.toObject(byArray2, n2, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeDATE::writeObject");
        }
    }
}

