/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.repackager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Component {
    protected String name;
    protected String description;
    protected String[] metaComponentNames;
    protected String[] prerequisiteComponentNames;
    protected String[] includedPathNames;
    protected String memoName = "";
    protected int memoOpinion = -1;
    protected static Component[] allInstances;
    protected static final int INCLUDE = 1;
    protected static final int DONTCARE = 0;

    public Component() {
        Component[] componentArray = new Component[allInstances.length + 1];
        int n = 0;
        while (n < allInstances.length) {
            componentArray[n] = allInstances[n];
            ++n;
        }
        componentArray[Component.allInstances.length] = this;
        allInstances = componentArray;
    }

    public Component(Properties properties) {
        this();
        Object object;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            Object object2;
            int n;
            int n2;
            Vector<Object> vector2;
            String string = (String)enumeration.nextElement();
            if (string.equals("name")) {
                this.name = properties.getProperty(string);
                continue;
            }
            if (string.equals("description")) {
                this.description = properties.getProperty(string);
                continue;
            }
            if (string.equals("metanames")) {
                object = String.valueOf(properties.getProperty(string).trim()) + " ";
                vector2 = new Vector<Object>();
                n2 = 0;
                while (n2 < ((String)object).length()) {
                    n = ((String)object).indexOf(32, n2);
                    object2 = ((String)object).substring(n2, n);
                    if (((String)object2).length() > 0) {
                        vector2.addElement(object2);
                    }
                    n2 = n + 1;
                }
                this.metaComponentNames = new String[vector2.size()];
                n = 0;
                object2 = vector2.elements();
                while (object2.hasMoreElements()) {
                    this.metaComponentNames[n] = (String)object2.nextElement();
                    ++n;
                }
                continue;
            }
            if (string.equals("prerequisites")) {
                object = String.valueOf(properties.getProperty(string).trim()) + " ";
                vector2 = new Vector();
                n2 = 0;
                while (n2 < ((String)object).length()) {
                    n = ((String)object).indexOf(32, n2);
                    object2 = ((String)object).substring(n2, n);
                    if (((String)object2).length() > 0) {
                        vector2.addElement(object2);
                    }
                    n2 = n + 1;
                }
                this.prerequisiteComponentNames = new String[vector2.size()];
                n = 0;
                object2 = vector2.elements();
                while (object2.hasMoreElements()) {
                    this.prerequisiteComponentNames[n] = (String)object2.nextElement();
                    ++n;
                }
                continue;
            }
            vector.addElement(string);
        }
        this.includedPathNames = new String[vector.size()];
        int n = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.includedPathNames[n] = (String)object.nextElement();
            ++n;
        }
    }

    protected int checkClasses(String string) {
        int n = 0;
        while (n < this.includedPathNames.length) {
            if (string.equals(this.includedPathNames[n])) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    protected int checkPrerequisites(String string) {
        int n = 0;
        while (n < this.prerequisiteComponentNames.length) {
            int n2 = Component.lookup(this.prerequisiteComponentNames[n]).getOpinion(string);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public static void copyEntry(ZipEntry zipEntry, ZipFile zipFile, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setMethod(8);
        zipOutputStream.putNextEntry(zipEntry2);
        while ((n = inputStream.read(byArray)) > 0) {
            zipOutputStream.write(byArray, 0, n);
        }
        zipOutputStream.closeEntry();
        inputStream.close();
    }

    public static Component[] getInstances(ZipFile zipFile) throws IOException {
        Object object;
        Object object2;
        allInstances = new Component[0];
        Vector<Component> vector = new Vector<Component>();
        ZipEntry zipEntry = zipFile.getEntry("oracle/jdbc/repackager/properties/components.properties");
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry("components.properties");
        }
        if (zipEntry == null) {
            throw new IOException("The components.properties file was not found.");
        }
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(zipEntry));
        Enumeration enumeration = ((Hashtable)properties).elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            ZipEntry zipEntry2 = zipFile.getEntry((String)object2);
            if (zipEntry2 == null) {
                throw new IOException("could not open file " + (String)object2);
            }
            object = new Properties();
            ((Properties)object).load(zipFile.getInputStream(zipEntry2));
            vector.addElement(new Component((Properties)object));
        }
        object2 = new Component[vector.size()];
        int n = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            object2[n] = (Component)object.nextElement();
            ++n;
        }
        return object2;
    }

    public int getOpinion(String string) {
        if (!this.memoName.equalsIgnoreCase(string)) {
            this.memoName = string;
            this.memoOpinion = this.checkClasses(string);
            if (this.memoOpinion == 0) {
                this.memoOpinion = this.checkPrerequisites(string);
            }
        }
        return this.memoOpinion;
    }

    public boolean isSelected(String[] stringArray, BitSet bitSet) {
        BitSet bitSet2 = new BitSet(this.metaComponentNames.length);
        BitSet bitSet3 = (BitSet)bitSet.clone();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (this.name.equalsIgnoreCase(string)) {
                bitSet.set(n);
                return true;
            }
            int n2 = 0;
            while (n2 < this.metaComponentNames.length) {
                String string2 = this.metaComponentNames[n2];
                if (string2.equalsIgnoreCase(string)) {
                    bitSet2.set(n2);
                    bitSet3.set(n);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (this.metaComponentNames.length == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.metaComponentNames.length) {
            if (!bitSet2.get(n3)) {
                return false;
            }
            ++n3;
        }
        bitSet.or(bitSet3);
        return true;
    }

    public static void listComponents(File[] fileArray) {
        int n = 0;
        while (n < fileArray.length) {
            block8: {
                Object object;
                Component[] componentArray;
                Object object2;
                try {
                    object2 = new ZipFile(fileArray[n]);
                    componentArray = Component.getInstances((ZipFile)object2);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to open source file " + fileArray[n]);
                    break block8;
                }
                object2 = new Hashtable(31);
                Hashtable<String, String> hashtable = new Hashtable<String, String>(31);
                int n2 = 0;
                while (n2 < componentArray.length) {
                    object = componentArray[n2];
                    ((Hashtable)object2).put(((Component)object).name, ((Component)object).name);
                    int n3 = 0;
                    while (n3 < ((Component)object).metaComponentNames.length) {
                        hashtable.put(((Component)object).metaComponentNames[n3], ((Component)object).metaComponentNames[n3]);
                        ++n3;
                    }
                    ++n2;
                }
                System.out.println("Available meta component names");
                object = hashtable.elements();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    System.out.println("  " + string);
                }
                System.out.println("Available component names");
                Enumeration enumeration = ((Hashtable)object2).elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Component component = Component.lookup(string);
                    System.out.print("  " + string + "(");
                    int n4 = 0;
                    while (n4 < component.metaComponentNames.length) {
                        System.out.print(String.valueOf(component.metaComponentNames[n4]) + " ");
                        ++n4;
                    }
                    System.out.println(") " + component.description);
                }
            }
            ++n;
        }
    }

    public static Component lookup(String string) {
        int n = 0;
        while (n < allInstances.length) {
            if (string.equalsIgnoreCase(Component.allInstances[n].name)) {
                return allInstances[n];
            }
            ++n;
        }
        return null;
    }

    public static void repackageComponents(ZipFile zipFile, ZipOutputStream zipOutputStream, Component[] componentArray, boolean bl) {
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (Component.shouldInclude(componentArray, string)) {
                    if (bl) {
                        System.out.println("adding " + string);
                    }
                    Component.copyEntry(zipEntry, zipFile, zipOutputStream);
                    continue;
                }
                if (!bl) continue;
                System.out.println("skipping " + string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    public static void repackageComponents(File[] fileArray, File file, String[] stringArray, String[] stringArray2) {
        Object object;
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            object = stringArray2[n];
            if (((String)object).equals("-v")) {
                bl = true;
            } else {
                System.err.println("WARNING: unknown option " + (String)object);
            }
            ++n;
        }
        object = null;
        try {
            object = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            System.err.println("ERROR: unable to open destination " + iOException);
            return;
        }
        try {
            int n2 = 0;
            while (n2 < fileArray.length) {
                Object var14_14;
                ZipFile zipFile;
                block31: {
                    File file2 = fileArray[n2];
                    zipFile = null;
                    try {
                        zipFile = new ZipFile(file2);
                    }
                    catch (IOException iOException) {
                        System.err.println("ERROR: unable to open source " + iOException);
                        Object var8_15 = null;
                        if (object != null) {
                            try {
                                ((ZipOutputStream)object).close();
                            }
                            catch (IOException iOException2) {}
                        }
                        return;
                    }
                    Component[] componentArray = null;
                    try {
                        componentArray = Component.selectComponents(stringArray, zipFile);
                    }
                    catch (Exception exception) {
                        System.err.println("Error: " + exception.getMessage());
                        Object var8_16 = null;
                        if (object != null) {
                            try {
                                ((ZipOutputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                        return;
                    }
                    try {
                        if (bl) {
                            System.out.println("Examining files in " + file2.getName());
                        }
                        Component.repackageComponents(zipFile, (ZipOutputStream)object, componentArray, bl);
                        if (!bl) break block31;
                        System.out.println("Done");
                    }
                    catch (Throwable throwable) {
                        var14_14 = null;
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                var14_14 = null;
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            if (object != null) {
                try {
                    ((ZipOutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var8_17 = null;
        if (object != null) {
            try {
                ((ZipOutputStream)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Component[] selectComponents(String[] stringArray, ZipFile zipFile) throws IOException {
        Object object;
        Component[] componentArray = Component.getInstances(zipFile);
        BitSet bitSet = new BitSet(stringArray.length);
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component.isSelected(stringArray, bitSet)) {
                vector.addElement(component);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!bitSet.get(n2)) {
                String[] stringArray2;
                if (stringArray[n2].substring(0, 3).equalsIgnoreCase("NLS")) {
                    object = new Component();
                    object.name = stringArray[n2];
                    object.description = "";
                    object.metaComponentNames = new String[0];
                    object.prerequisiteComponentNames = new String[0];
                    stringArray2 = new String[]{"oracle/sql/converter/CharacterConverter" + stringArray[n2].substring(3) + ".class"};
                    object.includedPathNames = stringArray2;
                    vector.addElement(object);
                } else if (stringArray[n2].substring(0, 3).equalsIgnoreCase("MSG")) {
                    object = new Component();
                    object.name = stringArray[n2];
                    object.description = "";
                    object.metaComponentNames = new String[0];
                    object.prerequisiteComponentNames = new String[0];
                    stringArray2 = new String[]{"oracle/net/mesg/Message" + stringArray[n2].substring(3) + ".properties"};
                    object.includedPathNames = stringArray2;
                    vector.addElement(object);
                }
            }
            ++n2;
        }
        object = new Component[vector.size()];
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object[n3] = (Component)enumeration.nextElement();
            ++n3;
        }
        return object;
    }

    public static boolean shouldInclude(Component[] componentArray, String string) {
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].getOpinion(string) == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

