/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.TTIuds;

public class Odscrarr
extends TTIfun {
    protected int cursor_id = 0;
    private int startpos = 1;
    public static final int HSTITEMS = 32;
    public static final int M_IDEN = 30;
    public static final int NBL = 960;
    public int totalColumns = 0;
    public int numuds = 0;
    private TTIuds[] uds;
    protected String[] colnames;
    private int totalretlen;
    public int colOffset;
    private boolean numitemsO2U = true;
    protected boolean udsarrayO2U = true;
    protected boolean numudsO2U = true;
    private boolean colnameO2U = true;
    private boolean lencolsO2U = true;

    public Odscrarr(MAREngine mAREngine) throws IOException, SQLException {
        super((byte)3, 0, (byte)43);
        this.setMarshalingEngine(mAREngine);
        this.oer = new TTIoer(mAREngine);
    }

    private void decodeAllColumnNames(byte[] byArray) throws SQLException {
        int n = 0;
        short s = 0;
        this.colnames = new String[this.numuds];
        int n2 = 0;
        while (n2 < this.numuds) {
            s = this.uds[n2].udscnl;
            n = this.decodeColName(byArray, n, this.colnames, n2, s);
            ++n2;
        }
    }

    private int decodeColName(byte[] byArray, int n, String[] stringArray, int n2, short s) throws SQLException {
        int n3 = 0;
        char c = '\u0000';
        char[] cArray = new char[s];
        while ((c = this.meg.conv.CHARBytesToJavaChar(byArray, n)) != '\"') {
            if (c == '\'') {
                ++n;
            }
            n = this.meg.conv.CHARBytesToJavaChar(byArray, n, cArray, n3++);
        }
        stringArray[n2] = new String(cArray, 0, n3);
        return ++n;
    }

    public void fillupDBcols(DBColumn[] dBColumnArray) throws SQLException {
        int n = 0;
        while (n < this.numuds) {
            dBColumnArray[this.colOffset + n] = new DBColumn(this.colnames[n], this.uds[n].udsnull, this.uds[n].udsoac.oacdty, this.uds[n].udsoac.oacflg, this.uds[n].udsoac.oacpre, this.uds[n].udsoac.oacscl, this.uds[n].udsoac.oacmxl, this.uds[n].udsoac.oacmal, this.uds[n].udsoac.oacfl2);
            ++n;
        }
    }

    public void init(TTCStatement tTCStatement, int n) throws IOException, SQLException {
        this.startpos = 1;
        this.totalColumns = 0;
        this.numuds = 0;
        this.uds = null;
        this.colnames = null;
        this.totalretlen = 0;
        this.numitemsO2U = true;
        this.udsarrayO2U = true;
        this.numudsO2U = true;
        this.colnameO2U = true;
        this.lencolsO2U = true;
        this.oer.init();
        this.cursor_id = tTCStatement.getCursor();
        this.colOffset = n;
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalSWORD(this.cursor_id);
        this.meg.marshalSWORD(this.colOffset + this.startpos);
        this.meg.marshalO2U(this.numitemsO2U);
        this.meg.marshalO2U(this.udsarrayO2U);
        this.meg.marshalSWORD(32);
        this.meg.marshalO2U(this.numudsO2U);
        this.meg.marshalO2U(this.colnameO2U);
        this.meg.marshalSWORD(960);
        this.meg.marshalO2U(this.lencolsO2U);
    }

    public DBColumn[] receive(DBColumn[] dBColumnArray) throws SQLException, IOException {
        boolean bl = false;
        while (!bl) {
            byte by = this.meg.unmarshalSB1();
            switch (by) {
                case 8: {
                    byte[] byArray;
                    this.totalColumns = this.meg.unmarshalUB2();
                    this.numuds = this.meg.unmarshalUB2();
                    this.uds = new TTIuds[this.totalColumns];
                    if (dBColumnArray == null) {
                        dBColumnArray = new DBColumn[this.totalColumns];
                    }
                    int n = 0;
                    while (n < this.numuds) {
                        this.uds[n] = new TTIuds(this.meg);
                        this.uds[n].unmarshal();
                        ++n;
                    }
                    this.totalretlen = this.meg.unmarshalUB2();
                    if (this.totalretlen > 960) {
                        DBError.check_error(414);
                    }
                    if (this.totalretlen == 0 && (this.numuds > 0 || this.totalColumns > 0)) {
                        DBError.check_error(419);
                    }
                    if ((byArray = this.meg.unmarshalCHR(this.totalretlen)) == null || byArray.length == 0 || this.totalretlen == 0) {
                        DBError.check_error(438);
                    }
                    this.decodeAllColumnNames(byArray);
                    this.fillupDBcols(dBColumnArray);
                    break;
                }
                case 4: {
                    this.oer.init();
                    this.oer.unmarshal();
                    this.oer.processError();
                    bl = true;
                }
                case 9: {
                    bl = true;
                    break;
                }
            }
        }
        return dBColumnArray;
    }
}

