/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.BlobDBAccess;
import oracle.sql.Datum;

public class BLOB
extends Datum
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32512;
    OracleConnection m_conn;
    BlobDBAccess m_dbaccess;
    int m_dbChunkSize;

    protected BLOB() {
    }

    public BLOB(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
        } else {
            DBError.check_error(68, "Connection is null");
        }
        this.m_dbaccess = oracleConnection.createBlobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return new OracleConversionInputStream(this.m_conn.conversion, this.getBinaryStream(), 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return new OracleConversionReader(this.m_conn.conversion, this.getBinaryStream(), 8);
    }

    public static BLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        return bLOB;
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return new OracleBlobOutputStream(this, this.getBufferSize());
    }

    public InputStream getBinaryStream() throws SQLException {
        return new OracleBlobInputStream(this, this.getBufferSize());
    }

    public int getBufferSize() throws SQLException {
        int n = this.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DBError.throwSqlException(68, "getBytes()");
        }
        if (n == 0) {
            return new byte[0];
        }
        long l2 = 0L;
        byte[] byArray = new byte[n];
        l2 = this.getBytes(l, n, byArray);
        if (l2 > 0L) {
            if (l2 == (long)n) {
                return byArray;
            }
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            return byArray2;
        }
        return null;
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        return this.getDBAccess().getBytes(this, l, n, byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public OracleConnection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DBError.throwSqlException(98);
            }
            this.m_dbaccess = this.getConnection().createBlobDBAccess();
        }
        return this.m_dbaccess;
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isEmptyLob() throws SQLException {
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new BLOB[n];
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.getDBAccess().position(this, (BLOB)blob, l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        return this.getDBAccess().position(this, byArray, l);
    }

    public int putBytes(long l, byte[] byArray) throws SQLException {
        return this.getDBAccess().putBytes(this, l, byArray);
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

