/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;

public class LobDBAccessImpl
implements BlobDBAccess,
ClobDBAccess,
BfileDBAccess {
    OracleConnection m_conn;
    DBAccess m_dbaccess;

    public LobDBAccessImpl(OracleConnection oracleConnection) throws SQLException {
        if (oracleConnection == null) {
            DBError.throwSqlException(68, "connection is null");
        }
        this.m_conn = oracleConnection;
        this.m_dbaccess = oracleConnection.db_access;
    }

    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        this.m_dbaccess.fileClose(bFILE);
    }

    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileExists(bFILE);
    }

    public synchronized int getBytes(BFILE bFILE, long l, int n, byte[] byArray) throws SQLException {
        if (l < 1L || n < 0 || byArray == null) {
            DBError.check_error(68, "getBytes()");
        }
        if (n == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobRead(bFILE, l, (long)n, byArray);
    }

    public synchronized int getBytes(BLOB bLOB, long l, int n, byte[] byArray) throws SQLException {
        if (n < 0 || l < 1L || byArray == null) {
            DBError.throwSqlException(68, "getBytes()");
        }
        if (n == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobRead(bLOB, l, (long)n, byArray);
    }

    public synchronized int getChars(CLOB cLOB, long l, int n, char[] cArray) throws SQLException {
        if (n < 0 || l < 1L || cArray == null) {
            DBError.check_error(68, "getChars()");
        }
        if (n == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobRead(cLOB, l, (long)n, cArray);
    }

    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        return (int)this.m_dbaccess.getLobChunkSize(bLOB);
    }

    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        return (int)this.m_dbaccess.getLobChunkSize(cLOB);
    }

    public synchronized String getDirAlias(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileGetDirAlias(bFILE);
    }

    public synchronized String getName(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileGetName(bFILE);
    }

    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileIsOpen(bFILE);
    }

    public synchronized long length(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.lobLength(bFILE);
    }

    public synchronized long length(BLOB bLOB) throws SQLException {
        return this.m_dbaccess.lobLength(bLOB);
    }

    public synchronized long length(CLOB cLOB) throws SQLException {
        return this.m_dbaccess.lobLength(cLOB);
    }

    public synchronized void openFile(BFILE bFILE) throws SQLException {
        this.m_dbaccess.fileOpen(bFILE);
    }

    public synchronized long position(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (bFILE2 == null) {
            return -1L;
        }
        long l2 = this.m_dbaccess.isSubLob(bFILE, bFILE2, l);
        return l2 == 0L ? -1L : l2;
    }

    public synchronized long position(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l2 = this.m_dbaccess.hasPattern(bFILE, byArray, l);
        return l2 == 0L ? -1L : l2;
    }

    public synchronized long position(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        if (l < 1L) {
            DBError.throwSqlException(68, "position()");
        }
        if (bLOB2 == null) {
            return -1L;
        }
        long l2 = this.m_dbaccess.isSubLob(bLOB, bLOB2, l);
        return l2 == 0L ? -1L : l2;
    }

    public synchronized long position(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            DBError.throwSqlException(68, "position()");
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l2 = this.m_dbaccess.hasPattern(bLOB, byArray, l);
        return l2 == 0L ? -1L : l2;
    }

    public synchronized long position(CLOB cLOB, String string, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (string == null || string.length() == 0) {
            return -1L;
        }
        long l2 = this.m_dbaccess.hasPattern(cLOB, string.toCharArray(), l);
        return l2 == 0L ? -1L : l2;
    }

    public synchronized long position(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position");
        }
        if (cLOB2 == null) {
            return -1L;
        }
        long l2 = this.m_dbaccess.isSubLob(cLOB, cLOB2, l);
        return l2 == 0L ? -1L : l2;
    }

    public synchronized int putBytes(BLOB bLOB, long l, byte[] byArray) throws SQLException {
        if (l < 1L) {
            DBError.throwSqlException(68, "putBytes()");
        }
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobWrite(bLOB, l, byArray);
    }

    public synchronized int putChars(CLOB cLOB, long l, char[] cArray) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putChars()");
        }
        if (cArray == null || cArray.length < 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobWrite(cLOB, l, cArray);
    }
}

