/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter;

public abstract class CharacterConverterLC
extends CharacterConverter {
    static final int MAX_7BIT = 127;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int ORACHARWITHLCWIDTH = 32;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int LOW16BITMASK = 65535;
    static final int BELOW_CJK = 12287;
    static final int INVALID_ORA_CHAR = 65535;
    static final int LEADINGCODEWIDTH = 16;
    static final int LEADINGCODESHIFT = 16;
    static final int LEADINGCODEMASK = 65535;
    static final int LCINDEXWIDTH = 4;
    static final int LCINDEXMASK = 15;
    static final int LCINDEXFACTOR = 2;
    static final int MAXBYTEPERCHAR = 4;
    transient int m_ucsL1KeyWidth;
    transient int m_oraL1KeyWidth;
    transient char[][] m_ucsCharLeadingCode;
    transient char[] m_ucsCharLevel1;
    transient char[] m_ucsCharLevel2;
    transient char m_ucsCharReplacement;
    transient char m_1ByteOraCharReplacement;
    transient char m_2ByteOraCharReplacement;
    transient int m_ucsL1KeyShift;
    transient int m_ucsL1KeyMask;
    transient int m_ucsL2KeyMask;
    transient int m_oraL1KeyShift;
    transient int m_oraL1KeyMask;
    transient int m_oraL2KeyMask;
    transient char[] m_oraCharLevel1;
    transient char[] m_oraCharLevel2;
    transient byte[] m_oraLcIndex;

    CharacterConverterLC() {
        this.m_groupId = 4;
    }

    protected void buildUnicodeToOracleMapping(int[][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.m_ucsL1KeyShift = 16 - this.m_ucsL1KeyWidth;
        this.m_ucsL1KeyMask = (1 << this.m_ucsL1KeyWidth) - 1;
        this.m_ucsL2KeyMask = (1 << this.m_ucsL1KeyShift) - 1;
        int n7 = this.m_oraL1KeyWidth;
        int n8 = 16 - n7;
        int n9 = (1 << n7) - 1;
        int n10 = (1 << n8) - 1;
        this.m_oraL1KeyShift = n8;
        this.m_oraL1KeyMask = n9;
        this.m_oraL2KeyMask = n10;
        int n11 = 1 << n7;
        char[] cArray = new char[n11];
        char[][] cArray2 = new char[n11][2];
        int n12 = 0;
        while (n12 < n11) {
            cArray[n12] = '\u0000';
            cArray2[n12][0] = (char)n10;
            cArray2[n12][1] = '\u0000';
            ++n12;
        }
        int n13 = 65536;
        char c = this.m_ucsCharReplacement;
        int n14 = 0;
        while (n14 < this.m_ucsCharLeadingCode.length) {
            n6 = this.m_ucsCharLeadingCode[n14][0];
            n12 = 0;
            while (n12 < n13) {
                n5 = this.toUnicodeWithReplacement(n12 | n6 << 16);
                if (n5 != c) {
                    n4 = n5 >> n8 & n9;
                    cArray[n4] = '\u0001';
                    n3 = n5 & n10;
                    if (n3 < cArray2[n4][0]) {
                        cArray2[n4][0] = (char)n3;
                    }
                    if (n3 > cArray2[n4][1]) {
                        cArray2[n4][1] = (char)n3;
                    }
                }
                ++n12;
            }
            ++n14;
        }
        if (nArray != null) {
            n13 = nArray.length;
            n12 = 0;
            while (n12 < n13) {
                n5 = nArray[n12][0];
                n4 = n5 >> n8 & n9;
                cArray[n4] = '\u0001';
                n3 = n5 & n10;
                if (n3 < cArray2[n4][0]) {
                    cArray2[n4][0] = (char)n3;
                }
                if (n3 > cArray2[n4][1]) {
                    cArray2[n4][1] = (char)n3;
                }
                ++n12;
            }
        }
        int n15 = n2 = n10 + 1;
        int n16 = 0;
        n12 = 0;
        while (n12 < n11) {
            if (cArray[n12] != '\u0000') {
                int n17 = cArray2[n12][0];
                cArray[n12] = (char)(n15 - (n16 < n17 ? n16 : n17));
                n15 = cArray[n12] + n2;
                n16 = n2 - cArray2[n12][1] - 1;
            }
            ++n12;
        }
        char[] cArray3 = new char[n15];
        byte[] byArray = new byte[(n15 + 1) / 2];
        n12 = 0;
        while (n12 < n15) {
            cArray3[n12] = 65535;
            if (n12 % 2 == 0) {
                byArray[n12 / 2] = 0;
            }
            ++n12;
        }
        n13 = 65536;
        n14 = 0;
        while (n14 < this.m_ucsCharLeadingCode.length) {
            n6 = this.m_ucsCharLeadingCode[n14][0];
            n12 = 0;
            while (n12 < n13) {
                n5 = this.toUnicodeWithReplacement(n6 << 16 | n12);
                if (n5 != c) {
                    n4 = n5 >> n8 & n9;
                    n3 = n5 & n10;
                    n = cArray[n4] + n3;
                    if (cArray3[n] == '\uffff') {
                        cArray3[n] = (char)n12;
                    }
                    int n18 = n / 2;
                    byArray[n18] = (byte)(byArray[n18] | n14 << n % 2 * 4);
                }
                ++n12;
            }
            ++n14;
        }
        if (nArray != null) {
            n13 = nArray.length;
            n12 = 0;
            while (n12 < n13) {
                n5 = nArray[n12][0];
                n4 = n5 >> n8 & n9;
                n3 = n5 & n10;
                n = cArray[n4] + n3;
                if (cArray3[n] == '\uffff') {
                    cArray3[n] = (char)nArray[n12][1];
                }
                n6 = nArray[n12][1] >> 16 & 0xFFFF;
                n14 = 0;
                while (n14 < this.m_ucsCharLeadingCode.length) {
                    if (n6 == this.m_ucsCharLeadingCode[n14][0]) {
                        int n19 = n / 2;
                        byArray[n19] = (byte)(byArray[n19] | n14 << n % 2 * 4);
                        break;
                    }
                    ++n14;
                }
                ++n12;
            }
        }
        this.m_oraCharLevel1 = cArray;
        this.m_oraCharLevel2 = cArray3;
        this.m_oraLcIndex = byArray;
    }

    public char[] getLeadingCodes() {
        char[] cArray = new char[this.m_ucsCharLeadingCode.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = this.m_ucsCharLeadingCode[n][0];
            ++n;
        }
        return cArray;
    }

    int toOracleCharacter(char c) throws SQLException {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        int n3 = this.m_oraCharLevel1[n] + n2;
        int n4 = this.m_oraCharLevel2[n3];
        int n5 = this.m_oraLcIndex[n3 / 2] >> n3 % 2 * 4 & 0xF;
        char c2 = this.m_ucsCharLeadingCode[n5][0];
        if (c2 != '\u0000') {
            n4 |= c2 << 16;
        }
        if (n4 == 65535) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return n4;
    }

    int toOracleCharacterWithReplacement(char c) {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        int n3 = this.m_oraCharLevel1[n] + n2;
        int n4 = this.m_oraCharLevel2[n3];
        int n5 = this.m_oraLcIndex[n3 / 2] >> n3 % 2 * 4 & 0xF;
        char c2 = this.m_ucsCharLeadingCode[n5][0];
        if (c2 != '\u0000') {
            n4 |= c2 << 16;
        }
        if (n4 == 65535) {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return n4;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = n * 4;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = this.toOracleCharacter(cArray[n4]);
            int n7 = n6 >> 16 & 0xFFFF;
            if (n7 != 0) {
                n5 = n7 & 0xFF00;
                if (n5 != 0) {
                    byArray[n3++] = (byte)(n5 >> 8);
                }
                byArray[n3++] = (byte)n7;
                byArray[n3++] = (byte)(n6 >> 8);
            } else {
                n5 = n6 & 0xFF00;
                if (n5 != 0) {
                    byArray[n3++] = (byte)(n5 >> 8);
                }
            }
            byArray[n3++] = (byte)n6;
            ++n4;
        }
        if (n3 < n2) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = n * 4;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = this.toOracleCharacterWithReplacement(cArray[n4]);
            int n7 = n6 >> 16 & 0xFFFF;
            if (n7 != 0) {
                n5 = n7 & 0xFF00;
                if (n5 != 0) {
                    byArray[n3++] = (byte)(n5 >> 8);
                }
                byArray[n3++] = (byte)n7;
                byArray[n3++] = (byte)(n6 >> 8);
            } else {
                n5 = n6 & 0xFF00;
                if (n5 != 0) {
                    byArray[n3++] = (byte)(n5 >> 8);
                }
            }
            byArray[n3++] = (byte)n6;
            ++n4;
        }
        if (n3 < n2) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    char toUnicode(int n) throws SQLException {
        int n2 = 0;
        int n3 = n >> 16 & 0xFFFF;
        int n4 = 0;
        while (n4 < this.m_ucsCharLeadingCode.length) {
            if (n3 == this.m_ucsCharLeadingCode[n4][0]) {
                n2 = this.m_ucsCharLeadingCode[n4][1];
                break;
            }
            ++n4;
        }
        if (n4 == this.m_ucsCharLeadingCode.length) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n5 = (n >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + n2;
        int n6 = n & this.m_ucsL2KeyMask;
        char c = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6];
        if (c == this.m_ucsCharReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c;
    }

    char toUnicodeWithReplacement(int n) {
        int n2 = 0;
        int n3 = n >> 16 & 0xFFFF;
        int n4 = 0;
        while (n4 < this.m_ucsCharLeadingCode.length) {
            if (n3 == this.m_ucsCharLeadingCode[n4][0]) {
                n2 = this.m_ucsCharLeadingCode[n4][1];
                break;
            }
            ++n4;
        }
        if (n4 == this.m_ucsCharLeadingCode.length) {
            return this.m_ucsCharReplacement;
        }
        int n5 = (n >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + n2;
        int n6 = n & this.m_ucsL2KeyMask;
        return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6];
    }
}

