/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverterLC;

public abstract class CharacterConverterLCFixed
extends CharacterConverterLC {
    static final int ORACHARBYTECNT = 4;
    transient int m_4ByteOraCharReplacement;

    CharacterConverterLCFixed() {
        this.m_groupId = 5;
    }

    int toOracleCharacter(char c) throws SQLException {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        int n3 = this.m_oraCharLevel1[n] + n2;
        int n4 = this.m_oraCharLevel2[n3];
        int n5 = this.m_oraLcIndex[n3 / 2] >> n3 % 2 * 4 & 0xF;
        char c2 = this.m_ucsCharLeadingCode[n5][0];
        if (c2 != '\u0000') {
            n4 |= c2 << 16;
        }
        if (n4 == 65535) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return n4;
    }

    int toOracleCharacterWithReplacement(char c) {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        int n3 = this.m_oraCharLevel1[n] + n2;
        int n4 = this.m_oraCharLevel2[n3];
        int n5 = this.m_oraLcIndex[n3 / 2] >> n3 % 2 * 4 & 0xF;
        char c2 = this.m_ucsCharLeadingCode[n5][0];
        if (c2 != '\u0000') {
            n4 |= c2 << 16;
        }
        if (n4 == 65535) {
            return this.m_4ByteOraCharReplacement;
        }
        return n4;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 < 1 || byArray.length < 1) {
            return new String();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        if (n2 >= 4) {
            int n4 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
            int n5 = 0;
            while (n5 < this.m_ucsCharLeadingCode.length) {
                if (n4 == this.m_ucsCharLeadingCode[n5][0]) {
                    int n6 = byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
                    char c = this.m_ucsCharLeadingCode[n5][1];
                    int n7 = (n6 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + c;
                    int n8 = n6 & this.m_ucsL2KeyMask;
                    char c2 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8];
                    if (c2 == this.m_ucsCharReplacement) {
                        throw new SQLException("Cannot map Oracle character to Unicode.");
                    }
                    cArray[n3++] = c2;
                    n2 -= 4;
                    n += 4;
                    break;
                }
                ++n5;
            }
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        if (n2 != 0) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return new String(cArray, 0, n3);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        if (n2 < 1 || byArray.length < 1) {
            return new String();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n2 >= 4) {
            int n4 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
            char c = this.m_ucsCharReplacement;
            int n5 = 0;
            while (n5 < this.m_ucsCharLeadingCode.length) {
                if (n4 == this.m_ucsCharLeadingCode[n5][0]) {
                    char c2 = this.m_ucsCharLeadingCode[n5][1];
                    int n6 = byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
                    int n7 = (n6 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + c2;
                    int n8 = n6 & this.m_ucsL2KeyMask;
                    c = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8];
                    break;
                }
                ++n5;
            }
            cArray[n3++] = c;
            n2 -= 4;
            n += 4;
        }
        return new String(cArray, 0, n3);
    }
}

