/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.statistics.Statistics;
import parquet.format.Util;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.Footer;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.io.ParquetEncodingException;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.TypeUtil;

public class ParquetFileWriter {
    private static final Log LOG = Log.getLog(ParquetFileWriter.class);
    private static ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter();
    public static final String PARQUET_METADATA_FILE = "_metadata";
    public static final String PARQUET_COMMON_METADATA_FILE = "_common_metadata";
    public static final byte[] MAGIC = "PAR1".getBytes(Charset.forName("ASCII"));
    public static final int CURRENT_VERSION = 1;
    private static final int DFS_BUFFER_SIZE_DEFAULT = 4096;
    static final Set<String> BLOCK_FS_SCHEMES = new HashSet<String>();
    private final MessageType schema;
    private final FSDataOutputStream out;
    private final AlignmentStrategy alignment;
    private BlockMetaData currentBlock;
    private long currentRecordCount;
    private List<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
    private long uncompressedLength;
    private long compressedLength;
    private Set<Encoding> currentEncodings;
    private CompressionCodecName currentChunkCodec;
    private ColumnPath currentChunkPath;
    private PrimitiveType.PrimitiveTypeName currentChunkType;
    private long currentChunkFirstDataPage;
    private long currentChunkDictionaryPageOffset;
    private long currentChunkValueCount;
    private Statistics currentStatistics;
    private STATE state = STATE.NOT_STARTED;

    private static boolean supportsBlockSize(FileSystem fs) {
        return BLOCK_FS_SCHEMES.contains(fs.getUri().getScheme());
    }

    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file) throws IOException {
        this(configuration, schema, file, Mode.CREATE, 0x8000000L, 0x800000);
    }

    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file, Mode mode) throws IOException {
        this(configuration, schema, file, mode, 0x8000000L, 0x800000);
    }

    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file, Mode mode, long rowGroupSize, int maxPaddingSize) throws IOException {
        boolean overwriteFlag;
        TypeUtil.checkValidWriteSchema(schema);
        this.schema = schema;
        FileSystem fs = file.getFileSystem(configuration);
        boolean bl = overwriteFlag = mode == Mode.OVERWRITE;
        if (ParquetFileWriter.supportsBlockSize(fs)) {
            long dfsBlockSize = Math.max(fs.getDefaultBlockSize(file), rowGroupSize);
            this.alignment = PaddingAlignment.get(dfsBlockSize, rowGroupSize, maxPaddingSize);
            this.out = fs.create(file, overwriteFlag, 4096, fs.getDefaultReplication(file), dfsBlockSize);
        } else {
            this.alignment = NoAlignment.get(rowGroupSize);
            this.out = fs.create(file, overwriteFlag);
        }
    }

    ParquetFileWriter(Configuration configuration, MessageType schema, Path file, long rowAndBlockSize, int maxPaddingSize) throws IOException {
        FileSystem fs = file.getFileSystem(configuration);
        this.schema = schema;
        this.alignment = PaddingAlignment.get(rowAndBlockSize, rowAndBlockSize, maxPaddingSize);
        this.out = fs.create(file, true, 4096, fs.getDefaultReplication(file), rowAndBlockSize);
    }

    public void start() throws IOException {
        this.state = this.state.start();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": start");
        }
        this.out.write(MAGIC);
    }

    public void startBlock(long recordCount) throws IOException {
        this.state = this.state.startBlock();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": start block");
        }
        this.alignment.alignForRowGroup(this.out);
        this.currentBlock = new BlockMetaData();
        this.currentRecordCount = recordCount;
    }

    public void startColumn(ColumnDescriptor descriptor, long valueCount, CompressionCodecName compressionCodecName) throws IOException {
        this.state = this.state.startColumn();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": start column: " + descriptor + " count=" + valueCount);
        }
        this.currentEncodings = new HashSet<Encoding>();
        this.currentChunkPath = ColumnPath.get(descriptor.getPath());
        this.currentChunkType = descriptor.getType();
        this.currentChunkCodec = compressionCodecName;
        this.currentChunkValueCount = valueCount;
        this.currentChunkFirstDataPage = this.out.getPos();
        this.compressedLength = 0L;
        this.uncompressedLength = 0L;
        this.currentStatistics = Statistics.getStatsBasedOnType(this.currentChunkType);
    }

    public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
        this.state = this.state.write();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": write dictionary page: " + dictionaryPage.getDictionarySize() + " values");
        }
        this.currentChunkDictionaryPageOffset = this.out.getPos();
        int uncompressedSize = dictionaryPage.getUncompressedSize();
        int compressedPageSize = (int)dictionaryPage.getBytes().size();
        metadataConverter.writeDictionaryPageHeader(uncompressedSize, compressedPageSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), (OutputStream)this.out);
        long headerSize = this.out.getPos() - this.currentChunkDictionaryPageOffset;
        this.uncompressedLength += (long)uncompressedSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": write dictionary page content " + compressedPageSize);
        }
        dictionaryPage.getBytes().writeAllTo((OutputStream)this.out);
        this.currentEncodings.add(dictionaryPage.getEncoding());
    }

    @Deprecated
    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.state = this.state.write();
        long beforeHeader = this.out.getPos();
        if (Log.DEBUG) {
            LOG.debug(beforeHeader + ": write data page: " + valueCount + " values");
        }
        int compressedPageSize = (int)bytes.size();
        metadataConverter.writeDataPageHeader(uncompressedPageSize, compressedPageSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, (OutputStream)this.out);
        long headerSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedPageSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": write data page content " + compressedPageSize);
        }
        bytes.writeAllTo((OutputStream)this.out);
        this.currentEncodings.add(rlEncoding);
        this.currentEncodings.add(dlEncoding);
        this.currentEncodings.add(valuesEncoding);
    }

    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.state = this.state.write();
        long beforeHeader = this.out.getPos();
        if (Log.DEBUG) {
            LOG.debug(beforeHeader + ": write data page: " + valueCount + " values");
        }
        int compressedPageSize = (int)bytes.size();
        metadataConverter.writeDataPageHeader(uncompressedPageSize, compressedPageSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding, (OutputStream)this.out);
        long headerSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedPageSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": write data page content " + compressedPageSize);
        }
        bytes.writeAllTo((OutputStream)this.out);
        this.currentStatistics.mergeStatistics(statistics);
        this.currentEncodings.add(rlEncoding);
        this.currentEncodings.add(dlEncoding);
        this.currentEncodings.add(valuesEncoding);
    }

    void writeDataPages(BytesInput bytes, long uncompressedTotalPageSize, long compressedTotalPageSize, Statistics totalStats, List<Encoding> encodings) throws IOException {
        this.state = this.state.write();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": write data pages");
        }
        long headersSize = bytes.size() - compressedTotalPageSize;
        this.uncompressedLength += uncompressedTotalPageSize + headersSize;
        this.compressedLength += compressedTotalPageSize + headersSize;
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": write data pages content");
        }
        bytes.writeAllTo((OutputStream)this.out);
        this.currentEncodings.addAll(encodings);
        this.currentStatistics = totalStats;
    }

    public void endColumn() throws IOException {
        this.state = this.state.endColumn();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": end column");
        }
        this.currentBlock.addColumn(ColumnChunkMetaData.get(this.currentChunkPath, this.currentChunkType, this.currentChunkCodec, this.currentEncodings, this.currentStatistics, this.currentChunkFirstDataPage, this.currentChunkDictionaryPageOffset, this.currentChunkValueCount, this.compressedLength, this.uncompressedLength));
        this.currentBlock.setTotalByteSize(this.currentBlock.getTotalByteSize() + this.uncompressedLength);
        this.uncompressedLength = 0L;
        this.compressedLength = 0L;
    }

    public void endBlock() throws IOException {
        this.state = this.state.endBlock();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": end block");
        }
        this.currentBlock.setRowCount(this.currentRecordCount);
        this.blocks.add(this.currentBlock);
        this.currentBlock = null;
    }

    public void end(Map<String, String> extraMetaData) throws IOException {
        this.state = this.state.end();
        if (Log.DEBUG) {
            LOG.debug(this.out.getPos() + ": end");
        }
        ParquetMetadata footer = new ParquetMetadata(new FileMetaData(this.schema, extraMetaData, "parquet-mr version 1.5.0-cdh5.10.1 (build ${buildNumber})"), this.blocks);
        ParquetFileWriter.serializeFooter(footer, this.out);
        this.out.close();
    }

    private static void serializeFooter(ParquetMetadata footer, FSDataOutputStream out) throws IOException {
        long footerIndex = out.getPos();
        parquet.format.FileMetaData parquetMetadata = metadataConverter.toParquetMetadata(1, footer);
        Util.writeFileMetaData(parquetMetadata, (OutputStream)out);
        if (Log.DEBUG) {
            LOG.debug(out.getPos() + ": footer length = " + (out.getPos() - footerIndex));
        }
        BytesUtils.writeIntLittleEndian((OutputStream)out, (int)(out.getPos() - footerIndex));
        out.write(MAGIC);
    }

    public static void writeMetadataFile(Configuration configuration, Path outputPath, List<Footer> footers) throws IOException {
        FileSystem fs = outputPath.getFileSystem(configuration);
        outputPath = outputPath.makeQualified(fs);
        ParquetMetadata metadataFooter = ParquetFileWriter.mergeFooters(outputPath, footers);
        ParquetFileWriter.writeMetadataFile(outputPath, metadataFooter, fs, PARQUET_METADATA_FILE);
        metadataFooter.getBlocks().clear();
        ParquetFileWriter.writeMetadataFile(outputPath, metadataFooter, fs, PARQUET_COMMON_METADATA_FILE);
    }

    private static void writeMetadataFile(Path outputPath, ParquetMetadata metadataFooter, FileSystem fs, String parquetMetadataFile) throws IOException {
        Path metaDataPath = new Path(outputPath, parquetMetadataFile);
        FSDataOutputStream metadata = fs.create(metaDataPath);
        metadata.write(MAGIC);
        ParquetFileWriter.serializeFooter(metadataFooter, metadata);
        metadata.close();
    }

    static ParquetMetadata mergeFooters(Path root, List<Footer> footers) {
        String rootPath = root.toUri().getPath();
        GlobalMetaData fileMetaData = null;
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        for (Footer footer : footers) {
            String footerPath = footer.getFile().toUri().getPath();
            if (!footerPath.startsWith(rootPath)) {
                throw new ParquetEncodingException(footerPath + " invalid: all the files must be contained in the root " + root);
            }
            footerPath = footerPath.substring(rootPath.length());
            while (footerPath.startsWith("/")) {
                footerPath = footerPath.substring(1);
            }
            fileMetaData = ParquetFileWriter.mergeInto(footer.getParquetMetadata().getFileMetaData(), fileMetaData);
            for (BlockMetaData block : footer.getParquetMetadata().getBlocks()) {
                block.setPath(footerPath);
                blocks.add(block);
            }
        }
        return new ParquetMetadata(fileMetaData.merge(), blocks);
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public long getNextRowGroupSize() throws IOException {
        return this.alignment.nextRowGroupSize(this.out);
    }

    static GlobalMetaData getGlobalMetaData(List<Footer> footers) {
        GlobalMetaData fileMetaData = null;
        for (Footer footer : footers) {
            ParquetMetadata currentMetadata = footer.getParquetMetadata();
            fileMetaData = ParquetFileWriter.mergeInto(currentMetadata.getFileMetaData(), fileMetaData);
        }
        return fileMetaData;
    }

    static GlobalMetaData mergeInto(FileMetaData toMerge, GlobalMetaData mergedMetadata) {
        MessageType schema = null;
        HashMap<String, Set<String>> newKeyValues = new HashMap<String, Set<String>>();
        HashSet<String> createdBy = new HashSet<String>();
        if (mergedMetadata != null) {
            schema = mergedMetadata.getSchema();
            newKeyValues.putAll(mergedMetadata.getKeyValueMetaData());
            createdBy.addAll(mergedMetadata.getCreatedBy());
        }
        if (schema == null && toMerge.getSchema() != null || schema != null && !schema.equals((Object)toMerge.getSchema())) {
            schema = ParquetFileWriter.mergeInto(toMerge.getSchema(), schema);
        }
        for (Map.Entry<String, String> entry : toMerge.getKeyValueMetaData().entrySet()) {
            HashSet<String> values = (HashSet<String>)newKeyValues.get(entry.getKey());
            if (values == null) {
                values = new HashSet<String>();
                newKeyValues.put(entry.getKey(), values);
            }
            values.add(entry.getValue());
        }
        createdBy.add(toMerge.getCreatedBy());
        return new GlobalMetaData(schema, newKeyValues, createdBy);
    }

    static MessageType mergeInto(MessageType toMerge, MessageType mergedSchema) {
        if (mergedSchema == null) {
            return toMerge;
        }
        return mergedSchema.union(toMerge);
    }

    static {
        BLOCK_FS_SCHEMES.add("hdfs");
        BLOCK_FS_SCHEMES.add("webhdfs");
        BLOCK_FS_SCHEMES.add("viewfs");
    }

    private static class PaddingAlignment
    implements AlignmentStrategy {
        private static final byte[] zeros = new byte[4096];
        protected final long dfsBlockSize;
        protected final long rowGroupSize;
        protected final int maxPaddingSize;

        public static PaddingAlignment get(long dfsBlockSize, long rowGroupSize, int maxPaddingSize) {
            return new PaddingAlignment(dfsBlockSize, rowGroupSize, maxPaddingSize);
        }

        private PaddingAlignment(long dfsBlockSize, long rowGroupSize, int maxPaddingSize) {
            this.dfsBlockSize = dfsBlockSize;
            this.rowGroupSize = rowGroupSize;
            this.maxPaddingSize = maxPaddingSize;
        }

        @Override
        public void alignForRowGroup(FSDataOutputStream out) throws IOException {
            long remaining = this.dfsBlockSize - out.getPos() % this.dfsBlockSize;
            if (this.isPaddingNeeded(remaining)) {
                if (Log.DEBUG) {
                    LOG.debug("Adding " + remaining + " bytes of padding (" + "row group size=" + this.rowGroupSize + "B, " + "block size=" + this.dfsBlockSize + "B)");
                }
                while (remaining > 0L) {
                    out.write(zeros, 0, (int)Math.min((long)zeros.length, remaining));
                    remaining -= (long)zeros.length;
                }
            }
        }

        @Override
        public long nextRowGroupSize(FSDataOutputStream out) throws IOException {
            if (this.maxPaddingSize <= 0) {
                return this.rowGroupSize;
            }
            long remaining = this.dfsBlockSize - out.getPos() % this.dfsBlockSize;
            if (this.isPaddingNeeded(remaining)) {
                return this.rowGroupSize;
            }
            return Math.min(remaining, this.rowGroupSize);
        }

        protected boolean isPaddingNeeded(long remaining) {
            return remaining <= (long)this.maxPaddingSize;
        }
    }

    private static class NoAlignment
    implements AlignmentStrategy {
        private final long rowGroupSize;

        public static NoAlignment get(long rowGroupSize) {
            return new NoAlignment(rowGroupSize);
        }

        private NoAlignment(long rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
        }

        @Override
        public void alignForRowGroup(FSDataOutputStream out) {
        }

        @Override
        public long nextRowGroupSize(FSDataOutputStream out) {
            return this.rowGroupSize;
        }
    }

    private static interface AlignmentStrategy {
        public void alignForRowGroup(FSDataOutputStream var1) throws IOException;

        public long nextRowGroupSize(FSDataOutputStream var1) throws IOException;
    }

    private static enum STATE {
        NOT_STARTED{

            @Override
            STATE start() {
                return STARTED;
            }
        }
        ,
        STARTED{

            @Override
            STATE startBlock() {
                return BLOCK;
            }

            @Override
            STATE end() {
                return ENDED;
            }
        }
        ,
        BLOCK{

            @Override
            STATE startColumn() {
                return COLUMN;
            }

            @Override
            STATE endBlock() {
                return STARTED;
            }
        }
        ,
        COLUMN{

            @Override
            STATE endColumn() {
                return BLOCK;
            }

            @Override
            STATE write() {
                return this;
            }
        }
        ,
        ENDED;


        STATE start() throws IOException {
            return this.error();
        }

        STATE startBlock() throws IOException {
            return this.error();
        }

        STATE startColumn() throws IOException {
            return this.error();
        }

        STATE write() throws IOException {
            return this.error();
        }

        STATE endColumn() throws IOException {
            return this.error();
        }

        STATE endBlock() throws IOException {
            return this.error();
        }

        STATE end() throws IOException {
            return this.error();
        }

        private final STATE error() throws IOException {
            throw new IOException("The file being written is in an invalid state. Probably caused by an error thrown previously. Current state: " + this.name());
        }
    }

    public static enum Mode {
        CREATE,
        OVERWRITE;

    }
}

