/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AlgebraicMathBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class AlgebraicIntMathBase
extends AlgebraicMathBase<Integer>
implements Accumulator<Integer> {
    private Integer intermediateVal = null;

    protected static Integer getSeed(AlgebraicMathBase.KNOWN_OP op) {
        switch (op) {
            case SUM: {
                return 0;
            }
            case MIN: {
                return Integer.MAX_VALUE;
            }
            case MAX: {
                return Integer.MIN_VALUE;
            }
        }
        return null;
    }

    private static Integer doWork(Integer arg1, Integer arg2, AlgebraicMathBase.KNOWN_OP op) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        switch (op) {
            case MAX: {
                return Math.max(arg1, arg2);
            }
            case MIN: {
                return Math.min(arg1, arg2);
            }
            case SUM: {
                return arg1 + arg2;
            }
        }
        return null;
    }

    protected static Integer doTupleWork(Tuple input, AlgebraicMathBase.KnownOpProvider opProvider) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        int sofar = AlgebraicIntMathBase.getSeed(opProvider.getOp());
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Integer d = (Integer)t.get(0);
                if (d == null) continue;
                sawNonNull = true;
                sofar = AlgebraicIntMathBase.doWork(sofar, d, opProvider.getOp());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                throw new ExecException("Problem doing work on Doubles", errCode, 4, exp);
            }
        }
        return sawNonNull ? Integer.valueOf(sofar) : null;
    }

    @Override
    public Integer exec(Tuple input) throws IOException {
        try {
            return AlgebraicIntMathBase.doTupleWork(input, this.opProvider);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Doubles", errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 10));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Integer curVal = AlgebraicIntMathBase.doTupleWork(b, this.opProvider);
            if (curVal == null) {
                return;
            }
            if (this.intermediateVal == null) {
                this.intermediateVal = AlgebraicIntMathBase.getSeed(this.opProvider.getOp());
            }
            this.intermediateVal = AlgebraicIntMathBase.doWork(this.intermediateVal, curVal, this.opProvider.getOp());
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Doubles", errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateVal = null;
    }

    @Override
    public Integer getValue() {
        return this.intermediateVal;
    }

    public static abstract class Final
    extends AlgebraicMathBase.Final<Integer> {
        @Override
        public Integer exec(Tuple input) throws IOException {
            try {
                return AlgebraicIntMathBase.doTupleWork(input, this);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function ", errCode, 4, e);
            }
        }
    }

    public static abstract class Intermediate
    extends AlgebraicMathBase.Intermediate {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(AlgebraicIntMathBase.doTupleWork(input, this));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function ", errCode, 4, e);
            }
        }
    }
}

