/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.FilterFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public class Bloom
extends FilterFunc {
    private String bloomFile;
    public BloomFilter filter = null;

    public Bloom(String filename) {
        this.bloomFile = filename;
    }

    @Override
    public Boolean exec(Tuple input) throws IOException {
        if (this.filter == null) {
            this.init();
        }
        byte[] b = input.size() == 1 ? DataType.toBytes(input.get(0)) : DataType.toBytes(input, (byte)110);
        Key k = new Key(b);
        return this.filter.membershipTest(k);
    }

    @Override
    public List<String> getCacheFiles() {
        ArrayList<String> list = new ArrayList<String>(1);
        try {
            list.add(this.bloomFile + "#" + this.getFilenameFromPath(this.bloomFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private void init() throws IOException {
        this.filter = new BloomFilter();
        String dcFile = "./" + this.getFilenameFromPath(this.bloomFile) + "/part-r-00000";
        this.filter.readFields((DataInput)new DataInputStream(new FileInputStream(dcFile)));
    }

    public void setFilter(DataByteArray dba) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dba.get()));
        this.filter = new BloomFilter();
        this.filter.readFields((DataInput)dis);
    }

    private String getFilenameFromPath(String p) throws IOException {
        return p.replace("/", "_");
    }
}

