/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.pig.LoadCaster;
import org.apache.pig.PigToStream;
import org.apache.pig.StreamToPig;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.StorageUtil;

public class PigStreaming
implements PigToStream,
StreamToPig {
    private byte recordDel = (byte)10;
    private byte fieldDel = (byte)9;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public PigStreaming() {
    }

    public PigStreaming(String delimiter) {
        this();
        this.fieldDel = StorageUtil.parseFieldDel(delimiter);
    }

    @Override
    public byte[] serialize(Tuple t) throws IOException {
        this.out.reset();
        int sz = t.size();
        for (int i = 0; i < sz; ++i) {
            Object field = t.get(i);
            StorageUtil.putField(this.out, field);
            if (i == sz - 1) {
                this.out.write(this.recordDel);
                continue;
            }
            this.out.write(this.fieldDel);
        }
        return this.out.toByteArray();
    }

    @Override
    public Tuple deserialize(byte[] bytes) throws IOException {
        Text val = new Text(bytes);
        return StorageUtil.textToTuple(val, this.fieldDel);
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return new Utf8StorageConverter();
    }
}

