/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.pig.StreamToPig;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.BufferedPositionedInputStream;

public abstract class OutputHandler {
    protected StreamToPig deserializer;
    protected LineReader in = null;
    private BufferedPositionedInputStream istream;
    protected boolean alreadyClosed = false;

    public abstract OutputType getOutputType();

    public void bindTo(String fileName, BufferedPositionedInputStream is, long offset, long end) throws IOException {
        this.istream = is;
        this.in = new LineReader((InputStream)this.istream);
    }

    public Tuple getNext() throws IOException {
        if (this.in == null) {
            return null;
        }
        Text value = new Text();
        int num = this.in.readLine(value);
        if (num <= 0) {
            return null;
        }
        byte[] newBytes = new byte[value.getLength()];
        System.arraycopy(value.getBytes(), 0, newBytes, 0, value.getLength());
        return this.deserializer.deserialize(newBytes);
    }

    public synchronized void close() throws IOException {
        if (!this.alreadyClosed) {
            this.istream.close();
            this.istream = null;
            this.alreadyClosed = true;
        }
    }

    public static enum OutputType {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

