/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import com.google.common.collect.Multimaps;
import dk.brics.automaton.Automaton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.antlr.runtime.CommonTokenStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.impl.PigContext;
import org.apache.tools.bzip2r.BZip2Constants;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.joda.time.DateTime;

public class JarManager {
    private static Log log = LogFactory.getLog(JarManager.class);

    public static void createJar(OutputStream os, Set<String> funcs, PigContext pigContext) throws ClassNotFoundException, IOException {
        InputStream stream;
        Vector<JarListEntry> jarList = new Vector<JarListEntry>();
        for (DefaultPigPackages pkgToSend : DefaultPigPackages.values()) {
            JarManager.addContainingJar(jarList, pkgToSend.getPkgClass(), pkgToSend.getPkgPrefix(), pigContext);
        }
        for (String func : funcs) {
            Class clazz = pigContext.getClassForAlias(func);
            if (clazz == null) continue;
            JarManager.addContainingJar(jarList, clazz, null, pigContext);
        }
        HashMap<String, String> contents = new HashMap<String, String>();
        JarOutputStream jarFile = new JarOutputStream(os);
        for (JarListEntry jarEntry : jarList) {
            JarManager.mergeJar(jarFile, jarEntry.jar, jarEntry.prefix, contents);
        }
        for (String string : pigContext.scriptJars) {
            JarManager.mergeJar(jarFile, string, null, contents);
        }
        for (String string : pigContext.scriptFiles) {
            log.debug((Object)("Adding entry " + string + " to job jar"));
            stream = null;
            stream = new File(string).exists() ? new FileInputStream(new File(string)) : PigContext.getClassLoader().getResourceAsStream(string);
            if (stream == null) {
                throw new IOException("Cannot find " + string);
            }
            JarManager.addStream(jarFile, string, stream, contents);
        }
        for (Map.Entry entry : pigContext.getScriptFiles().entrySet()) {
            log.debug((Object)("Adding entry " + (String)entry.getKey() + " to job jar"));
            stream = null;
            stream = ((File)entry.getValue()).exists() ? new FileInputStream((File)entry.getValue()) : PigContext.getClassLoader().getResourceAsStream(((File)entry.getValue()).getPath());
            if (stream == null) {
                throw new IOException("Cannot find " + ((File)entry.getValue()).getPath());
            }
            JarManager.addStream(jarFile, (String)entry.getKey(), stream, contents);
        }
        log.debug((Object)"Adding entry pigContext to job jar");
        jarFile.putNextEntry(new ZipEntry("pigContext"));
        new ObjectOutputStream(jarFile).writeObject(pigContext);
        jarFile.close();
    }

    static ClassLoader createCl(String jarFile, PigContext pigContext) throws MalformedURLException {
        int len = pigContext.extraJars.size();
        int passedJar = jarFile == null ? 0 : 1;
        URL[] urls = new URL[len + passedJar];
        if (jarFile != null) {
            urls[0] = new URL("file:" + jarFile);
        }
        for (int i = 0; i < pigContext.extraJars.size(); ++i) {
            urls[i + passedJar] = new URL("file:" + pigContext.extraJars.get(i));
        }
        return new URLClassLoader(urls, PigMapReduce.class.getClassLoader());
    }

    private static void mergeJar(JarOutputStream jarFile, String jar, String prefix, Map<String, String> contents) throws FileNotFoundException, IOException {
        JarInputStream jarInput = new JarInputStream(new FileInputStream(jar));
        log.debug((Object)("Adding jar " + jar + (prefix != null ? " for prefix " + prefix : "") + " to job jar"));
        JarManager.mergeJar(jarFile, jarInput, prefix, contents);
    }

    private static void mergeJar(JarOutputStream jarFile, URL jar, String prefix, Map<String, String> contents) throws FileNotFoundException, IOException {
        JarInputStream jarInput = new JarInputStream(jar.openStream());
        JarManager.mergeJar(jarFile, jarInput, prefix, contents);
    }

    private static void mergeJar(JarOutputStream jarFile, JarInputStream jarInput, String prefix, Map<String, String> contents) throws FileNotFoundException, IOException {
        JarEntry entry;
        while ((entry = jarInput.getNextJarEntry()) != null) {
            if (prefix != null && !entry.getName().startsWith(prefix)) continue;
            JarManager.addStream(jarFile, entry.getName(), jarInput, contents);
        }
    }

    private static void addStream(JarOutputStream os, String name, InputStream is, Map<String, String> contents) throws IOException {
        int rc;
        if (contents.get(name) != null) {
            return;
        }
        contents.put(name, "");
        os.putNextEntry(new JarEntry(name));
        byte[] buffer = new byte[4096];
        while ((rc = is.read(buffer)) > 0) {
            os.write(buffer, 0, rc);
        }
    }

    private static void addContainingJar(Vector<JarListEntry> jarList, Class clazz, String prefix, PigContext pigContext) {
        String jar = JarManager.findContainingJar(clazz);
        if (pigContext.skipJars.contains(jar) && prefix == null) {
            return;
        }
        if (jar == null) {
            log.warn((Object)("Couldn't find the jar for " + clazz.getName() + ", skip it"));
            return;
        }
        JarListEntry jarListEntry = new JarListEntry(jar, prefix);
        if (!jarList.contains(jarListEntry)) {
            jarList.add(jarListEntry);
        }
    }

    public static String findContainingJar(Class my_class) {
        ClassLoader loader = PigContext.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = null;
            if (loader instanceof URLClassLoader) {
                itr = ((URLClassLoader)loader).findResources(class_file);
            }
            if (itr == null || !itr.hasMoreElements()) {
                itr = loader.getResources(class_file);
            }
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static enum DefaultPigPackages {
        PIG("org/apache/pig", PigMapReduce.class),
        BZIP2R("org/apache/tools/bzip2r", BZip2Constants.class),
        AUTOMATON("dk/brics/automaton", Automaton.class),
        ANTLR("org/antlr/runtime", CommonTokenStream.class),
        GUAVA("com/google/common", Multimaps.class),
        JACKSON_CORE("org/codehaus/jackson", JsonPropertyOrder.class),
        JACKSON_MAPPER("org/codehaus/jackson", JacksonStdImpl.class),
        JODATIME("org/joda/time", DateTime.class);

        private final String pkgPrefix;
        private final Class pkgClass;

        private DefaultPigPackages(String pkgPrefix, Class pkgClass) {
            this.pkgPrefix = pkgPrefix;
            this.pkgClass = pkgClass;
        }

        public String getPkgPrefix() {
            return this.pkgPrefix;
        }

        public Class getPkgClass() {
            return this.pkgClass;
        }
    }

    private static class JarListEntry {
        String jar;
        String prefix;

        JarListEntry(String jar, String prefix) {
            this.jar = jar;
            this.prefix = prefix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JarListEntry)) {
                return false;
            }
            JarListEntry other = (JarListEntry)obj;
            if (!this.jar.equals(other.jar)) {
                return false;
            }
            if (this.prefix == null) {
                return other.prefix == null;
            }
            return this.prefix.equals(other.prefix);
        }

        public int hashCode() {
            return this.jar.hashCode() + (this.prefix == null ? 1 : this.prefix.hashCode());
        }
    }
}

