/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.util.Utf8;

public final class AvroMapWrapper
implements Map<CharSequence, Object> {
    private Map<CharSequence, Object> innerMap;

    public AvroMapWrapper(Map<CharSequence, Object> m) {
        this.innerMap = m;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object v = this.innerMap.get(key);
        if (v instanceof Utf8) {
            return v.toString();
        }
        return v;
    }

    @Override
    public Object put(CharSequence key, Object value) {
        return this.innerMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends CharSequence, ? extends Object> m) {
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<CharSequence> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return Collections2.transform(this.innerMap.values(), new Function(){

            public Object apply(Object v) {
                if (v instanceof Utf8) {
                    return v.toString();
                }
                return v;
            }
        });
    }

    @Override
    public Set<Map.Entry<CharSequence, Object>> entrySet() {
        HashSet<Map.Entry<CharSequence, Object>> theSet = Sets.newHashSetWithExpectedSize(this.innerMap.size());
        for (Map.Entry<CharSequence, Object> e : this.innerMap.entrySet()) {
            CharSequence k = e.getKey();
            Object v = e.getValue();
            if (k instanceof Utf8) {
                k = ((Object)k).toString();
            }
            if (v instanceof Utf8) {
                v = v.toString();
            }
            theSet.add(new AbstractMap.SimpleEntry<CharSequence, Object>(k, v));
        }
        return theSet;
    }
}

