/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public final class AvroRecordReader
extends RecordReader<NullWritable, GenericData.Record> {
    private FileReader<GenericData.Record> reader;
    private long start;
    private long end;
    private Schema schema;
    private GenericData.Record currentRecord;

    public AvroRecordReader(Schema s) {
        this.schema = s;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public GenericData.Record getCurrentValue() throws IOException, InterruptedException {
        if (this.currentRecord != null) {
            return this.currentRecord;
        }
        return null;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.reader.tell() - this.start) / (float)(this.end - this.start));
    }

    public void initialize(InputSplit isplit, TaskAttemptContext tc) throws IOException, InterruptedException {
        FileSplit fsplit = (FileSplit)isplit;
        this.start = fsplit.getStart();
        this.end = fsplit.getStart() + fsplit.getLength();
        GenericDatumReader datumReader = new GenericDatumReader(this.schema);
        this.reader = DataFileReader.openReader(new FsInput(fsplit.getPath(), tc.getConfiguration()), datumReader);
        this.reader.sync(this.start);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.reader.pastSync(this.end)) {
            return false;
        }
        try {
            this.currentRecord = this.reader.next(new GenericData.Record(this.schema));
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (IOException ioe) {
            this.reader.sync(this.reader.tell() + 1L);
            throw ioe;
        }
        return true;
    }
}

