/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class ColumnPruneVisitor
extends LogicalRelationalNodesVisitor {
    protected static final Log log = LogFactory.getLog(ColumnPruneVisitor.class);
    private Map<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>> requiredItems = new HashMap<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>>();
    private boolean columnPrune;

    public ColumnPruneVisitor(OperatorPlan plan, Map<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>> requiredItems, boolean columnPrune) throws FrontendException {
        super(plan, new ReverseDependencyOrderWalker(plan));
        this.columnPrune = columnPrune;
        this.requiredItems = requiredItems;
    }

    public void addRequiredItems(LOLoad load, Pair<Map<Integer, Set<String>>, Set<Integer>> requiredItem) {
        this.requiredItems.put(load, requiredItem);
    }

    @Override
    public void visit(LOLoad load) throws FrontendException {
        if (!this.requiredItems.containsKey(load)) {
            return;
        }
        Pair<Map<Integer, Set<String>>, Set<Integer>> required = this.requiredItems.get(load);
        LoadPushDown.RequiredFieldList requiredFields = new LoadPushDown.RequiredFieldList();
        LogicalSchema s = load.getSchema();
        for (int i = 0; i < s.size(); ++i) {
            LoadPushDown.RequiredField requiredField = null;
            if (required.first != null && ((Map)required.first).containsKey(i)) {
                requiredField = new LoadPushDown.RequiredField();
                requiredField.setIndex(i);
                requiredField.setAlias(s.getField((int)i).alias);
                requiredField.setType(s.getField((int)i).type);
                ArrayList<LoadPushDown.RequiredField> subFields = new ArrayList<LoadPushDown.RequiredField>();
                for (String key : (Set)((Map)required.first).get(i)) {
                    LoadPushDown.RequiredField subField = new LoadPushDown.RequiredField(key, -1, null, 50);
                    subFields.add(subField);
                }
                requiredField.setSubFields(subFields);
                requiredFields.add(requiredField);
            }
            if (required.second == null || !((Set)required.second).contains(i)) continue;
            requiredField = new LoadPushDown.RequiredField();
            requiredField.setIndex(i);
            requiredField.setAlias(s.getField((int)i).alias);
            requiredField.setType(s.getField((int)i).type);
            requiredFields.add(requiredField);
        }
        boolean[] columnRequired = new boolean[s.size()];
        for (LoadPushDown.RequiredField rf : requiredFields.getFields()) {
            columnRequired[rf.getIndex()] = true;
        }
        ArrayList<Pair<Integer, Integer>> pruneList = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < columnRequired.length; ++i) {
            if (columnRequired[i]) continue;
            pruneList.add(new Pair<Integer, Integer>(0, i));
        }
        StringBuffer message = new StringBuffer();
        if (pruneList.size() != 0) {
            message.append("Columns pruned for " + load.getAlias() + ": ");
            for (int i = 0; i < pruneList.size(); ++i) {
                message.append("$" + ((Pair)pruneList.get((int)i)).second);
                if (i == pruneList.size() - 1) continue;
                message.append(", ");
            }
            log.info((Object)message);
        }
        message = new StringBuffer();
        for (LoadPushDown.RequiredField rf : requiredFields.getFields()) {
            List<LoadPushDown.RequiredField> sub = rf.getSubFields();
            if (sub == null) continue;
            message.append("Map key required for " + load.getAlias() + ": $" + rf.getIndex() + "->" + sub + "\n");
        }
        if (message.length() != 0) {
            log.info((Object)message);
        }
        LoadPushDown.RequiredFieldResponse response = null;
        try {
            LoadFunc loadFunc = load.getLoadFunc();
            if (loadFunc instanceof LoadPushDown) {
                response = ((LoadPushDown)((Object)loadFunc)).pushProjection(requiredFields);
            }
        }
        catch (FrontendException e) {
            log.warn((Object)("pushProjection on " + load + " throw an exception, skip it"));
        }
        if (this.columnPrune) {
            if (response == null || !response.getRequiredFieldResponse()) {
                LogicalPlan p = (LogicalPlan)load.getPlan();
                Operator next = p.getSuccessors(load).get(0);
                if (next instanceof LOForEach) {
                    return;
                }
                LOForEach foreach = new LOForEach(load.getPlan());
                p.add(foreach);
                p.insertBetween(load, foreach, next);
                LogicalPlan innerPlan = new LogicalPlan();
                foreach.setInnerPlan(innerPlan);
                ArrayList<LogicalExpressionPlan> exps = new ArrayList<LogicalExpressionPlan>();
                LOGenerate gen = new LOGenerate(innerPlan, exps, new boolean[requiredFields.getFields().size()]);
                innerPlan.add(gen);
                for (int i = 0; i < requiredFields.getFields().size(); ++i) {
                    LoadPushDown.RequiredField rf = requiredFields.getFields().get(i);
                    LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, rf.getIndex());
                    innerPlan.add(innerLoad);
                    innerPlan.connect(innerLoad, gen);
                    LogicalExpressionPlan exp = new LogicalExpressionPlan();
                    ProjectExpression prj = new ProjectExpression((OperatorPlan)exp, i, -1, (LogicalRelationalOperator)gen);
                    exp.add(prj);
                    exps.add(exp);
                }
            } else {
                ArrayList<Integer> requiredIndexes = new ArrayList<Integer>();
                List<LoadPushDown.RequiredField> fieldList = requiredFields.getFields();
                for (int i = 0; i < fieldList.size(); ++i) {
                    requiredIndexes.add(fieldList.get(i).getIndex());
                }
                load.setRequiredFields(requiredIndexes);
                LogicalSchema newSchema = new LogicalSchema();
                for (int i = 0; i < fieldList.size(); ++i) {
                    newSchema.addField(s.getField(fieldList.get(i).getIndex()));
                }
                load.setSchema(newSchema);
            }
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
    }

    @Override
    public void visit(LOLimit limit) throws FrontendException {
    }

    @Override
    public void visit(LOSplitOutput splitOutput) throws FrontendException {
    }

    @Override
    public void visit(LOSplit split) throws FrontendException {
        List<Operator> branchOutputs = split.getPlan().getSuccessors(split);
        for (int i = 0; i < branchOutputs.size(); ++i) {
            Operator branchOutput = branchOutputs.get(i);
            Set branchOutputUids = (Set)branchOutput.getAnnotation("ColumnPrune:InputUids");
            if (branchOutputUids == null) continue;
            HashSet<Integer> columnsToDrop = new HashSet<Integer>();
            for (int j = 0; j < split.getSchema().size(); ++j) {
                if (branchOutputUids.contains(split.getSchema().getField((int)j).uid)) continue;
                columnsToDrop.add(j);
            }
            if (columnsToDrop.isEmpty()) continue;
            LOForEach foreach = Util.addForEachAfter((LogicalPlan)split.getPlan(), split, i, columnsToDrop);
            foreach.getSchema();
        }
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
    }

    @Override
    public void visit(LORank rank) throws FrontendException {
    }

    @Override
    public void visit(LOStore store) throws FrontendException {
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        this.addForEachIfNecessary(cg);
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
    }

    @Override
    public void visit(LOCross cross) throws FrontendException {
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        if (!this.columnPrune) {
            return;
        }
        Set inputUids = (Set)foreach.getAnnotation("ColumnPrune:InputUids");
        LogicalPlan innerPlan = foreach.getInnerPlan();
        ArrayList<LOInnerLoad> innerLoads = new ArrayList<LOInnerLoad>();
        List<Operator> sources = innerPlan.getSources();
        for (Operator s : sources) {
            if (!(s instanceof LOInnerLoad)) continue;
            innerLoads.add((LOInnerLoad)s);
        }
        HashSet<LOInnerLoad> innerLoadsToRemove = new HashSet<LOInnerLoad>();
        for (LOInnerLoad innerLoad : innerLoads) {
            ProjectExpression project = innerLoad.getProjection();
            if (project.isProjectStar()) {
                LogicalSchema.LogicalFieldSchema tupleFS = project.getFieldSchema();
                long uid = tupleFS.schema.getField((int)0).uid;
                if (inputUids.contains(uid)) continue;
                innerLoadsToRemove.add(innerLoad);
                continue;
            }
            if (inputUids.contains(project.getFieldSchema().uid)) continue;
            innerLoadsToRemove.add(innerLoad);
        }
        HashSet<LogicalRelationalOperator> branchHeadToRemove = new HashSet<LogicalRelationalOperator>();
        Iterator i$ = innerLoadsToRemove.iterator();
        while (i$.hasNext()) {
            LOInnerLoad innerLoad;
            Operator op = innerLoad = (LOInnerLoad)i$.next();
            while (!(innerPlan.getSuccessors(op).get(0) instanceof LOGenerate)) {
                op = innerPlan.getSuccessors(op).get(0);
            }
            branchHeadToRemove.add((LogicalRelationalOperator)op);
        }
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        ArrayList<LogicalExpressionPlan> genPlansToRemove = new ArrayList<LogicalExpressionPlan>();
        List<LogicalExpressionPlan> genPlans = gen.getOutputPlans();
        for (int i = 0; i < genPlans.size(); ++i) {
            LogicalExpressionPlan expPlan = genPlans.get(i);
            List<Operator> expSources = expPlan.getSinks();
            for (Operator expSrc : expSources) {
                LogicalRelationalOperator reference;
                if (!(expSrc instanceof ProjectExpression) || !branchHeadToRemove.contains(reference = ((ProjectExpression)expSrc).findReferent())) continue;
                genPlansToRemove.add(expPlan);
            }
        }
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        HashSet<Integer> inputsNeeded = new HashSet<Integer>();
        HashSet<Integer> inputsRemoved = new HashSet<Integer>();
        ArrayList<LogicalSchema> outputPlanSchemas = new ArrayList<LogicalSchema>();
        ArrayList<LogicalSchema> uidOnlySchemas = new ArrayList<LogicalSchema>();
        ArrayList<LogicalSchema> userDefinedSchemas = null;
        if (gen.getUserDefinedSchema() != null) {
            userDefinedSchemas = new ArrayList<LogicalSchema>();
        }
        for (int i = 0; i < genPlans.size(); ++i) {
            LogicalExpressionPlan genPlan = genPlans.get(i);
            if (genPlansToRemove.contains(genPlan)) continue;
            flattenList.add(gen.getFlattenFlags()[i]);
            outputPlanSchemas.add(gen.getOutputPlanSchemas().get(i));
            uidOnlySchemas.add(gen.getUidOnlySchemas().get(i));
            if (gen.getUserDefinedSchema() != null) {
                userDefinedSchemas.add(gen.getUserDefinedSchema().get(i));
            }
            List<Operator> sinks = genPlan.getSinks();
            for (Operator s : sinks) {
                if (!(s instanceof ProjectExpression)) continue;
                inputsNeeded.add(((ProjectExpression)s).getInputNum());
            }
        }
        List<Operator> preds = innerPlan.getPredecessors(gen);
        if (preds != null) {
            for (int i = 0; i < preds.size(); ++i) {
                if (inputsNeeded.contains(i)) continue;
                inputsRemoved.add(i);
            }
        }
        boolean[] flatten = new boolean[flattenList.size()];
        for (int i = 0; i < flattenList.size(); ++i) {
            flatten[i] = (Boolean)flattenList.get(i);
        }
        gen.setFlattenFlags(flatten);
        gen.setOutputPlanSchemas(outputPlanSchemas);
        gen.setUidOnlySchemas(uidOnlySchemas);
        gen.setUserDefinedSchema(userDefinedSchemas);
        for (LogicalExpressionPlan genPlanToRemove : genPlansToRemove) {
            genPlans.remove(genPlanToRemove);
        }
        if (!inputsRemoved.isEmpty()) {
            for (LogicalExpressionPlan genPlan : genPlans) {
                List<Operator> sinks = genPlan.getSinks();
                for (Operator s : sinks) {
                    if (!(s instanceof ProjectExpression)) continue;
                    int input = ((ProjectExpression)s).getInputNum();
                    int numToShift = 0;
                    Iterator i$2 = inputsRemoved.iterator();
                    while (i$2.hasNext()) {
                        int i = (Integer)i$2.next();
                        if (i >= input) continue;
                        ++numToShift;
                    }
                    ((ProjectExpression)s).setInputNum(input - numToShift);
                }
            }
        }
        ArrayList<LogicalRelationalOperator> predToRemove = new ArrayList<LogicalRelationalOperator>();
        Iterator<Operator> i$3 = inputsRemoved.iterator();
        while (i$3.hasNext()) {
            int i = (Integer)((Object)i$3.next());
            predToRemove.add((LogicalRelationalOperator)preds.get(i));
        }
        for (LogicalRelationalOperator pred : predToRemove) {
            this.removeSubTree(pred);
        }
    }

    @Override
    public void visit(LOUnion union) throws FrontendException {
        ArrayList<Operator> preds = new ArrayList<Operator>();
        preds.addAll(this.plan.getPredecessors(union));
        for (Operator pred : preds) {
            this.addForEachIfNecessary((LogicalRelationalOperator)pred);
        }
    }

    private void removeSubTree(LogicalRelationalOperator op) throws FrontendException {
        LogicalPlan p = (LogicalPlan)op.getPlan();
        List<Operator> ll = p.getPredecessors(op);
        if (ll != null) {
            for (Operator pred : ll.toArray(new Operator[ll.size()])) {
                this.removeSubTree((LogicalRelationalOperator)pred);
            }
        }
        if (p.getSuccessors(op) != null) {
            Operator[] succs;
            for (Operator s : succs = p.getSuccessors(op).toArray(new Operator[0])) {
                p.disconnect(op, s);
            }
        }
        p.remove(op);
    }

    private void addForEachIfNecessary(LogicalRelationalOperator op) throws FrontendException {
        Set outputUids = (Set)op.getAnnotation("ColumnPrune:OutputUids");
        if (outputUids != null) {
            LogicalSchema schema = op.getSchema();
            HashSet<Integer> columnsToDrop = new HashSet<Integer>();
            for (int i = 0; i < schema.size(); ++i) {
                if (outputUids.contains(schema.getField((int)i).uid)) continue;
                columnsToDrop.add(i);
            }
            if (!columnsToDrop.isEmpty()) {
                LOForEach foreach = Util.addForEachAfter((LogicalPlan)op.getPlan(), op, 0, columnsToDrop);
                foreach.getSchema();
            }
        }
    }
}

