/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;

public class InputOutputFileValidator {
    private PigContext pigCtx;
    OperatorPlan plan;

    public InputOutputFileValidator(OperatorPlan plan, PigContext pigContext) {
        this.pigCtx = pigContext;
        this.plan = plan;
    }

    public void validate() throws FrontendException {
        InputOutputFileVisitor visitor = new InputOutputFileVisitor(this.plan);
        visitor.visit();
    }

    class InputOutputFileVisitor
    extends LogicalRelationalNodesVisitor {
        protected InputOutputFileVisitor(OperatorPlan plan) throws FrontendException {
            super(plan, new DepthFirstWalker(plan));
        }

        @Override
        public void visit(LOStore store) throws FrontendException {
            Job dummyJob;
            StoreFuncInterface sf = store.getStoreFunc();
            String outLoc = store.getOutputSpec().getFileName();
            int errCode = 2116;
            String validationErrStr = "Output Location Validation Failed for: '" + outLoc;
            try {
                if (store.getSchema() != null) {
                    sf.checkSchema(new ResourceSchema(store.getSchema(), store.getSortInfo()));
                }
                dummyJob = new Job(ConfigurationUtil.toConfiguration(InputOutputFileValidator.this.pigCtx.getProperties()));
                sf.setStoreLocation(outLoc, dummyJob);
            }
            catch (Exception ioe) {
                if (ioe instanceof PigException) {
                    errCode = ((PigException)ioe).getErrorCode();
                }
                String exceptionMsg = ioe.getMessage();
                validationErrStr = validationErrStr + (exceptionMsg == null ? "" : " More info to follow:\n" + exceptionMsg);
                throw new VisitorException(store, validationErrStr, errCode, InputOutputFileValidator.this.pigCtx.getErrorSource(), ioe);
            }
            validationErrStr = validationErrStr + " More info to follow:\n";
            try {
                sf.getOutputFormat().checkOutputSpecs((JobContext)dummyJob);
            }
            catch (IOException ioe) {
                byte errSrc = InputOutputFileValidator.this.pigCtx.getErrorSource();
                switch (errSrc) {
                    case 4: {
                        errCode = 2002;
                        break;
                    }
                    case 16: {
                        errCode = 6000;
                        break;
                    }
                    case 8: {
                        errCode = 4000;
                    }
                }
                validationErrStr = validationErrStr + ioe.getMessage();
                throw new VisitorException(store, validationErrStr, errCode, errSrc, ioe);
            }
            catch (InterruptedException ie) {
                validationErrStr = validationErrStr + ie.getMessage();
                throw new VisitorException(store, validationErrStr, errCode, InputOutputFileValidator.this.pigCtx.getErrorSource(), ie);
            }
        }
    }
}

