/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.visitor.ProjectStarExpanderUtil;

class ProjExpanderForForeach
extends LogicalExpressionVisitor {
    private LOGenerate loGen;
    private LogicalPlan innerRelPlan;
    private Map<Integer, LogicalRelationalOperator> oldPos2Rel;
    private Map<ProjectExpression, LogicalRelationalOperator> proj2InpRel;
    private LOForEach foreach;
    private List<LOInnerLoad> expandedInLoads;

    protected ProjExpanderForForeach(OperatorPlan p, LOGenerate loGen, Map<Integer, LogicalRelationalOperator> oldPos2Rel, Map<ProjectExpression, LogicalRelationalOperator> proj2InpRel, LOForEach foreach, List<LOInnerLoad> expandedInLoads) throws FrontendException {
        super(p, new ReverseDependencyOrderWalker(p));
        this.loGen = loGen;
        this.innerRelPlan = (LogicalPlan)loGen.getPlan();
        this.oldPos2Rel = oldPos2Rel;
        this.proj2InpRel = proj2InpRel;
        this.foreach = foreach;
        this.expandedInLoads = expandedInLoads;
    }

    @Override
    public void visit(UserFuncExpression func) throws FrontendException {
        if (this.plan.getSuccessors(func) == null) {
            return;
        }
        ArrayList<Operator> inputs = new ArrayList<Operator>(this.plan.getSuccessors(func));
        ArrayList<Operator> expandedProjectStars = new ArrayList<Operator>();
        ArrayList<Operator> newExpandedProjects = new ArrayList<Operator>();
        ArrayList<Operator> newInputs = new ArrayList<Operator>();
        for (Operator inp : inputs) {
            if (inp instanceof ProjectExpression && ((ProjectExpression)inp).isRangeOrStarProject() && this.oldPos2Rel.get(((ProjectExpression)inp).getInputNum()) instanceof LOInnerLoad) {
                LOInnerLoad inLoad = (LOInnerLoad)this.oldPos2Rel.get(((ProjectExpression)inp).getInputNum());
                ProjectExpression innerProj = inLoad.getProjection();
                if (!innerProj.isRangeOrStarProject()) {
                    newInputs.add(inp);
                    continue;
                }
                List<Operator> expandedOps = this.expandProjectStar(innerProj);
                if (expandedOps != null) {
                    expandedProjectStars.add(inp);
                    this.expandedInLoads.add(inLoad);
                    newInputs.addAll(expandedOps);
                    newExpandedProjects.addAll(expandedOps);
                    continue;
                }
                newInputs.add(inp);
                continue;
            }
            newInputs.add(inp);
        }
        if (expandedProjectStars.size() > 0) {
            for (Operator inp : inputs) {
                this.plan.disconnect(func, inp);
            }
            for (Operator op : expandedProjectStars) {
                this.plan.remove(op);
                this.proj2InpRel.remove(op);
            }
            for (Operator op : newExpandedProjects) {
                this.plan.add(op);
            }
            for (Operator newInp : newInputs) {
                this.plan.connect(func, newInp);
            }
        }
    }

    @Override
    public void visit(ProjectExpression proj) {
        this.proj2InpRel.put(proj, this.oldPos2Rel.get(proj.getInputNum()));
    }

    private List<Operator> expandProjectStar(ProjectExpression proj) throws FrontendException {
        Pair<Integer, Integer> firstLastCols = ProjectStarExpanderUtil.getProjectStartEndCols((LogicalExpressionPlan)this.plan, proj);
        if (firstLastCols == null) {
            return null;
        }
        int firstProjCol = (Integer)firstLastCols.first;
        int lastProjCol = (Integer)firstLastCols.second;
        ArrayList<Operator> newProjects = new ArrayList<Operator>();
        for (int i = firstProjCol; i <= lastProjCol; ++i) {
            LOInnerLoad newILoad = new LOInnerLoad((OperatorPlan)this.innerRelPlan, this.foreach, i);
            this.innerRelPlan.add(newILoad);
            this.innerRelPlan.connect(newILoad, this.loGen);
            ProjectExpression newProj = new ProjectExpression(this.plan, -2, -1, (LogicalRelationalOperator)this.loGen);
            this.proj2InpRel.put(newProj, newILoad);
            newProjects.add(newProj);
        }
        return newProjects;
    }
}

