/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.pen.util.MetricEvaluation;

public class DisplayExamples {
    public static final int MAX_DATAATOM_LENGTH = 25;

    static void printMetrics(Operator op, Map<Operator, DataBag> derivedData, Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> OperatorToEqClasses) {
        System.out.println("Realness : " + MetricEvaluation.getRealness(op, derivedData, true) + "\n" + "Conciseness : " + MetricEvaluation.getConciseness(op, derivedData, OperatorToEqClasses, true) + "\n" + "Completeness : " + MetricEvaluation.getCompleteness(op, derivedData, OperatorToEqClasses, true) + "\n");
    }

    public static String printTabular(LogicalPlan lp, Map<Operator, DataBag> exampleData, Map<LOForEach, Map<LogicalRelationalOperator, DataBag>> forEachInnerLogToDataMap) throws FrontendException {
        StringBuffer output = new StringBuffer();
        HashSet<Operator> seen = new HashSet<Operator>();
        for (Operator currentOp : lp.getSinks()) {
            if (!(currentOp instanceof LOStore) || !((LOStore)currentOp).isTmpStore()) continue;
            DisplayExamples.printTabular(currentOp, lp, exampleData, forEachInnerLogToDataMap, seen, output);
        }
        for (Operator currentOp : lp.getSinks()) {
            DisplayExamples.printTabular(currentOp, lp, exampleData, forEachInnerLogToDataMap, seen, output);
        }
        return output.toString();
    }

    static void printTabular(Operator op, LogicalPlan lp, Map<Operator, DataBag> exampleData, Map<LOForEach, Map<LogicalRelationalOperator, DataBag>> forEachInnerLogToDataMap, Set<Operator> seen, StringBuffer output) {
        List<Operator> inputs = lp.getPredecessors(op);
        if (inputs != null) {
            for (Operator Op : inputs) {
                if (seen.contains(Op)) continue;
                DisplayExamples.printTabular(Op, lp, exampleData, forEachInnerLogToDataMap, seen, output);
            }
        }
        seen.add(op);
        if (op instanceof LOForEach) {
            DisplayExamples.printNestedTabular((LOForEach)op, forEachInnerLogToDataMap, exampleData.get(op), output);
        }
        if (((LogicalRelationalOperator)op).getAlias() != null) {
            DataBag bag = exampleData.get(op);
            if (op instanceof LOLoad && ((LOLoad)op).isCastInserted()) {
                op = op.getPlan().getSuccessors(op).get(0);
                bag = exampleData.get(op);
            }
            try {
                DisplayExamples.DisplayTable(DisplayExamples.MakeArray(op, bag), op, bag, output);
            }
            catch (FrontendException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void printNestedTabular(LOForEach foreach, Map<LOForEach, Map<LogicalRelationalOperator, DataBag>> forEachInnerLogToDataMap, DataBag foreachData, StringBuffer output) {
        LogicalPlan plan = foreach.getInnerPlan();
        if (plan != null) {
            DisplayExamples.printNestedTabular(plan.getSinks().get(0), plan, foreach.getAlias(), foreachData, forEachInnerLogToDataMap.get(foreach), output);
        }
    }

    static void printNestedTabular(Operator lo, LogicalPlan lp, String foreachAlias, DataBag foreachData, Map<LogicalRelationalOperator, DataBag> logToDataMap, StringBuffer output) {
        DataBag bag;
        List<Operator> inputs = lp.getPredecessors(lo);
        if (inputs != null) {
            for (Operator op : inputs) {
                DisplayExamples.printNestedTabular(op, lp, foreachAlias, foreachData, logToDataMap, output);
            }
        }
        if ((bag = logToDataMap.get(lo)) == null) {
            return;
        }
        if (((LogicalRelationalOperator)lo).getAlias() != null) {
            try {
                DisplayExamples.DisplayNestedTable(DisplayExamples.MakeArray(lo, bag), lo, foreachAlias, foreachData, bag, output);
            }
            catch (FrontendException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void printSimple(Operator op, LogicalPlan lp, Map<Operator, DataBag> exampleData) {
        DataBag bag = exampleData.get(op);
        List<Operator> inputs = lp.getPredecessors(op);
        if (inputs != null) {
            for (Operator lOp : inputs) {
                DisplayExamples.printSimple(lOp, lp, exampleData);
            }
        }
        if (((LogicalRelationalOperator)op).getAlias() != null) {
            System.out.println(((LogicalRelationalOperator)op).getAlias() + " : " + bag);
        }
    }

    static String AddSpaces(int n, boolean printSpace) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (printSpace) {
                str.append(" ");
                continue;
            }
            str.append("-");
        }
        return str.toString();
    }

    static void DisplayTable(String[][] table, Operator op, DataBag bag, StringBuffer output) throws FrontendException {
        int i;
        if (op instanceof LOStore && ((LOStore)op).isTmpStore()) {
            return;
        }
        int cols = ((LogicalRelationalOperator)op).getSchema().getFields().size();
        List<LogicalSchema.LogicalFieldSchema> fields = ((LogicalRelationalOperator)op).getSchema().getFields();
        int rows = (int)bag.size();
        int[] maxColSizes = new int[cols];
        for (int i2 = 0; i2 < cols; ++i2) {
            maxColSizes[i2] = fields.get(i2).toString().length();
            if (maxColSizes[i2] >= 5) continue;
            maxColSizes[i2] = 5;
        }
        int total = 0;
        String alias = ((LogicalRelationalOperator)op).getAlias();
        int aliasLength = op instanceof LOStore ? alias.length() + 12 : alias.length() + 4;
        for (int j = 0; j < cols; ++j) {
            for (int i3 = 0; i3 < rows; ++i3) {
                int length = table[i3][j].length();
                if (length <= maxColSizes[j]) continue;
                maxColSizes[j] = length;
            }
            total += maxColSizes[j];
        }
        if (op instanceof LOLimit) {
            output.append("\nThe limit now in use, " + ((LOLimit)op).getLimit() + ", may have been changed for ILLUSTRATE purpose.\n");
        }
        output.append(DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
        if (op instanceof LOStore) {
            output.append("| Store : " + alias + DisplayExamples.AddSpaces(4, true) + " | ");
        } else {
            output.append("| " + alias + DisplayExamples.AddSpaces(4, true) + " | ");
        }
        for (i = 0; i < cols; ++i) {
            String field = fields.get(i).toString(false);
            output.append(field + DisplayExamples.AddSpaces(maxColSizes[i] - field.length(), true) + " | ");
        }
        output.append("\n" + DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
        for (i = 0; i < rows; ++i) {
            output.append("| " + DisplayExamples.AddSpaces(aliasLength, true) + " | ");
            for (int j = 0; j < cols; ++j) {
                String str = table[i][j];
                output.append(str + DisplayExamples.AddSpaces(maxColSizes[j] - str.length(), true) + " | ");
            }
            output.append("\n");
        }
        output.append(DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
    }

    static void DisplayNestedTable(String[][] table, Operator op, String foreachAlias, DataBag bag, DataBag foreachData, StringBuffer output) throws FrontendException {
        int i;
        LogicalRelationalOperator lop = (LogicalRelationalOperator)op;
        int cols = lop.getSchema().getFields().size();
        List<LogicalSchema.LogicalFieldSchema> fields = lop.getSchema().getFields();
        int rows = (int)bag.size();
        int[] maxColSizes = new int[cols];
        for (int i2 = 0; i2 < cols; ++i2) {
            maxColSizes[i2] = fields.get(i2).toString().length();
            if (maxColSizes[i2] >= 5) continue;
            maxColSizes[i2] = 5;
        }
        int total = 0;
        String alias = ((LogicalRelationalOperator)op).getAlias();
        int aliasLength = alias.length() + foreachAlias.length() + 5;
        for (int j = 0; j < cols; ++j) {
            for (int i3 = 0; i3 < rows; ++i3) {
                int length = table[i3][j].length();
                if (length <= maxColSizes[j]) continue;
                maxColSizes[j] = length;
            }
            total += maxColSizes[j];
        }
        output.append(DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
        output.append("| " + foreachAlias + "." + alias + DisplayExamples.AddSpaces(4, true) + " | ");
        for (i = 0; i < cols; ++i) {
            String field = fields.get(i).toString(false);
            output.append(field + DisplayExamples.AddSpaces(maxColSizes[i] - field.length(), true) + " | ");
        }
        output.append("\n" + DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
        for (i = 0; i < rows; ++i) {
            output.append("| " + DisplayExamples.AddSpaces(aliasLength, true) + " | ");
            for (int j = 0; j < cols; ++j) {
                String str = table[i][j];
                output.append(str + DisplayExamples.AddSpaces(maxColSizes[j] - str.length(), true) + " | ");
            }
            output.append("\n");
        }
        output.append(DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
    }

    static String[][] MakeArray(Operator op, DataBag bag) throws Exception {
        int rows = (int)bag.size();
        int cols = ((LogicalRelationalOperator)op).getSchema().getFields().size();
        String[][] table = new String[rows][cols];
        Iterator<Tuple> it = bag.iterator();
        for (int i = 0; i < rows; ++i) {
            Tuple t = it.next();
            for (int j = 0; j < cols; ++j) {
                table[i][j] = DisplayExamples.ShortenField(t.get(j));
            }
        }
        return table;
    }

    static String ShortenField(Object d) throws ExecException {
        if (d instanceof Tuple) {
            return DisplayExamples.ShortenField((Tuple)d);
        }
        if (d instanceof DataBag) {
            return DisplayExamples.ShortenField((DataBag)d);
        }
        if (DataType.findTypeName(d) != null) {
            if (d == null) {
                return "";
            }
            return d.toString();
        }
        System.out.println("Unrecognized data-type received!!!");
        return null;
    }

    static String ShortenField(DataBag bag) throws ExecException {
        StringBuffer str = new StringBuffer();
        long size = bag.size();
        str.append("{");
        if (size > 3L) {
            Iterator<Tuple> it = bag.iterator();
            str.append(DisplayExamples.ShortenField(it.next()));
            while (it.hasNext()) {
                Tuple t = it.next();
                if (it.hasNext()) continue;
                str.append(", ..., " + DisplayExamples.ShortenField(t));
            }
        } else {
            Iterator<Tuple> it = bag.iterator();
            while (it.hasNext()) {
                Tuple t = it.next();
                if (it.hasNext()) {
                    str.append(DisplayExamples.ShortenField(t) + ", ");
                    continue;
                }
                str.append(DisplayExamples.ShortenField(t));
            }
        }
        str.append("}");
        return str.toString();
    }

    static String ShortenField(Tuple t) throws ExecException {
        StringBuffer str = new StringBuffer();
        int noFields = t.size();
        str.append("(");
        if (noFields > 3) {
            Object d = t.get(0);
            str.append(DisplayExamples.ShortenField(d) + ", ..., ");
            d = t.get(noFields - 1);
            str.append(DisplayExamples.ShortenField(d));
        } else {
            for (int i = 0; i < noFields; ++i) {
                Object d = t.get(i);
                if (i != noFields - 1) {
                    str.append(DisplayExamples.ShortenField(d) + ", ");
                    continue;
                }
                str.append(DisplayExamples.ShortenField(d));
            }
        }
        str.append(")");
        return str.toString();
    }
}

