/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.grunt;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jline.ConsoleReader;
import jline.ConsoleReaderInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigServer;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.executionengine.HExecutionEngine;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.TupleFormat;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigscript.parser.PigScriptParser;
import org.apache.pig.tools.pigscript.parser.PigScriptParserTokenManager;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class GruntParser
extends PigScriptParser {
    private static final Log log = LogFactory.getLog(GruntParser.class);
    private PigServer mPigServer;
    private DataStorage mDfs;
    private DataStorage mLfs;
    private Properties mConf;
    private JobConf mJobConf;
    private boolean mDone;
    private boolean mLoadOnly;
    private ExplainState mExplain;
    private int mNumFailedJobs;
    private int mNumSucceededJobs;
    private FsShell shell;
    private boolean mScriptIllustrate;

    public GruntParser(Reader stream) {
        super(stream);
        this.init();
    }

    public GruntParser(InputStream stream, String encoding) {
        super(stream, encoding);
        this.init();
    }

    public GruntParser(InputStream stream) {
        super(stream);
        this.init();
    }

    public GruntParser(PigScriptParserTokenManager tm) {
        super(tm);
        this.init();
    }

    private void init() {
        this.mDone = false;
        this.mLoadOnly = false;
        this.mExplain = null;
        this.mScriptIllustrate = false;
    }

    @Override
    public void setInteractive(boolean isInteractive) {
        super.setInteractive(isInteractive);
        if (isInteractive) {
            this.setValidateEachStatement(true);
        }
    }

    public void setValidateEachStatement(boolean b) {
        this.mPigServer.setValidateEachStatement(b);
    }

    private void setBatchOn() {
        this.mPigServer.setBatchOn();
    }

    private void executeBatch() throws IOException {
        if (this.mPigServer.isBatchOn()) {
            if (this.mExplain != null) {
                this.explainCurrentBatch();
            }
            if (!this.mLoadOnly) {
                this.mPigServer.executeBatch();
                PigStats stats = PigStats.get();
                PigStats.JobGraph jg = stats.getJobGraph();
                for (JobStats js : jg) {
                    if (!js.isSuccessful()) {
                        ++this.mNumFailedJobs;
                        Exception exp = js.getException() != null ? js.getException() : new ExecException("Job failed, hadoop does not return any error message", 2244);
                        LogUtils.writeLog(exp, this.mPigServer.getPigContext().getProperties().getProperty("pig.logfile"), log, "true".equalsIgnoreCase(this.mPigServer.getPigContext().getProperties().getProperty("verbose")), "Pig Stack Trace");
                        continue;
                    }
                    ++this.mNumSucceededJobs;
                }
            }
        }
    }

    private void discardBatch() throws IOException {
        if (this.mPigServer.isBatchOn()) {
            this.mPigServer.discardBatch();
        }
    }

    public int[] parseStopOnError() throws IOException, ParseException {
        return this.parseStopOnError(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] parseStopOnError(boolean sameBatch) throws IOException, ParseException {
        if (this.mPigServer == null) {
            throw new IllegalStateException();
        }
        if (!this.mInteractive && !sameBatch) {
            this.setBatchOn();
        }
        try {
            this.prompt();
            this.mDone = false;
            while (!this.mDone) {
                this.parse();
            }
            if (!sameBatch) {
                this.executeBatch();
            }
        }
        finally {
            if (!sameBatch) {
                this.discardBatch();
            }
        }
        int[] res = new int[]{this.mNumSucceededJobs, this.mNumFailedJobs};
        return res;
    }

    public void setLoadOnly(boolean loadOnly) {
        this.mLoadOnly = loadOnly;
    }

    public void setParams(PigServer pigServer) {
        this.mPigServer = pigServer;
        this.mDfs = this.mPigServer.getPigContext().getDfs();
        this.mLfs = this.mPigServer.getPigContext().getLfs();
        this.mConf = this.mPigServer.getPigContext().getProperties();
        this.shell = new FsShell(ConfigurationUtil.toConfiguration(this.mConf));
        HExecutionEngine execEngine = this.mPigServer.getPigContext().getExecutionEngine();
        this.mJobConf = execEngine.getJobConf();
    }

    public void setScriptIllustrate() {
        this.mScriptIllustrate = true;
    }

    @Override
    public void prompt() {
        if (this.mInteractive) {
            this.mConsoleReader.setDefaultPrompt("grunt> ");
        }
    }

    @Override
    protected void quit() {
        this.mDone = true;
    }

    public boolean isDone() {
        return this.mDone;
    }

    public void parseOnly() throws IOException, ParseException {
        if (this.mPigServer == null) {
            throw new IllegalStateException();
        }
        this.mDone = false;
        while (!this.mDone) {
            this.parse();
        }
    }

    @Override
    protected void processDescribe(String alias) throws IOException {
        String nestedAlias = null;
        if (this.mExplain == null) {
            if (alias == null && (alias = this.mPigServer.getPigContext().getLastAlias()) == null) {
                throw new IOException("No previously defined alias found. Please define an alias and use 'describe' operator.");
            }
            if (alias.contains("::")) {
                nestedAlias = alias.substring(alias.indexOf("::") + 2);
                alias = alias.substring(0, alias.indexOf("::"));
                this.mPigServer.dumpSchemaNested(alias, nestedAlias);
            } else {
                if ("@".equals(alias)) {
                    alias = this.mPigServer.getLastRel();
                }
                this.mPigServer.dumpSchema(alias);
            }
        } else {
            log.warn((Object)"'describe' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processExplain(String alias, String script, boolean isVerbose, String format, String target, List<String> params, List<String> files) throws IOException, ParseException {
        if (alias == null && script == null && (alias = this.mPigServer.getPigContext().getLastAlias()) == null) {
            throw new ParseException("'explain' statement must be on an alias or on a script.");
        }
        if ("@".equals(alias)) {
            alias = this.mPigServer.getLastRel();
        }
        this.processExplain(alias, script, isVerbose, format, target, params, files, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExplain(String alias, String script, boolean isVerbose, String format, String target, List<String> params, List<String> files, boolean dontPrintOutput) throws IOException, ParseException {
        if (null != this.mExplain) {
            return;
        }
        try {
            this.mExplain = new ExplainState(alias, target, script, isVerbose, format);
            if (script != null) {
                if (!"true".equalsIgnoreCase(this.mPigServer.getPigContext().getProperties().getProperty("opt.multiquery", "true"))) {
                    throw new ParseException("Cannot explain script if multiquery is disabled.");
                }
                this.setBatchOn();
                try {
                    this.loadScript(script, true, true, false, params, files);
                }
                catch (IOException e) {
                    this.discardBatch();
                    throw e;
                }
                catch (ParseException e) {
                    this.discardBatch();
                    throw e;
                }
            }
            this.mExplain.mLast = true;
            this.explainCurrentBatch(dontPrintOutput);
        }
        finally {
            if (script != null) {
                this.discardBatch();
            }
            this.mExplain = null;
        }
    }

    protected void explainCurrentBatch() throws IOException {
        this.explainCurrentBatch(false);
    }

    protected void explainCurrentBatch(boolean dontPrintOutput) throws IOException {
        boolean markAsExecuted;
        PrintStream ep;
        PrintStream lp = dontPrintOutput ? new NullPrintStream("dummy") : System.out;
        PrintStream pp = dontPrintOutput ? new NullPrintStream("dummy") : System.out;
        PrintStream printStream = ep = dontPrintOutput ? new NullPrintStream("dummy") : System.out;
        if ((!this.mExplain.mLast || this.mExplain.mCount != 0) && this.mPigServer.isBatchEmpty()) {
            return;
        }
        ++this.mExplain.mCount;
        boolean bl = markAsExecuted = this.mExplain.mScript != null;
        if (this.mExplain.mTarget != null) {
            File file = new File(this.mExplain.mTarget);
            if (file.isDirectory()) {
                String sCount = this.mExplain.mLast && this.mExplain.mCount == 1 ? "" : "_" + this.mExplain.mCount;
                lp = new PrintStream(new File(file, "logical_plan-" + this.mExplain.mTime + sCount + "." + this.mExplain.mFormat));
                pp = new PrintStream(new File(file, "physical_plan-" + this.mExplain.mTime + sCount + "." + this.mExplain.mFormat));
                ep = new PrintStream(new File(file, "exec_plan-" + this.mExplain.mTime + sCount + "." + this.mExplain.mFormat));
                this.mPigServer.explain(this.mExplain.mAlias, this.mExplain.mFormat, this.mExplain.mVerbose, markAsExecuted, lp, pp, ep);
                lp.close();
                pp.close();
                ep.close();
            } else {
                boolean append = this.mExplain.mCount != 1;
                pp = ep = new PrintStream(new FileOutputStream(this.mExplain.mTarget, append));
                lp = ep;
                this.mPigServer.explain(this.mExplain.mAlias, this.mExplain.mFormat, this.mExplain.mVerbose, markAsExecuted, lp, pp, ep);
                lp.close();
            }
        } else {
            this.mPigServer.explain(this.mExplain.mAlias, this.mExplain.mFormat, this.mExplain.mVerbose, markAsExecuted, lp, pp, ep);
        }
    }

    @Override
    protected void printAliases() throws IOException {
        if (this.mExplain == null) {
            this.mPigServer.printAliases();
        } else {
            log.warn((Object)"'aliases' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void printClear() {
        AnsiConsole.systemInstall();
        Ansi ansi = Ansi.ansi();
        System.out.println(ansi.eraseScreen());
        System.out.println(ansi.cursor(0, 0));
        AnsiConsole.systemUninstall();
    }

    @Override
    protected void processRegister(String jar) throws IOException {
        this.mPigServer.registerJar(jar);
    }

    @Override
    protected void processRegister(String path, String scriptingLang, String namespace) throws IOException, ParseException {
        if (path.endsWith(".jar")) {
            if (scriptingLang != null || namespace != null) {
                throw new ParseException("Cannot register a jar with a scripting language or namespace");
            }
            this.mPigServer.registerJar(path);
        } else {
            this.mPigServer.registerCode(path, scriptingLang, namespace);
        }
    }

    private String runPreprocessor(String script, List<String> params, List<String> files) throws IOException, ParseException {
        ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
        StringWriter writer = new StringWriter();
        try {
            psp.genSubstitutedFile(new BufferedReader(new FileReader(script)), writer, params.size() > 0 ? params.toArray(new String[0]) : null, files.size() > 0 ? files.toArray(new String[0]) : null);
        }
        catch (org.apache.pig.tools.parameters.ParseException pex) {
            throw new ParseException(pex.getMessage());
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processScript(String script, boolean batch, List<String> params, List<String> files) throws IOException, ParseException {
        if (this.mExplain == null) {
            if (script == null) {
                this.executeBatch();
                return;
            }
            if (batch) {
                this.setBatchOn();
                this.mPigServer.setJobName(script);
                try {
                    this.loadScript(script, true, false, this.mLoadOnly, params, files);
                    this.executeBatch();
                }
                finally {
                    this.discardBatch();
                }
            } else {
                this.loadScript(script, false, false, this.mLoadOnly, params, files);
            }
        } else {
            log.warn((Object)"'run/exec' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    private void loadScript(String script, boolean batch, boolean loadOnly, boolean illustrate, List<String> params, List<String> files) throws IOException, ParseException {
        boolean interactive;
        Reader inputReader;
        ConsoleReader reader;
        try {
            FileLocalizer.FetchFileRet fetchFile = FileLocalizer.fetchFile(this.mConf, script);
            String cmds = this.runPreprocessor(fetchFile.file.getAbsolutePath(), params, files);
            if (this.mInteractive && !batch) {
                cmds = cmds.replaceAll("\t", "    ");
                reader = new ConsoleReader(new ByteArrayInputStream(cmds.getBytes()), new OutputStreamWriter(System.out));
                reader.setHistory(this.mConsoleReader.getHistory());
                ConsoleReaderInputStream in = new ConsoleReaderInputStream(reader);
                inputReader = new BufferedReader(new InputStreamReader(in));
                interactive = true;
            } else {
                inputReader = new StringReader(cmds);
                reader = null;
                interactive = false;
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ParseException("File not found: " + script);
        }
        catch (SecurityException se) {
            throw new ParseException("Cannot access file: " + script);
        }
        GruntParser parser = new GruntParser(inputReader);
        parser.setParams(this.mPigServer);
        parser.setConsoleReader(reader);
        parser.setInteractive(interactive);
        parser.setLoadOnly(loadOnly);
        if (illustrate) {
            parser.setScriptIllustrate();
        }
        parser.mExplain = this.mExplain;
        parser.prompt();
        while (!parser.isDone()) {
            parser.parse();
        }
        if (interactive) {
            System.out.println("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processSet(String key, String value) throws IOException, ParseException {
        if (key.equals("debug")) {
            if (value.equals("on")) {
                this.mPigServer.debugOn();
                return;
            } else {
                if (!value.equals("off")) throw new ParseException("Invalid value " + value + " provided for " + key);
                this.mPigServer.debugOff();
            }
            return;
        } else if (key.equals("job.name")) {
            this.mPigServer.setJobName(value);
            return;
        } else if (key.equals("job.priority")) {
            this.mPigServer.setJobPriority(value);
            return;
        } else if (key.equals("stream.skippath")) {
            File file = new File(value);
            if (!file.exists() || file.isDirectory()) {
                throw new IOException("Invalid value for stream.skippath:" + value);
            }
            this.mPigServer.addPathToSkip(value);
            return;
        } else if (key.equals("default_parallel")) {
            try {
                this.mPigServer.setDefaultParallel(Integer.parseInt(value));
                return;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid value for default_parallel");
            }
        } else {
            Properties properties = this.mPigServer.getPigContext().getProperties();
            JobConf jobConf = this.mPigServer.getPigContext().getExecutionEngine().getJobConf();
            Enumeration<Object> propertiesIter = properties.keys();
            while (propertiesIter.hasMoreElements()) {
                String pkey = (String)propertiesIter.nextElement();
                String val = properties.getProperty(pkey);
                if (pkey.equals("user.name")) continue;
                jobConf.set(pkey, val);
            }
            jobConf.set(key, value);
            properties.clear();
            for (Map.Entry entry : jobConf) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected void processCat(String path) throws IOException {
        if (this.mExplain == null) {
            this.executeBatch();
            try {
                int rc;
                byte[] buffer = new byte[65536];
                ElementDescriptor dfsPath = this.mDfs.asElement(path);
                if (!dfsPath.exists()) {
                    throw new IOException("Directory " + path + " does not exist.");
                }
                if (this.mDfs.isContainer(path)) {
                    ContainerDescriptor dfsDir = (ContainerDescriptor)dfsPath;
                    for (ElementDescriptor curElem : dfsDir) {
                        int rc2;
                        if (this.mDfs.isContainer(curElem.toString())) continue;
                        InputStream is = curElem.open();
                        while ((rc2 = is.read(buffer)) > 0) {
                            System.out.write(buffer, 0, rc2);
                        }
                        is.close();
                    }
                }
                InputStream is = dfsPath.open();
                while ((rc = is.read(buffer)) > 0) {
                    System.out.write(buffer, 0, rc);
                }
                is.close();
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to Cat: " + path, e);
            }
        } else {
            log.warn((Object)"'cat' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processCD(String path) throws IOException {
        if (this.mExplain == null) {
            try {
                if (path == null) {
                    ContainerDescriptor container = this.mDfs.asContainer(((HDataStorage)this.mDfs).getHFS().getHomeDirectory().toString());
                    this.mDfs.setActiveContainer(container);
                }
                ContainerDescriptor container = this.mDfs.asContainer(path);
                if (!container.exists()) {
                    throw new IOException("Directory " + path + " does not exist.");
                }
                if (!this.mDfs.isContainer(path)) {
                    throw new IOException(path + " is not a directory.");
                }
                this.mDfs.setActiveContainer(container);
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to change working directory to " + (path == null ? ((HDataStorage)this.mDfs).getHFS().getHomeDirectory().toString() : path), e);
            }
        } else {
            log.warn((Object)"'cd' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processDump(String alias) throws IOException {
        if (alias == null && (alias = this.mPigServer.getPigContext().getLastAlias()) == null) {
            throw new IOException("No previously defined alias found. Please define an alias and use 'dump' operator.");
        }
        if (this.mExplain == null) {
            this.executeBatch();
            if ("@".equals(alias)) {
                alias = this.mPigServer.getLastRel();
            }
            Iterator<Tuple> result = this.mPigServer.openIterator(alias);
            while (result.hasNext()) {
                Tuple t = result.next();
                System.out.println(TupleFormat.format(t));
            }
        } else {
            log.warn((Object)"'dump' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processIllustrate(String alias, String script, String target, List<String> params, List<String> files) throws IOException, ParseException {
        if (this.mScriptIllustrate) {
            throw new ParseException("'illustrate' statement can not appear in a script that is illustrated opon.");
        }
        if (alias != null && script != null) {
            throw new ParseException("'illustrate' statement on an alias does not work when a script is in effect");
        }
        if (this.mExplain != null) {
            log.warn((Object)"'illustrate' statement is ignored while processing 'explain -script' or '-check'");
        } else {
            try {
                if (script != null) {
                    if (!"true".equalsIgnoreCase(this.mPigServer.getPigContext().getProperties().getProperty("opt.multiquery", "true"))) {
                        throw new ParseException("Cannot explain script if multiquery is disabled.");
                    }
                    this.setBatchOn();
                    try {
                        this.loadScript(script, true, true, true, params, files);
                    }
                    catch (IOException e) {
                        this.discardBatch();
                        throw e;
                    }
                    catch (ParseException e) {
                        this.discardBatch();
                        throw e;
                    }
                } else if (alias == null && (alias = this.mPigServer.getPigContext().getLastAlias()) == null) {
                    throw new ParseException("'illustrate' statement must be on an alias or on a script.");
                }
                if ("@".equals(alias)) {
                    alias = this.mPigServer.getLastRel();
                }
                this.mPigServer.getExamples(alias);
            }
            finally {
                if (script != null) {
                    this.discardBatch();
                }
            }
        }
    }

    @Override
    protected void processKill(String jobid) throws IOException {
        if (this.mJobConf != null) {
            JobClient jc = new JobClient(this.mJobConf);
            JobID id = JobID.forName((String)jobid);
            RunningJob job = jc.getJob(id);
            if (job == null) {
                System.out.println("Job with id " + jobid + " is not active");
            } else {
                job.killJob();
                log.info((Object)("Kill " + id + " submitted."));
            }
        }
    }

    @Override
    protected void processLS(String path) throws IOException {
        if (this.mExplain == null) {
            try {
                ElementDescriptor pathDescriptor = path == null ? this.mDfs.getActiveContainer() : this.mDfs.asElement(path);
                if (!pathDescriptor.exists()) {
                    throw new IOException("File or directory " + path + " does not exist.");
                }
                if (this.mDfs.isContainer(pathDescriptor.toString())) {
                    ContainerDescriptor container = (ContainerDescriptor)pathDescriptor;
                    for (ElementDescriptor curElem : container) {
                        if (this.mDfs.isContainer(curElem.toString())) {
                            System.out.println(curElem.toString() + "\t<dir>");
                            continue;
                        }
                        this.printLengthAndReplication(curElem);
                    }
                }
                this.printLengthAndReplication(pathDescriptor);
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to LS on " + path, e);
            }
        } else {
            log.warn((Object)"'ls' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    private void printLengthAndReplication(ElementDescriptor elem) throws IOException {
        Map<String, Object> stats = elem.getStatistics();
        long replication = ((Short)stats.get("pig.path.block.replication")).shortValue();
        long len = (Long)stats.get("pig.path.length");
        System.out.println(elem.toString() + "<r " + replication + ">\t" + len);
    }

    @Override
    protected void processPWD() throws IOException {
        if (this.mExplain == null) {
            System.out.println(this.mDfs.getActiveContainer().toString());
        } else {
            log.warn((Object)"'pwd' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processHistory(boolean withNumbers) {
        this.mPigServer.printHistory(withNumbers);
    }

    @Override
    protected void printHelp() {
        System.out.println("Commands:");
        System.out.println("<pig latin statement>; - See the PigLatin manual for details: http://hadoop.apache.org/pig");
        System.out.println("File system commands:");
        System.out.println("    fs <fs arguments> - Equivalent to Hadoop dfs command: http://hadoop.apache.org/common/docs/current/hdfs_shell.html");
        System.out.println("Diagnostic commands:");
        System.out.println("    describe <alias>[::<alias] - Show the schema for the alias. Inner aliases can be described as A::B.");
        System.out.println("    explain [-script <pigscript>] [-out <path>] [-brief] [-dot] [-param <param_name>=<param_value>]");
        System.out.println("        [-param_file <file_name>] [<alias>] - Show the execution plan to compute the alias or for entire script.");
        System.out.println("        -script - Explain the entire script.");
        System.out.println("        -out - Store the output into directory rather than print to stdout.");
        System.out.println("        -brief - Don't expand nested plans (presenting a smaller graph for overview).");
        System.out.println("        -dot - Generate the output in .dot format. Default is text format.");
        System.out.println("        -param <param_name - See parameter substitution for details.");
        System.out.println("        -param_file <file_name> - See parameter substitution for details.");
        System.out.println("        alias - Alias to explain.");
        System.out.println("    dump <alias> - Compute the alias and writes the results to stdout.");
        System.out.println("Utility Commands:");
        System.out.println("    exec [-param <param_name>=param_value] [-param_file <file_name>] <script> - ");
        System.out.println("        Execute the script with access to grunt environment including aliases.");
        System.out.println("        -param <param_name - See parameter substitution for details.");
        System.out.println("        -param_file <file_name> - See parameter substitution for details.");
        System.out.println("        script - Script to be executed.");
        System.out.println("    run [-param <param_name>=param_value] [-param_file <file_name>] <script> - ");
        System.out.println("        Execute the script with access to grunt environment. ");
        System.out.println("        -param <param_name - See parameter substitution for details.");
        System.out.println("        -param_file <file_name> - See parameter substitution for details.");
        System.out.println("        script - Script to be executed.");
        System.out.println("    sh  <shell command> - Invoke a shell command.");
        System.out.println("    kill <job_id> - Kill the hadoop job specified by the hadoop job id.");
        System.out.println("    set <key> <value> - Provide execution parameters to Pig. Keys and values are case sensitive.");
        System.out.println("        The following keys are supported: ");
        System.out.println("        default_parallel - Script-level reduce parallelism. Basic input size heuristics used by default.");
        System.out.println("        debug - Set debug on or off. Default is off.");
        System.out.println("        job.name - Single-quoted name for jobs. Default is PigLatin:<script name>");
        System.out.println("        job.priority - Priority for jobs. Values: very_low, low, normal, high, very_high. Default is normal");
        System.out.println("        stream.skippath - String that contains the path. This is used by streaming.");
        System.out.println("        any hadoop property.");
        System.out.println("    help - Display this message.");
        System.out.println("    history [-n] - Display the list statements in cache.");
        System.out.println("        -n Hide line numbers. ");
        System.out.println("    quit - Quit the grunt shell.");
    }

    @Override
    protected void processMove(String src, String dst) throws IOException {
        if (this.mExplain == null) {
            this.executeBatch();
            try {
                ElementDescriptor srcPath = this.mDfs.asElement(src);
                ElementDescriptor dstPath = this.mDfs.asElement(dst);
                if (!srcPath.exists()) {
                    throw new IOException("File or directory " + src + " does not exist.");
                }
                srcPath.rename(dstPath);
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to move " + src + " to " + dst, e);
            }
        } else {
            log.warn((Object)"'mv' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processCopy(String src, String dst) throws IOException {
        if (this.mExplain == null) {
            this.executeBatch();
            try {
                ElementDescriptor srcPath = this.mDfs.asElement(src);
                ElementDescriptor dstPath = this.mDfs.asElement(dst);
                srcPath.copy(dstPath, this.mConf, false);
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to copy " + src + " to " + dst, e);
            }
        } else {
            log.warn((Object)"'cp' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processCopyToLocal(String src, String dst) throws IOException {
        if (this.mExplain == null) {
            this.executeBatch();
            try {
                ElementDescriptor srcPath = this.mDfs.asElement(src);
                ElementDescriptor dstPath = this.mLfs.asElement(dst);
                srcPath.copy(dstPath, false);
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to copy " + src + "to (locally) " + dst, e);
            }
        } else {
            log.warn((Object)"'copyToLocal' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processCopyFromLocal(String src, String dst) throws IOException {
        if (this.mExplain == null) {
            this.executeBatch();
            try {
                ElementDescriptor srcPath = this.mLfs.asElement(src);
                ElementDescriptor dstPath = this.mDfs.asElement(dst);
                srcPath.copy(dstPath, false);
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to copy (loally) " + src + "to " + dst, e);
            }
        } else {
            log.warn((Object)"'copyFromLocal' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processMkdir(String dir) throws IOException {
        if (this.mExplain == null) {
            ContainerDescriptor dirDescriptor = this.mDfs.asContainer(dir);
            dirDescriptor.create();
        } else {
            log.warn((Object)"'mkdir' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processPig(String cmd) throws IOException {
        int start = 1;
        if (!this.mInteractive) {
            start = this.getLineNumber();
        }
        if (cmd.charAt(cmd.length() - 1) != ';') {
            this.mPigServer.registerQuery(cmd + ";", start);
        } else {
            this.mPigServer.registerQuery(cmd, start);
        }
    }

    @Override
    protected void processRemove(String path, String options) throws IOException {
        if (this.mExplain == null) {
            ElementDescriptor dfsPath = this.mDfs.asElement(path);
            this.executeBatch();
            if (!dfsPath.exists()) {
                if (options == null || !options.equalsIgnoreCase("force")) {
                    throw new IOException("File or directory " + path + " does not exist.");
                }
            } else {
                dfsPath.delete();
            }
        } else {
            log.warn((Object)"'rm/rmf' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processFsCommand(String[] cmdTokens) throws IOException {
        if (this.mExplain == null) {
            this.executeBatch();
            int retCode = -1;
            try {
                retCode = this.shell.run(cmdTokens);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (retCode != 0 && !this.mInteractive) {
                String s = LoadFunc.join((AbstractList)Arrays.asList(cmdTokens), " ");
                throw new IOException("fs command '" + s + "' failed. Please check output logs for details");
            }
        } else {
            log.warn((Object)"'fs' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    @Override
    protected void processShCommand(String[] cmdTokens) throws IOException {
        block6: {
            if (this.mExplain == null) {
                try {
                    this.executeBatch();
                    String shellName = "sh";
                    String shellInvokeArg = "-c";
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        shellName = "cmd";
                        shellInvokeArg = "/C";
                    }
                    ArrayList<String> stringList = new ArrayList<String>();
                    stringList.add(shellName);
                    stringList.add(shellInvokeArg);
                    StringBuffer commandString = new StringBuffer();
                    for (String currToken : cmdTokens) {
                        commandString.append(" ");
                        commandString.append(currToken);
                    }
                    stringList.add(commandString.toString());
                    String[] newCmdTokens = stringList.toArray(new String[0]);
                    Process executor = Runtime.getRuntime().exec(newCmdTokens);
                    StreamPrinter outPrinter = new StreamPrinter(executor.getInputStream(), null, System.out);
                    StreamPrinter errPrinter = new StreamPrinter(executor.getErrorStream(), null, System.err);
                    outPrinter.start();
                    errPrinter.start();
                    int ret = executor.waitFor();
                    outPrinter.join();
                    errPrinter.join();
                    if (ret != 0 && !this.mInteractive) {
                        String s = LoadFunc.join((AbstractList)Arrays.asList(cmdTokens), " ");
                        throw new IOException("sh command '" + s + "' failed. Please check output logs for details");
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            log.warn((Object)"'sh' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    public static int runSQLCommand(String hcatBin, String cmd, boolean mInteractive) throws IOException {
        String[] tokens = new String[]{hcatBin, "-e", cmd.substring(cmd.indexOf("sql")).substring(4)};
        Map<String, String> envs = System.getenv();
        HashSet<String> envSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            if (entry.getKey().equals("HADOOP_CLASSPATH")) continue;
            envSet.add(entry.getKey() + "=" + entry.getValue());
        }
        log.info((Object)("Going to run hcat command: " + tokens[2]));
        Process executor = Runtime.getRuntime().exec(tokens, envSet.toArray(new String[0]));
        StreamPrinter outPrinter = new StreamPrinter(executor.getInputStream(), null, System.out);
        StreamPrinter errPrinter = new StreamPrinter(executor.getErrorStream(), null, System.err);
        outPrinter.start();
        errPrinter.start();
        try {
            int ret = executor.waitFor();
            outPrinter.join();
            errPrinter.join();
            if (ret != 0 && !mInteractive) {
                throw new IOException("sql command '" + cmd + "' failed. ");
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)("Exception raised from sql command " + e.getLocalizedMessage()));
        }
        return 0;
    }

    @Override
    protected void processSQLCommand(String cmd) throws IOException {
        if (this.mExplain == null) {
            if (!this.mPigServer.getPigContext().getProperties().get("pig.sql.type").equals("hcat")) {
                throw new IOException("sql command only support hcat currently");
            }
            if (this.mPigServer.getPigContext().getProperties().get("hcat.bin") == null) {
                throw new IOException("hcat.bin is not defined. Define it to be your hcat script (Usually $HCAT_HOME/bin/hcat");
            }
            String hcatBin = (String)this.mPigServer.getPigContext().getProperties().get("hcat.bin");
            if (new File("hcat.bin").exists()) {
                throw new IOException(hcatBin + " does not exist. Please check your 'hcat.bin' setting in pig.properties.");
            }
            this.executeBatch();
            GruntParser.runSQLCommand(hcatBin, cmd, this.mInteractive);
        } else {
            log.warn((Object)"'sql' statement is ignored while processing 'explain -script' or '-check'");
        }
    }

    private static class ExplainState {
        public long mTime = new Date().getTime();
        public int mCount = 0;
        public String mAlias;
        public String mTarget;
        public String mScript;
        public boolean mVerbose;
        public String mFormat;
        public boolean mLast;

        public ExplainState(String alias, String target, String script, boolean verbose, String format) {
            this.mAlias = alias;
            this.mTarget = target;
            this.mScript = script;
            this.mVerbose = verbose;
            this.mFormat = format;
            this.mLast = false;
        }
    }

    public static class StreamPrinter
    extends Thread {
        InputStream is;
        String type;
        PrintStream os;

        public StreamPrinter(InputStream is, String type, PrintStream os) {
            this.is = is;
            this.type = type;
            this.os = os;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                if (this.type != null) {
                    while ((line = br.readLine()) != null) {
                        this.os.println(this.type + ">" + line);
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        this.os.println(line);
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    static class NullPrintStream
    extends PrintStream {
        public NullPrintStream(String fileName) throws FileNotFoundException {
            super(fileName);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }
    }
}

