/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.parameters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreprocessorContext {
    private Hashtable<String, String> param_val;
    private final Log log = LogFactory.getLog(this.getClass());
    private Pattern bracketIdPattern = Pattern.compile("\\$\\{([_]*[a-zA-Z][a-zA-Z_0-9]*)\\}");
    private Pattern id_pattern = Pattern.compile("\\$([_]*[a-zA-Z][a-zA-Z_0-9]*)");

    public PreprocessorContext(int limit) {
        this.param_val = new Hashtable(limit);
    }

    public void processShellCmd(String key, String val) {
        this.processShellCmd(key, val, true);
    }

    public void processOrdLine(String key, String val) {
        this.processOrdLine(key, val, true);
    }

    public void processShellCmd(String key, String val, Boolean overwrite) {
        if (this.param_val.containsKey(key)) {
            if (overwrite.booleanValue()) {
                this.log.warn((Object)("Warning : Multiple values found for " + key + ". Using value " + val));
            } else {
                return;
            }
        }
        val = val.substring(1, val.length() - 1);
        String sub_val = this.substitute(val);
        sub_val = this.executeShellCommand(sub_val);
        this.param_val.put(key, sub_val);
    }

    public void processOrdLine(String key, String val, Boolean overwrite) {
        if (this.param_val.containsKey(key)) {
            if (overwrite.booleanValue()) {
                this.log.warn((Object)("Warning : Multiple values found for " + key + ". Using value " + val));
            } else {
                return;
            }
        }
        String sub_val = this.substitute(val);
        this.param_val.put(key, sub_val);
    }

    private String executeShellCommand(String cmd) {
        StringBuilder sb;
        String line;
        InputStreamReader isr;
        int exitVal;
        Process p;
        String streamData = "";
        String streamError = "";
        try {
            this.log.info((Object)("Executing command : " + cmd));
            String[] cmdArgs = new String[3];
            cmdArgs[0] = "bash";
            cmdArgs[1] = "-c";
            StringBuffer sb2 = new StringBuffer("exec ");
            sb2.append(cmd);
            cmdArgs[2] = sb2.toString();
            p = Runtime.getRuntime().exec(cmdArgs);
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte;
        }
        try {
            exitVal = p.waitFor();
        }
        catch (InterruptedException e) {
            RuntimeException rte = new RuntimeException("Interrupted Thread Exception while waiting for command to get over" + e.getMessage(), e);
            throw rte;
        }
        if (exitVal != 0) {
            RuntimeException rte = new RuntimeException("Error executing shell command: " + cmd + ". Command exit with exit code of " + exitVal);
            throw rte;
        }
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(p.getInputStream());
            br = new BufferedReader(isr);
            line = null;
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            streamData = sb.toString();
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            isr = new InputStreamReader(p.getErrorStream());
            br = new BufferedReader(isr);
            line = null;
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            streamError = sb.toString();
            this.log.debug((Object)("Error stream while executing shell command : " + streamError));
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        return streamData.trim();
    }

    public String substitute(String line) {
        int index = line.indexOf(36);
        if (index == -1) {
            return line;
        }
        String replaced_line = line;
        Matcher bracketKeyMatcher = this.bracketIdPattern.matcher(line);
        String key = "";
        String val = "";
        while (bracketKeyMatcher.find()) {
            if (bracketKeyMatcher.start() != 0 && line.charAt(bracketKeyMatcher.start() - 1) == '\\') continue;
            key = bracketKeyMatcher.group(1);
            if (!this.param_val.containsKey(key)) {
                throw new RuntimeException("Undefined parameter : " + key);
            }
            val = this.param_val.get(key);
            if (val.contains("$")) {
                val = val.replaceAll("(?<!\\\\)\\$", "\\\\\\$");
            }
            replaced_line = replaced_line.replaceFirst("\\$\\{" + key + "\\}", val);
        }
        Matcher keyMatcher = this.id_pattern.matcher(replaced_line);
        key = "";
        val = "";
        while (keyMatcher.find()) {
            if (keyMatcher.start() != 0 && line.charAt(keyMatcher.start() - 1) == '\\') continue;
            key = keyMatcher.group(1);
            if (!this.param_val.containsKey(key)) {
                throw new RuntimeException("Undefined parameter : " + key);
            }
            val = this.param_val.get(key);
            if (val.contains("$")) {
                val = val.replaceAll("(?<!\\\\)\\$", "\\\\\\$");
            }
            replaced_line = replaced_line.replaceFirst("\\$" + key, val);
        }
        replaced_line = replaced_line.replaceAll("\\\\\\$", "\\$");
        return replaced_line;
    }
}

