/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalDistinctBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class PODistinct
extends PhysicalOperator
implements Cloneable {
    private static final Log log = LogFactory.getLog(PODistinct.class);
    private static final long serialVersionUID = 1L;
    private boolean inputsAccumulated = false;
    private DataBag distinctBag = null;
    transient Iterator<Tuple> it;
    protected String customPartitioner;

    public String getCustomPartitioner() {
        return this.customPartitioner;
    }

    public void setCustomPartitioner(String customPartitioner) {
        this.customPartitioner = customPartitioner;
    }

    public PODistinct(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public PODistinct(OperatorKey k, int rp) {
        super(k, rp);
    }

    public PODistinct(OperatorKey k, List<PhysicalOperator> inp) {
        super(k, inp);
    }

    public PODistinct(OperatorKey k) {
        super(k);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (!this.inputsAccumulated) {
            Result in = this.processInput();
            String bagType = null;
            if (PigMapReduce.sJobConfInternal.get() != null) {
                bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.distinct.type");
            }
            this.distinctBag = bagType != null && bagType.equalsIgnoreCase("default") ? BagFactory.getInstance().newDistinctBag() : new InternalDistinctBag(3);
            while (in.returnStatus != 3) {
                if (in.returnStatus == 2) {
                    log.error((Object)"Error in reading from inputs");
                    return in;
                }
                if (in.returnStatus == 1) {
                    in = this.processInput();
                    continue;
                }
                this.distinctBag.add((Tuple)in.result);
                this.illustratorMarkup(in.result, in.result, 0);
                in = this.processInput();
            }
            this.inputsAccumulated = true;
        }
        if (this.it == null) {
            this.it = this.distinctBag.iterator();
        }
        this.res.result = this.it.next();
        if (this.res.result == null) {
            this.res.returnStatus = (byte)3;
            this.reset();
        } else {
            this.res.returnStatus = 0;
        }
        return this.res;
    }

    @Override
    public String name() {
        return this.getAliasString() + "PODistinct" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void reset() {
        this.inputsAccumulated = false;
        this.distinctBag = null;
        this.it = null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitDistinct(this);
    }

    @Override
    public PODistinct clone() throws CloneNotSupportedException {
        return new PODistinct(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, this.inputs);
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add((Tuple)out);
            this.illustrator.addData((Tuple)out);
        }
        return null;
    }
}

