/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.FileList;
import org.apache.pig.data.SortedSpillBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class InternalSortedBag
extends SortedSpillBag {
    private static final long serialVersionUID = 2L;
    private static TupleFactory gTupleFactory = TupleFactory.getInstance();
    private static final Log log = LogFactory.getLog(InternalSortedBag.class);
    private transient Comparator<Tuple> mComp;
    private transient boolean mReadStarted = false;

    public InternalSortedBag() {
        this(null);
    }

    public InternalSortedBag(Comparator<Tuple> comp) {
        this(1, comp);
    }

    public InternalSortedBag(int bagCount, Comparator<Tuple> comp) {
        this(bagCount, -1.0f, comp);
    }

    public InternalSortedBag(int bagCount, float percent, Comparator<Tuple> comp) {
        super(bagCount, percent);
        this.init(bagCount, percent, comp);
    }

    private void init(int bagCount, double percent, Comparator<Tuple> comp) {
        this.mComp = comp == null ? new DefaultComparator() : comp;
        this.mContents = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Tuple t) {
        Collection collection = this.mContents;
        synchronized (collection) {
            if (this.mReadStarted) {
                throw new IllegalStateException("InternalSortedBag is closed for adding new tuples");
            }
            if (this.mContents.size() > this.memLimit.getCacheLimit()) {
                this.proactive_spill(this.mComp);
            }
            this.mContents.add(t);
            if (this.mSize < 100L && (this.mSpillFiles == null || this.mSpillFiles.isEmpty()) && t != null) {
                this.memLimit.addNewObjSize(t.getMemorySize());
            }
            ++this.mSize;
            this.markSpillableIfNecessary();
        }
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new SortedDataBagIterator();
    }

    @Override
    public long spill() {
        return this.proactive_spill(this.mComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long proactive_spill(Comparator<Tuple> comp) {
        Collection collection = this.mContents;
        synchronized (collection) {
            if (this.mReadStarted) {
                return 0L;
            }
            return super.proactive_spill(comp);
        }
    }

    private class SortedDataBagIterator
    implements Iterator<Tuple> {
        private Tuple mBuf = null;
        private int mMemoryPtr = 0;
        private PriorityQueue<PQContainer> mMergeQ = null;
        private ArrayList<DataInputStream> mStreams = null;
        private int mCntr = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SortedDataBagIterator() {
            Collection collection = InternalSortedBag.this.mContents;
            synchronized (collection) {
                if (!InternalSortedBag.this.mReadStarted) {
                    this.preMerge();
                    Collections.sort((ArrayList)InternalSortedBag.this.mContents, InternalSortedBag.this.mComp);
                    InternalSortedBag.this.mReadStarted = true;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.mBuf = this.next();
            return this.mBuf != null;
        }

        @Override
        public Tuple next() {
            if ((this.mCntr++ & 0x3FF) == 0) {
                InternalSortedBag.this.reportProgress();
            }
            if (this.mBuf != null) {
                Tuple t = this.mBuf;
                this.mBuf = null;
                return t;
            }
            if (InternalSortedBag.this.mSpillFiles == null || InternalSortedBag.this.mSpillFiles.size() == 0) {
                return this.readFromMemory();
            }
            return this.readFromPriorityQ();
        }

        @Override
        public void remove() {
        }

        private Tuple readFromPriorityQ() {
            PQContainer c;
            if (this.mMergeQ == null) {
                this.mMergeQ = new PriorityQueue(InternalSortedBag.this.mSpillFiles.size() + 1);
                this.mStreams = new ArrayList(InternalSortedBag.this.mSpillFiles.size() + 1);
                Iterator i = InternalSortedBag.this.mSpillFiles.iterator();
                while (i.hasNext()) {
                    try {
                        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)i.next())));
                        this.mStreams.add(in);
                        this.addToQueue(null, this.mStreams.size() - 1);
                    }
                    catch (FileNotFoundException fnfe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)fnfe);
                        throw new RuntimeException(msg, fnfe);
                    }
                }
                if (InternalSortedBag.this.mContents.size() > 0) {
                    this.addToQueue(null, -1);
                }
            }
            if ((c = this.mMergeQ.poll()) == null) {
                return null;
            }
            Tuple t = c.tuple;
            this.addToQueue(c, c.fileNum);
            return t;
        }

        private void addToQueue(PQContainer c, int fileNum) {
            if (c == null) {
                c = new PQContainer();
            }
            c.fileNum = fileNum;
            if (fileNum == -1) {
                c.tuple = this.readFromMemory();
                if (c.tuple != null) {
                    this.mMergeQ.add(c);
                }
                return;
            }
            DataInputStream in = this.mStreams.get(fileNum);
            if (in != null) {
                c.tuple = gTupleFactory.newTuple();
                try {
                    c.tuple.readFields(in);
                    this.mMergeQ.add(c);
                }
                catch (EOFException eof) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close spill file.", (Throwable)e);
                    }
                    this.mStreams.set(fileNum, null);
                }
                catch (IOException ioe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)ioe);
                    throw new RuntimeException(msg, ioe);
                }
            }
        }

        private Tuple readFromMemory() {
            if (InternalSortedBag.this.mContents.size() == 0) {
                return null;
            }
            if (this.mMemoryPtr < InternalSortedBag.this.mContents.size()) {
                return (Tuple)((ArrayList)InternalSortedBag.this.mContents).get(this.mMemoryPtr++);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preMerge() {
            if (InternalSortedBag.this.mSpillFiles == null || InternalSortedBag.this.mSpillFiles.size() <= 100) {
                return;
            }
            try {
                LinkedList<File> ll = new LinkedList<File>(InternalSortedBag.this.mSpillFiles);
                LinkedList<File> filesToDelete = new LinkedList<File>();
                while (ll.size() > 100) {
                    ListIterator i = ll.listIterator();
                    this.mStreams = new ArrayList(100);
                    this.mMergeQ = new PriorityQueue(100);
                    for (int j = 0; j < 100; ++j) {
                        try {
                            File f = (File)i.next();
                            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                            this.mStreams.add(in);
                            this.addToQueue(null, this.mStreams.size() - 1);
                            i.remove();
                            filesToDelete.add(f);
                            continue;
                        }
                        catch (FileNotFoundException fnfe) {
                            String msg = "Unable to find our spill file.";
                            log.fatal((Object)msg, (Throwable)fnfe);
                            throw new RuntimeException(msg, fnfe);
                        }
                    }
                    try {
                        Tuple t;
                        DataOutputStream out = InternalSortedBag.this.getSpillFile();
                        ll.add((File)InternalSortedBag.this.mSpillFiles.get(InternalSortedBag.this.mSpillFiles.size() - 1));
                        while ((t = this.readFromPriorityQ()) != null) {
                            t.write(out);
                        }
                        out.flush();
                        out.close();
                    }
                    catch (IOException ioe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                }
                for (File f : filesToDelete) {
                    if (f.delete()) continue;
                    log.warn((Object)("Failed to delete spill file: " + f.getPath()));
                }
                InternalSortedBag.this.mSpillFiles.clear();
                InternalSortedBag.this.mSpillFiles = new FileList(ll);
            }
            finally {
                this.mStreams = null;
                this.mMergeQ = null;
            }
        }

        private class PQContainer
        implements Comparable<PQContainer> {
            public Tuple tuple;
            public int fileNum;

            private PQContainer() {
            }

            @Override
            public int compareTo(PQContainer other) {
                return InternalSortedBag.this.mComp.compare(this.tuple, other.tuple);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PQContainer) {
                    return this.compareTo((PQContainer)obj) == 0;
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }

    private static class DefaultComparator
    implements Comparator<Tuple> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            return t1.compareTo(t2);
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return 42;
        }
    }
}

