/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IdentityHashSet<E>
implements Set<E> {
    IdentityHashMap<E, Object> map = new IdentityHashMap();

    @Override
    public boolean add(E element) {
        if (this.map.containsKey(element)) {
            return false;
        }
        this.map.put(element, null);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        boolean anyChanges = false;
        for (E element : elements) {
            if (this.map.containsKey(element)) continue;
            anyChanges = true;
            this.map.put(element, null);
        }
        return anyChanges;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        for (Object element : elements) {
            if (this.map.containsKey(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<Map.Entry<E, Object>> it;
            {
                this.it = IdentityHashSet.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public E next() {
                return this.it.next().getKey();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public boolean remove(Object element) {
        if (this.map.containsKey(element)) {
            this.map.remove(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        for (Object element : elements) {
            this.map.remove(element);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        IdentityHashMap newMap = new IdentityHashMap();
        for (Object element : elements) {
            if (!this.map.containsKey(element)) continue;
            newMap.put(element, null);
        }
        boolean anyChanges = newMap.size() != this.map.size();
        this.map = newMap;
        return anyChanges;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Unsupported operation on IdentityHashSet.");
    }

    @Override
    public <T> T[] toArray(T[] dummy) {
        throw new UnsupportedOperationException("Unsupported operation on IdentityHashSet.");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator<Map.Entry<E, Object>> i = this.map.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry<E, Object> e = i.next();
            E key = e.getKey();
            buf.append(key);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
}

