/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.InterStorage;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.io.SequenceFileInterStorage;
import org.apache.pig.impl.io.TFileStorage;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.QueryParserDriver;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static boolean checkNullEquals(Object obj1, Object obj2, boolean checkEquality) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        return !checkEquality || obj1.equals(obj2);
    }

    public static boolean checkNullAndClass(Object obj1, Object obj2) {
        if (Utils.checkNullEquals(obj1, obj2, false)) {
            if (obj1 != null) {
                return obj1.getClass() == obj2.getClass();
            }
            return true;
        }
        return false;
    }

    public static Schema getScriptSchema(String loadFuncSignature, Configuration conf) throws IOException {
        Schema scriptSchema = null;
        String scriptField = conf.get(Utils.getScriptSchemaKey(loadFuncSignature));
        if (scriptField != null) {
            scriptSchema = (Schema)ObjectSerializer.deserialize(scriptField);
        }
        return scriptSchema;
    }

    public static String getScriptSchemaKey(String loadFuncSignature) {
        return loadFuncSignature + ".scriptSchema";
    }

    public static ResourceSchema getSchema(LoadFunc wrappedLoadFunc, String location, boolean checkExistence, Job job) throws IOException {
        ReadToEndLoader loader;
        Tuple t;
        Configuration conf = job.getConfiguration();
        if (checkExistence) {
            Path path = new Path(location);
            if (!FileSystem.get((Configuration)conf).exists(path)) {
                return null;
            }
        }
        if ((t = (loader = new ReadToEndLoader(wrappedLoadFunc, conf, location, 0)).getNext()) == null) {
            return null;
        }
        int numFields = t.size();
        Schema s = new Schema();
        for (int i = 0; i < numFields; ++i) {
            try {
                s.add(DataType.determineFieldSchema(t.get(i)));
                continue;
            }
            catch (Exception e) {
                int errCode = 2104;
                String msg = "Error while determining schema of SequenceFileStorage data.";
                throw new ExecException(msg, errCode, 4, e);
            }
        }
        return new ResourceSchema(s);
    }

    public static Schema getSchemaFromString(String schemaString) throws ParserException {
        LogicalSchema schema = Utils.parseSchema(schemaString);
        Schema result = Util.translateSchema(schema);
        Schema.setSchemaDefaultType(result, (byte)50);
        return result;
    }

    public static Schema getSchemaFromBagSchemaString(String schemaString) throws ParserException {
        String unwrappedSchemaString = schemaString.substring(1, schemaString.length() - 1);
        return Utils.getSchemaFromString(unwrappedSchemaString);
    }

    public static LogicalSchema parseSchema(String schemaString) throws ParserException {
        QueryParserDriver queryParser = new QueryParserDriver(new PigContext(), "util", new HashMap<String, String>());
        LogicalSchema schema = queryParser.parseSchema(schemaString);
        return schema;
    }

    public static ResourceSchema getSchemaWithInputSourceTag(ResourceSchema schema, String fieldName) {
        ResourceSchema.ResourceFieldSchema[] fieldSchemas = schema.getFields();
        ResourceSchema.ResourceFieldSchema sourceTagSchema = new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(fieldName, 55));
        ResourceSchema.ResourceFieldSchema[] fieldSchemasWithSourceTag = new ResourceSchema.ResourceFieldSchema[fieldSchemas.length + 1];
        fieldSchemasWithSourceTag[0] = sourceTagSchema;
        for (int j = 0; j < fieldSchemas.length; ++j) {
            fieldSchemasWithSourceTag[j + 1] = fieldSchemas[j];
        }
        return schema.setFields(fieldSchemasWithSourceTag);
    }

    public static String getTmpFileCompressorName(PigContext pigContext) {
        if (pigContext == null) {
            return InterStorage.class.getName();
        }
        String codec = pigContext.getProperties().getProperty("pig.tmpfilecompression.codec", "");
        if (codec.equals(TEMPFILE_CODEC.LZO.lowerName())) {
            pigContext.getProperties().setProperty("io.compression.codec.lzo.class", "com.hadoop.compression.lzo.LzoCodec");
        }
        return Utils.getTmpFileStorage(pigContext.getProperties()).getStorageClass().getName();
    }

    public static FileInputLoadFunc getTmpFileStorageObject(Configuration conf) throws IOException {
        Class<? extends FileInputLoadFunc> storageClass = Utils.getTmpFileStorage(ConfigurationUtil.toProperties(conf)).getStorageClass();
        try {
            return storageClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    private static TEMPFILE_STORAGE getTmpFileStorage(Properties properties) {
        boolean tmpFileCompression = properties.getProperty("pig.tmpfilecompression", "false").equals("true");
        String tmpFileCompressionStorage = properties.getProperty("pig.tmpfilecompression.storage", TEMPFILE_STORAGE.TFILE.lowerName());
        if (!tmpFileCompression) {
            return TEMPFILE_STORAGE.INTER;
        }
        if (TEMPFILE_STORAGE.SEQFILE.lowerName().equals(tmpFileCompressionStorage)) {
            return TEMPFILE_STORAGE.SEQFILE;
        }
        if (TEMPFILE_STORAGE.TFILE.lowerName().equals(tmpFileCompressionStorage)) {
            return TEMPFILE_STORAGE.TFILE;
        }
        throw new IllegalArgumentException("Unsupported storage format " + tmpFileCompressionStorage + ". Should be one of " + Arrays.toString((Object[])TEMPFILE_STORAGE.values()));
    }

    public static void setTmpFileCompressionOnConf(PigContext pigContext, Configuration conf) throws IOException {
        if (pigContext == null) {
            return;
        }
        TEMPFILE_STORAGE storage = Utils.getTmpFileStorage(pigContext.getProperties());
        String codec = pigContext.getProperties().getProperty("pig.tmpfilecompression.codec", "");
        switch (storage) {
            case INTER: {
                break;
            }
            case SEQFILE: {
                conf.setBoolean("mapred.output.compress", true);
                conf.set("pig.tmpfilecompression.storage", "seqfile");
                if ("".equals(codec)) {
                    log.warn((Object)"Temporary file compression codec is not specified. Using mapred.output.compression.codec property.");
                    if (conf.get("mapred.output.compression.codec") != null) break;
                    throw new IOException("mapred.output.compression.codec is not set");
                }
                if (storage.ensureCodecSupported(codec)) {
                    conf.set("mapred.output.compression.codec", TEMPFILE_CODEC.valueOf(codec.toUpperCase()).getHadoopCodecClassName());
                    break;
                }
                throw new IOException("Invalid temporary file compression codec [" + codec + "]. " + "Expected compression codecs for " + storage.getStorageClass().getName() + " are " + storage.supportedCodecsToString() + ".");
            }
            case TFILE: {
                if (storage.ensureCodecSupported(codec)) {
                    conf.set("pig.tmpfilecompression.codec", codec.toLowerCase());
                    break;
                }
                throw new IOException("Invalid temporary file compression codec [" + codec + "]. " + "Expected compression codecs for " + storage.getStorageClass().getName() + " are " + storage.supportedCodecsToString() + ".");
            }
        }
    }

    public static String getStringFromArray(String[] arr) {
        StringBuilder str = new StringBuilder();
        for (String s : arr) {
            str.append(s);
            str.append(" ");
        }
        return str.toString();
    }

    public static FuncSpec buildSimpleFuncSpec(String className, byte ... types) {
        ArrayList<Schema.FieldSchema> fieldSchemas = Lists.newArrayListWithExpectedSize(types.length);
        for (byte type : types) {
            fieldSchemas.add(new Schema.FieldSchema(null, type));
        }
        return new FuncSpec(className, new Schema(fieldSchemas));
    }

    public static String slashisize(String str) {
        return str.replace("\\\\", "\\");
    }

    public static <O> Collection<O> mergeCollection(Collection<O> a, Collection<O> b) {
        if (a == null && b == null) {
            return null;
        }
        Collection result = null;
        try {
            result = a != null ? (Collection)a.getClass().newInstance() : (Collection)b.getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (a == null) {
            result.addAll(b);
        } else if (b == null) {
            result.addAll(a);
        } else {
            result.addAll(a);
            for (O o : b) {
                if (result.contains(o)) continue;
                result.add(o);
            }
        }
        return result;
    }

    public static InputStream getCompositeStream(InputStream in, Properties properties) {
        String bootupFile = properties.getProperty("pig.load.default.statements", System.getProperty("user.home") + "/.pigbootup");
        try {
            FileInputStream inputSteam = new FileInputStream(new File(bootupFile));
            return new SequenceInputStream(inputSteam, in);
        }
        catch (FileNotFoundException fe) {
            log.info((Object)("Default bootup file " + bootupFile + " not found"));
            return in;
        }
    }

    public static long getPathLength(FileSystem fs, FileStatus status) throws IOException {
        if (!status.isDir()) {
            return status.getLen();
        }
        FileStatus[] children = fs.listStatus(status.getPath());
        long size = 0L;
        for (FileStatus child : children) {
            size += Utils.getPathLength(fs, child);
        }
        return size;
    }

    private static enum TEMPFILE_STORAGE {
        INTER(InterStorage.class, null),
        TFILE(TFileStorage.class, Arrays.asList(TEMPFILE_CODEC.GZ, TEMPFILE_CODEC.GZIP, TEMPFILE_CODEC.LZO)),
        SEQFILE(SequenceFileInterStorage.class, Arrays.asList(TEMPFILE_CODEC.GZ, TEMPFILE_CODEC.GZIP, TEMPFILE_CODEC.LZO, TEMPFILE_CODEC.SNAPPY, TEMPFILE_CODEC.BZIP2));

        private Class<? extends FileInputLoadFunc> storageClass;
        private List<TEMPFILE_CODEC> supportedCodecs;

        private TEMPFILE_STORAGE(Class<? extends FileInputLoadFunc> storageClass, List<TEMPFILE_CODEC> supportedCodecs) {
            this.storageClass = storageClass;
            this.supportedCodecs = supportedCodecs;
        }

        public String lowerName() {
            return this.name().toLowerCase();
        }

        public Class<? extends FileInputLoadFunc> getStorageClass() {
            return this.storageClass;
        }

        public boolean ensureCodecSupported(String codec) {
            try {
                return this.supportedCodecs.contains((Object)TEMPFILE_CODEC.valueOf(codec.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public String supportedCodecsToString() {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (TEMPFILE_CODEC codec : this.supportedCodecs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(codec.name());
            }
            return sb.toString();
        }
    }

    private static enum TEMPFILE_CODEC {
        GZ(GzipCodec.class.getName()),
        GZIP(GzipCodec.class.getName()),
        LZO("com.hadoop.compression.lzo.LzoCodec"),
        SNAPPY("org.xerial.snappy.SnappyCodec"),
        BZIP2(BZip2Codec.class.getName());

        private String hadoopCodecClassName;

        private TEMPFILE_CODEC(String codecClassName) {
            this.hadoopCodecClassName = codecClassName;
        }

        public String lowerName() {
            return this.name().toLowerCase();
        }

        public String getHadoopCodecClassName() {
            return this.hadoopCodecClassName;
        }
    }
}

