/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Expression;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;

public class FilterExtractor {
    private static final Log LOG = LogFactory.getLog(FilterExtractor.class);
    private List<String> partitionCols;
    protected LogicalExpressionPlan originalPlan;
    protected LogicalExpressionPlan filteredPlan;
    protected LogicalExpressionPlan pushdownExprPlan;
    private LogicalExpression filterExpr = null;
    private Expression pushdownExpr = null;

    public FilterExtractor(LogicalExpressionPlan plan, List<String> partitionCols) {
        this.originalPlan = plan;
        this.partitionCols = new ArrayList<String>(partitionCols);
        this.filteredPlan = new LogicalExpressionPlan();
        this.pushdownExprPlan = new LogicalExpressionPlan();
    }

    public void visit() throws FrontendException {
        LogicalExpression leaf = (LogicalExpression)this.originalPlan.getSources().get(0);
        if (leaf instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)leaf;
            KeyState finale = this.checkPushDown(binExpr);
            this.filterExpr = finale.filterExpr;
            this.pushdownExpr = FilterExtractor.getExpression(finale.pushdownExpr);
        }
    }

    public LogicalExpressionPlan getFilteredPlan() {
        return this.filteredPlan;
    }

    public boolean canPushDown() {
        return this.pushdownExpr != null;
    }

    public boolean isFilterRemovable() {
        return this.filterExpr == null;
    }

    public Expression getPColCondition() {
        return this.pushdownExpr;
    }

    private KeyState checkPushDown(LogicalExpression op) throws FrontendException {
        if (op instanceof ProjectExpression) {
            return this.checkPushDown((ProjectExpression)op);
        }
        if (op instanceof BinaryExpression) {
            return this.checkPushDown((BinaryExpression)op);
        }
        if (op instanceof ConstantExpression) {
            KeyState state = new KeyState();
            state.pushdownExpr = op;
            state.filterExpr = null;
            return state;
        }
        KeyState state = new KeyState();
        state.pushdownExpr = null;
        state.filterExpr = this.addToFilterPlan(op);
        return state;
    }

    private LogicalExpression addToFilterPlan(LogicalExpression op) throws FrontendException {
        LogicalExpression newOp = op.deepCopy(this.filteredPlan);
        return newOp;
    }

    private LogicalExpression andLogicalExpressions(LogicalExpressionPlan plan, LogicalExpression a, LogicalExpression b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        AndExpression andOp = new AndExpression(plan, a, b);
        return andOp;
    }

    private LogicalExpression orLogicalExpressions(LogicalExpressionPlan plan, LogicalExpression a, LogicalExpression b) {
        if (a == null || b == null) {
            return null;
        }
        OrExpression orOp = new OrExpression(plan, a, b);
        return orOp;
    }

    private KeyState checkPushDown(BinaryExpression binExpr) throws FrontendException {
        KeyState state = new KeyState();
        KeyState leftState = this.checkPushDown(binExpr.getLhs());
        KeyState rightState = this.checkPushDown(binExpr.getRhs());
        if (binExpr instanceof AndExpression) {
            state.pushdownExpr = this.andLogicalExpressions(this.pushdownExprPlan, leftState.pushdownExpr, rightState.pushdownExpr);
            state.filterExpr = this.andLogicalExpressions(this.filteredPlan, leftState.filterExpr, rightState.filterExpr);
        } else if (binExpr instanceof OrExpression) {
            state.pushdownExpr = this.orLogicalExpressions(this.pushdownExprPlan, leftState.pushdownExpr, rightState.pushdownExpr);
            if (state.pushdownExpr == null) {
                this.removeFromFilteredPlan(leftState.filterExpr);
                this.removeFromFilteredPlan(rightState.filterExpr);
                state.filterExpr = this.addToFilterPlan(binExpr);
            } else {
                LogicalExpression f1 = this.orLogicalExpressions(this.filteredPlan, leftState.pushdownExpr, rightState.filterExpr);
                LogicalExpression f2 = this.orLogicalExpressions(this.filteredPlan, leftState.filterExpr, rightState.pushdownExpr);
                LogicalExpression f3 = this.orLogicalExpressions(this.filteredPlan, leftState.filterExpr, rightState.filterExpr);
                state.filterExpr = this.andLogicalExpressions(this.filteredPlan, f1, this.andLogicalExpressions(this.filteredPlan, f2, f3));
            }
        } else if (leftState.filterExpr == null && rightState.filterExpr == null) {
            state.pushdownExpr = binExpr;
            state.filterExpr = null;
        } else {
            state.pushdownExpr = null;
            this.removeFromFilteredPlan(leftState.filterExpr);
            this.removeFromFilteredPlan(rightState.filterExpr);
            state.filterExpr = this.addToFilterPlan(binExpr);
        }
        return state;
    }

    private KeyState checkPushDown(ProjectExpression project) throws FrontendException {
        String fieldName = project.getFieldSchema().alias;
        KeyState state = new KeyState();
        if (this.partitionCols.contains(fieldName)) {
            state.filterExpr = null;
            state.pushdownExpr = project;
        } else {
            state.filterExpr = this.addToFilterPlan(project);
            state.pushdownExpr = null;
        }
        return state;
    }

    private void removeFromFilteredPlan(Operator op) throws FrontendException {
        List<Operator> succs = this.filteredPlan.getSuccessors(op);
        if (succs == null) {
            this.filteredPlan.remove(op);
            return;
        }
        Operator[] children = new Operator[succs.size()];
        for (int i = 0; i < succs.size(); ++i) {
            children[i] = succs.get(i);
        }
        for (Operator succ : children) {
            this.filteredPlan.disconnect(op, succ);
            this.removeFromFilteredPlan(succ);
        }
        this.filteredPlan.remove(op);
    }

    public static Expression getExpression(LogicalExpression op) throws FrontendException {
        if (op == null) {
            return null;
        }
        if (op instanceof ConstantExpression) {
            ConstantExpression constExpr = (ConstantExpression)op;
            return new Expression.Const(constExpr.getValue());
        }
        if (op instanceof ProjectExpression) {
            ProjectExpression projExpr = (ProjectExpression)op;
            String fieldName = projExpr.getFieldSchema().alias;
            return new Expression.Column(fieldName);
        }
        if (!(op instanceof BinaryExpression)) {
            LOG.error((Object)("Unsupported conversion of LogicalExpression to Expression: " + op.getName()));
            throw new FrontendException("Unsupported conversion of LogicalExpression to Expression: " + op.getName());
        }
        BinaryExpression binOp = (BinaryExpression)op;
        if (binOp instanceof AddExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_PLUS);
        }
        if (binOp instanceof SubtractExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_MINUS);
        }
        if (binOp instanceof MultiplyExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_TIMES);
        }
        if (binOp instanceof DivideExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_DIV);
        }
        if (binOp instanceof ModExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_MOD);
        }
        if (binOp instanceof AndExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_AND);
        }
        if (binOp instanceof OrExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_OR);
        }
        if (binOp instanceof EqualExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_EQ);
        }
        if (binOp instanceof NotEqualExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_NE);
        }
        if (binOp instanceof GreaterThanExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_GT);
        }
        if (binOp instanceof GreaterThanEqualExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_GE);
        }
        if (binOp instanceof LessThanExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_LT);
        }
        if (binOp instanceof LessThanEqualExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_LE);
        }
        if (binOp instanceof RegexExpression) {
            return FilterExtractor.getExpression(binOp, Expression.OpType.OP_MATCH);
        }
        LOG.error((Object)("Unsupported conversion of LogicalExpression to Expression: " + op.getName()));
        throw new FrontendException("Unsupported conversion of LogicalExpression to Expression: " + op.getName());
    }

    private static Expression getExpression(BinaryExpression binOp, Expression.OpType opType) throws FrontendException {
        return new Expression.BinaryExpression(FilterExtractor.getExpression(binOp.getLhs()), FilterExtractor.getExpression(binOp.getRhs()), opType);
    }

    private class KeyState {
        LogicalExpression pushdownExpr;
        LogicalExpression filterExpr;

        private KeyState() {
        }
    }
}

