/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.apache.pig.LoadFunc;
import org.apache.pig.impl.PigContext;
import org.apache.pig.parser.AstPrinter;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.QueryParserDriver;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigscript.parser.PigScriptParser;

public class DryRunGruntParser
extends PigScriptParser {
    private StringBuilder sb = new StringBuilder();
    private PigContext context;
    private Tree parserTree;
    private String source;
    private int toSkip = 0;
    private boolean done = false;
    private boolean hasMacro = false;

    public DryRunGruntParser(Reader stream, String source, PigContext context) {
        super(stream);
        this.source = source;
        this.context = context;
    }

    public String getResult() {
        return this.sb.toString();
    }

    public boolean parseStopOnError() throws IOException {
        this.done = false;
        while (!this.done) {
            try {
                this.parse();
            }
            catch (ParseException e) {
                throw new ParserException("Dry run parsing failed", e);
            }
        }
        return this.hasMacro;
    }

    @Override
    public void prompt() {
    }

    @Override
    protected void quit() {
        this.done = true;
    }

    @Override
    protected void printAliases() throws IOException {
    }

    @Override
    protected void processFsCommand(String[] cmdTokens) throws IOException {
        String cmds = LoadFunc.join((AbstractList)Arrays.asList(cmdTokens), " ");
        this.sb.append("fs ").append(cmds).append("\n");
    }

    @Override
    protected void processShCommand(String[] cmdTokens) throws IOException {
        String cmds = LoadFunc.join((AbstractList)Arrays.asList(cmdTokens), " ");
        this.sb.append("sh ").append(cmds).append("\n");
    }

    @Override
    protected void processSQLCommand(String cmd) throws IOException {
        this.sb.append("sql ").append(cmd).append("\n");
    }

    @Override
    protected void processDescribe(String alias) throws IOException {
        this.sb.append("describe ").append(alias).append(";\n");
    }

    @Override
    protected void processExplain(String alias, String script, boolean isVerbose, String format, String target, List<String> params, List<String> files) throws IOException, ParseException {
        this.sb.append("explain ");
        if (script != null) {
            this.sb.append("-script ").append(script).append(" ");
        }
        if (target != null) {
            this.sb.append("-out ").append(target).append(" ");
        }
        if (isVerbose) {
            this.sb.append("-brief ");
        }
        if (format != null && format.equals("dot")) {
            this.sb.append("-dot ");
        }
        if (format != null && format.equals("xml")) {
            this.sb.append("-xml ");
        }
        if (params != null) {
            for (String param : params) {
                this.sb.append("-param ").append(param).append(" ");
            }
        }
        if (files != null) {
            for (String file : files) {
                this.sb.append("-param_file ").append(file).append(" ");
            }
        }
        if (alias != null) {
            this.sb.append(alias);
        }
        this.sb.append("\n");
    }

    @Override
    protected void processRegister(String jar) throws IOException {
        this.sb.append("register ").append(jar).append(";\n");
    }

    @Override
    protected void processRegister(String path, String scriptingEngine, String namespace) throws IOException, ParseException {
        this.sb.append("register '").append(path).append("'");
        if (scriptingEngine != null) {
            this.sb.append(" using ").append(scriptingEngine);
        }
        if (namespace != null) {
            this.sb.append(" as ").append(namespace);
        }
        this.sb.append(";\n");
    }

    @Override
    protected void processSet(String key, String value) throws IOException, ParseException {
        this.sb.append("set ").append(key).append(" ").append(value).append("\n");
    }

    @Override
    protected void processSet() throws IOException {
        this.sb.append("set\n");
    }

    @Override
    protected void processCat(String path) throws IOException {
        this.sb.append("cat ").append(path).append("\n");
    }

    @Override
    protected void processCD(String path) throws IOException {
        this.sb.append("cd ").append(path).append("\n");
    }

    @Override
    protected void processDump(String alias) throws IOException {
        this.sb.append("dump ").append(alias).append("\n");
    }

    @Override
    protected void processKill(String jobid) throws IOException {
        this.sb.append("kill ").append(jobid).append("\n");
    }

    @Override
    protected void processLS(String path) throws IOException {
        this.sb.append("ls");
        if (path != null) {
            this.sb.append(" ").append(path);
        }
        this.sb.append("\n");
    }

    @Override
    protected void processPWD() throws IOException {
        this.sb.append("pwd\n");
    }

    @Override
    protected void printHelp() {
    }

    @Override
    protected void processHistory(boolean withNumbers) {
    }

    @Override
    protected void processMove(String src, String dst) throws IOException {
        this.sb.append("mv ").append(src).append(" ").append(dst).append("\n");
    }

    @Override
    protected void processCopy(String src, String dst) throws IOException {
        this.sb.append("cp ").append(src).append(" ").append(dst).append("\n");
    }

    @Override
    protected void processCopyToLocal(String src, String dst) throws IOException {
        this.sb.append("CopyToLocal ").append(src).append(" ").append(dst).append("\n");
    }

    @Override
    protected void processCopyFromLocal(String src, String dst) throws IOException {
        this.sb.append("CopyFrom,Local ").append(src).append(" ").append(dst).append("\n");
    }

    @Override
    protected void processMkdir(String dir) throws IOException {
        this.sb.append("mkdir ").append(dir).append("\n");
    }

    @Override
    protected void processPig(String cmd) throws IOException {
        int start = this.getLineNumber();
        StringBuilder blder = new StringBuilder();
        for (int i = 1; i < start; ++i) {
            blder.append("\n");
        }
        if (cmd.charAt(cmd.length() - 1) != ';') {
            cmd = cmd + ";";
        }
        blder.append(cmd);
        cmd = blder.toString();
        CommonTokenStream tokenStream = QueryParserDriver.tokenize(cmd, this.source);
        Tree ast = null;
        try {
            ast = QueryParserDriver.parse(tokenStream);
        }
        catch (RuntimeException ex) {
            throw new ParserException(ex.getMessage());
        }
        if (!this.hasMacro) {
            ArrayList<CommonTree> importNodes = new ArrayList<CommonTree>();
            ArrayList<CommonTree> macroNodes = new ArrayList<CommonTree>();
            ArrayList<CommonTree> inlineNodes = new ArrayList<CommonTree>();
            QueryParserDriver.traverseImport(ast, importNodes);
            QueryParserDriver.traverse(ast, macroNodes, inlineNodes);
            if (!(importNodes.isEmpty() && macroNodes.isEmpty() && inlineNodes.isEmpty())) {
                this.hasMacro = true;
            }
        }
        if (this.parserTree == null) {
            this.parserTree = ast;
        } else {
            int n = ast.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.parserTree.addChild(ast.getChild(i));
            }
        }
        CommonTree dup = (CommonTree)this.parserTree.dupNode();
        dup.addChildren(((CommonTree)this.parserTree).getChildren());
        QueryParserDriver driver = new QueryParserDriver(this.context, "0", new HashMap<String, String>());
        Tree newAst = driver.expandMacro(dup);
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(newAst);
        AstPrinter walker = new AstPrinter(nodes);
        try {
            walker.query();
        }
        catch (RecognitionException e) {
            throw new ParserException("Failed to print AST for command " + cmd, e);
        }
        String result = walker.getResult().trim();
        if (!result.isEmpty()) {
            String[] lines = result.split("\n");
            for (int i = this.toSkip; i < lines.length; ++i) {
                this.sb.append(lines[i]).append("\n");
                ++this.toSkip;
            }
        }
    }

    @Override
    protected void processRemove(String path, String opt) throws IOException {
        if (opt == null || !opt.equalsIgnoreCase("force")) {
            this.sb.append("rm ");
        } else {
            this.sb.append("rmf ");
        }
        this.sb.append(path).append("\n");
    }

    @Override
    protected void processIllustrate(String alias, String script, String target, List<String> params, List<String> files) throws IOException, ParseException {
        this.sb.append("illustrate ");
        if (script != null) {
            this.sb.append("-script ").append(script).append(" ");
        }
        if (target != null) {
            this.sb.append("-out ").append(target).append(" ");
        }
        if (params != null) {
            for (String param : params) {
                this.sb.append("-param ").append(param).append(" ");
            }
        }
        if (files != null) {
            for (String file : files) {
                this.sb.append("-param_file ").append(file).append(" ");
            }
        }
        if (alias != null) {
            this.sb.append(alias);
        }
        this.sb.append("\n");
    }

    @Override
    protected void processScript(String script, boolean batch, List<String> params, List<String> files) throws IOException, ParseException {
        if (batch) {
            this.sb.append("exec ");
        } else {
            this.sb.append("run ");
        }
        if (params != null) {
            for (String param : params) {
                this.sb.append("-param ").append(param).append(" ");
            }
        }
        if (files != null) {
            for (String file : files) {
                this.sb.append("-param_file ").append(file).append(" ");
            }
        }
        this.sb.append(script).append("\n");
    }

    @Override
    protected void printClear() {
    }
}

