/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.hbase;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.joda.time.DateTime;

public class HBaseBinaryConverter
implements LoadStoreCaster {
    @Override
    public String bytesToCharArray(byte[] b) throws IOException {
        return Bytes.toString((byte[])b);
    }

    @Override
    public Double bytesToDouble(byte[] b) throws IOException {
        if (8 > b.length) {
            return Bytes.toDouble((byte[])Bytes.padHead((byte[])b, (int)(8 - b.length)));
        }
        return Bytes.toDouble((byte[])Bytes.head((byte[])b, (int)8));
    }

    @Override
    public Float bytesToFloat(byte[] b) throws IOException {
        if (4 > b.length) {
            return Float.valueOf(Bytes.toFloat((byte[])Bytes.padHead((byte[])b, (int)(4 - b.length))));
        }
        return Float.valueOf(Bytes.toFloat((byte[])Bytes.head((byte[])b, (int)4)));
    }

    @Override
    public Integer bytesToInteger(byte[] b) throws IOException {
        if (4 > b.length) {
            return Bytes.toInt((byte[])Bytes.padHead((byte[])b, (int)(4 - b.length)));
        }
        return Bytes.toInt((byte[])Bytes.head((byte[])b, (int)4));
    }

    @Override
    public Long bytesToLong(byte[] b) throws IOException {
        if (8 > b.length) {
            return Bytes.toLong((byte[])Bytes.padHead((byte[])b, (int)(8 - b.length)));
        }
        return Bytes.toLong((byte[])Bytes.head((byte[])b, (int)8));
    }

    @Override
    public Boolean bytesToBoolean(byte[] b) throws IOException {
        if (1 > b.length) {
            return Bytes.toBoolean((byte[])Bytes.padHead((byte[])b, (int)(1 - b.length)));
        }
        return Bytes.toBoolean((byte[])Bytes.head((byte[])b, (int)1));
    }

    @Override
    public DateTime bytesToDateTime(byte[] b) throws IOException {
        throw new ExecException("Can't generate a DateTime from byte[]");
    }

    @Override
    public Map<String, Object> bytesToMap(byte[] b) throws IOException {
        return this.bytesToMap(b, null);
    }

    @Override
    public Map<String, Object> bytesToMap(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate a Map from byte[]");
    }

    @Override
    public Tuple bytesToTuple(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate a Tuple from byte[]");
    }

    @Override
    public DataBag bytesToBag(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate DataBags from byte[]");
    }

    @Override
    public byte[] toBytes(DataBag bag) throws IOException {
        throw new ExecException("Cant' generate bytes from DataBag");
    }

    @Override
    public byte[] toBytes(String s) throws IOException {
        return Bytes.toBytes((String)s);
    }

    @Override
    public byte[] toBytes(Double d) throws IOException {
        return Bytes.toBytes((double)d);
    }

    @Override
    public byte[] toBytes(Float f) throws IOException {
        return Bytes.toBytes((float)f.floatValue());
    }

    @Override
    public byte[] toBytes(Integer i) throws IOException {
        return Bytes.toBytes((int)i);
    }

    @Override
    public byte[] toBytes(Long l) throws IOException {
        return Bytes.toBytes((long)l);
    }

    @Override
    public byte[] toBytes(Boolean b) throws IOException {
        return Bytes.toBytes((boolean)b);
    }

    @Override
    public byte[] toBytes(DateTime dt) throws IOException {
        throw new IOException("Can't generate bytes from DateTime");
    }

    @Override
    public byte[] toBytes(Map<String, Object> m) throws IOException {
        throw new IOException("Can't generate bytes from Map");
    }

    @Override
    public byte[] toBytes(Tuple t) throws IOException {
        throw new IOException("Can't generate bytes from Tuple");
    }

    @Override
    public byte[] toBytes(DataByteArray a) throws IOException {
        return a.get();
    }

    @Override
    public BigInteger bytesToBigInteger(byte[] b) throws IOException {
        throw new ExecException("Can't generate a BigInteger from byte[]");
    }

    @Override
    public BigDecimal bytesToBigDecimal(byte[] b) throws IOException {
        throw new ExecException("Can't generate a BigInteger from byte[]");
    }

    @Override
    public byte[] toBytes(BigInteger bi) throws IOException {
        throw new IOException("Can't generate bytes from BigInteger");
    }

    @Override
    public byte[] toBytes(BigDecimal bd) throws IOException {
        throw new IOException("Can't generate bytes from BigDecimal");
    }
}

