/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.StringConcat;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class CONCAT
extends EvalFunc<DataByteArray> {
    @Override
    public DataByteArray exec(Tuple input) throws IOException {
        try {
            if (input == null || input.size() == 0) {
                return null;
            }
            DataByteArray db = new DataByteArray();
            for (int i = 0; i < input.size(); ++i) {
                if (input.get(i) == null) {
                    return null;
                }
                db.append((DataByteArray)input.get(i));
            }
            return db;
        }
        catch (ExecException exp) {
            throw exp;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing concat in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 50));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 50));
        s.add(new Schema.FieldSchema(null, 50));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(StringConcat.class.getName(), s));
        return funcList;
    }

    @Override
    public EvalFunc.SchemaType getSchemaType() {
        return EvalFunc.SchemaType.VARARG;
    }
}

