/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class StringMax
extends EvalFunc<String>
implements Algebraic,
Accumulator<String> {
    private String intermediateMax = null;

    @Override
    public String exec(Tuple input) throws IOException {
        return StringMax.max(input);
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static String max(Tuple input) throws ExecException {
        Tuple t;
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        Iterator<Tuple> it = values.iterator();
        String curMax = null;
        while (curMax == null && it.hasNext()) {
            t = it.next();
            curMax = (String)t.get(0);
        }
        while (it.hasNext()) {
            t = it.next();
            try {
                String s = (String)t.get(0);
                if (s == null || s.compareTo(curMax) <= 0) continue;
                curMax = s;
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing max of strings.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        return curMax;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 55));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            String curMax = StringMax.max(b);
            if (curMax == null) {
                return;
            }
            if (this.intermediateMax == null || this.intermediateMax.compareTo(curMax) > 0) {
                this.intermediateMax = curMax;
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing max in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateMax = null;
    }

    @Override
    public String getValue() {
        return this.intermediateMax;
    }

    public static class Final
    extends EvalFunc<String> {
        @Override
        public String exec(Tuple input) throws IOException {
            try {
                return StringMax.max(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(StringMax.max(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                String s = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    s = (String)tp.get(0);
                }
                return tfact.newTuple(s);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

