/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.AbstractTuple;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataReaderWriter;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SizeUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleRawComparator;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.util.ObjectSerializer;

public class DefaultTuple
extends AbstractTuple {
    protected boolean isNull = false;
    private static final long serialVersionUID = 2L;
    protected List<Object> mFields;

    public DefaultTuple() {
        this.mFields = new ArrayList<Object>();
    }

    DefaultTuple(int size) {
        this.mFields = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.mFields.add(null);
        }
    }

    DefaultTuple(List<Object> c) {
        this.mFields = new ArrayList<Object>(c);
    }

    DefaultTuple(List<Object> c, int junk) {
        this.mFields = c;
    }

    @Override
    public int size() {
        return this.mFields.size();
    }

    @Override
    public Object get(int fieldNum) throws ExecException {
        return this.mFields.get(fieldNum);
    }

    @Override
    public List<Object> getAll() {
        return this.mFields;
    }

    @Override
    public void set(int fieldNum, Object val) throws ExecException {
        this.mFields.set(fieldNum, val);
    }

    @Override
    public void append(Object val) {
        this.mFields.add(val);
    }

    @Override
    public long getMemorySize() {
        Iterator<Object> i = this.mFields.iterator();
        long empty_tuple_size = 56L;
        long mfields_var_size = SizeUtil.roundToEight(4 + 4 * this.mFields.size());
        mfields_var_size = Math.max(40L, mfields_var_size);
        long sum = empty_tuple_size + mfields_var_size;
        while (i.hasNext()) {
            sum += SizeUtil.getPigObjMemSize(i.next());
        }
        return sum;
    }

    public int compareTo(Object other) {
        if (other instanceof Tuple) {
            Tuple t = (Tuple)other;
            int mySz = this.mFields.size();
            int tSz = t.size();
            if (tSz < mySz) {
                return 1;
            }
            if (tSz > mySz) {
                return -1;
            }
            for (int i = 0; i < mySz; ++i) {
                try {
                    int c = DataType.compare(this.mFields.get(i), t.get(i));
                    if (c == 0) continue;
                    return c;
                }
                catch (ExecException e) {
                    throw new RuntimeException("Unable to compare tuples", e);
                }
            }
            return 0;
        }
        return DataType.compare(this, other);
    }

    public int hashCode() {
        int hash = 17;
        for (Object o : this.mFields) {
            if (o == null) continue;
            hash = 31 * hash + o.hashCode();
        }
        return hash;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(110);
        int sz = this.size();
        out.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            DataReaderWriter.writeDatum(out, this.mFields.get(i));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.mFields.clear();
        byte b = in.readByte();
        if (b != 110) {
            int errCode = 2112;
            String msg = "Unexpected data while reading tuple from binary file.";
            throw new ExecException(msg, errCode, 4);
        }
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            this.append(DataReaderWriter.readDatum(in));
            continue;
        }
    }

    public static Class<? extends TupleRawComparator> getComparatorClass() {
        return DefaultTupleRawComparator.class;
    }

    public static class DefaultTupleRawComparator
    extends WritableComparator
    implements TupleRawComparator {
        private final Log mLog = LogFactory.getLog(this.getClass());
        private boolean[] mAsc;
        private boolean mWholeTuple;
        private boolean mHasNullField;
        private TupleFactory mFact;

        public DefaultTupleRawComparator() {
            super(DefaultTuple.class);
        }

        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration conf) {
            if (!(conf instanceof JobConf)) {
                this.mLog.warn((Object)("Expected jobconf in setConf, got " + conf.getClass().getName()));
                return;
            }
            JobConf jconf = (JobConf)conf;
            try {
                this.mAsc = (boolean[])ObjectSerializer.deserialize(jconf.get("pig.sortOrder"));
            }
            catch (IOException ioe) {
                this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
                throw new RuntimeException(ioe);
            }
            if (this.mAsc == null) {
                this.mAsc = new boolean[1];
                this.mAsc[0] = true;
            }
            this.mWholeTuple = this.mAsc.length == 1;
            this.mFact = TupleFactory.getInstance();
        }

        @Override
        public boolean hasComparedTupleNull() {
            return this.mHasNullField;
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            ByteBuffer bb1 = ByteBuffer.wrap(b1, s1, l1);
            ByteBuffer bb2 = ByteBuffer.wrap(b2, s2, l2);
            int rc = this.compareDefaultTuple(bb1, bb2, true);
            return rc;
        }

        private int compareDefaultTuple(ByteBuffer bb1, ByteBuffer bb2, boolean topLevel) {
            int sz2;
            this.mHasNullField = false;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int rc = 0;
            byte tupleType1 = bb1.get();
            byte tupleType2 = bb2.get();
            assert (tupleType1 == tupleType2 && tupleType1 == 110);
            int sz1 = bb1.getInt();
            if (sz1 > (sz2 = bb2.getInt())) {
                return 1;
            }
            if (sz1 < sz2) {
                return -1;
            }
            for (int i = 0; i < sz1 && rc == 0; ++i) {
                block30: {
                    byte dt2;
                    byte dt1;
                    block29: {
                        dt1 = bb1.get();
                        if (dt1 != (dt2 = bb2.get())) break block29;
                        switch (dt1) {
                            case 1: {
                                if (topLevel) {
                                    this.mHasNullField = true;
                                }
                                rc = 0;
                                break;
                            }
                            case 5: 
                            case 6: {
                                byte bv1 = bb1.get();
                                byte bv2 = bb2.get();
                                rc = bv1 < bv2 ? -1 : (bv1 == bv2 ? 0 : 1);
                                break;
                            }
                            case 10: {
                                int iv1 = bb1.getInt();
                                int iv2 = bb2.getInt();
                                rc = iv1 < iv2 ? -1 : (iv1 == iv2 ? 0 : 1);
                                break;
                            }
                            case 15: {
                                long lv1 = bb1.getLong();
                                long lv2 = bb2.getLong();
                                rc = lv1 < lv2 ? -1 : (lv1 == lv2 ? 0 : 1);
                                break;
                            }
                            case 20: {
                                float fv1 = bb1.getFloat();
                                float fv2 = bb2.getFloat();
                                rc = Float.compare(fv1, fv2);
                                break;
                            }
                            case 25: {
                                double dv1 = bb1.getDouble();
                                double dv2 = bb2.getDouble();
                                rc = Double.compare(dv1, dv2);
                                break;
                            }
                            case 65: {
                                if (bb1.get() != 50 || bb2.get() != 50) {
                                    throw new RuntimeException("Issue in comparing raw bytes for DefaultTuple! BIGINTEGER was not serialized with BYTEARRAY");
                                }
                                int basz1 = bb1.getInt();
                                int basz2 = bb2.getInt();
                                byte[] ba1 = new byte[basz1];
                                byte[] ba2 = new byte[basz2];
                                bb1.get(ba1);
                                bb2.get(ba2);
                                rc = new BigInteger(ba1).compareTo(new BigInteger(ba2));
                                break;
                            }
                            case 70: {
                                byte catype1 = bb1.get();
                                byte catype2 = bb2.get();
                                int casz1 = catype1 == 55 ? bb1.getShort() : bb1.getInt();
                                int casz2 = catype2 == 55 ? bb2.getShort() : bb2.getInt();
                                byte[] ca1 = new byte[casz1];
                                byte[] ca2 = new byte[casz2];
                                bb1.get(ca1);
                                bb2.get(ca2);
                                String str1 = null;
                                String str2 = null;
                                try {
                                    str1 = new String(ca1, "UTF-8");
                                    str2 = new String(ca2, "UTF-8");
                                }
                                catch (UnsupportedEncodingException uee) {
                                    this.mLog.warn((Object)"Unsupported string encoding", (Throwable)uee);
                                    uee.printStackTrace();
                                }
                                if (str1 != null && str2 != null) {
                                    rc = new BigDecimal(str1).compareTo(new BigDecimal(str2));
                                    break;
                                }
                                break block30;
                            }
                            case 30: {
                                long dtv1 = bb1.getLong();
                                bb1.position(bb1.position() + 2);
                                long dtv2 = bb2.getLong();
                                bb2.position(bb2.position() + 2);
                                rc = dtv1 < dtv2 ? -1 : (dtv1 == dtv2 ? 0 : 1);
                                break;
                            }
                            case 50: {
                                int basz1 = bb1.getInt();
                                int basz2 = bb2.getInt();
                                byte[] ba1 = new byte[basz1];
                                byte[] ba2 = new byte[basz2];
                                bb1.get(ba1);
                                bb2.get(ba2);
                                rc = DataByteArray.compare(ba1, ba2);
                                break;
                            }
                            case 55: 
                            case 60: {
                                int casz1 = dt1 == 55 ? bb1.getShort() : bb1.getInt();
                                int casz2 = dt1 == 55 ? bb2.getShort() : bb2.getInt();
                                byte[] ca1 = new byte[casz1];
                                byte[] ca2 = new byte[casz2];
                                bb1.get(ca1);
                                bb2.get(ca2);
                                String str1 = null;
                                String str2 = null;
                                try {
                                    str1 = new String(ca1, "UTF-8");
                                    str2 = new String(ca2, "UTF-8");
                                }
                                catch (UnsupportedEncodingException uee) {
                                    this.mLog.warn((Object)"Unsupported string encoding", (Throwable)uee);
                                    uee.printStackTrace();
                                }
                                if (str1 != null && str2 != null) {
                                    rc = str1.compareTo(str2);
                                    break;
                                }
                                break block30;
                            }
                            case 110: {
                                bb1.position(bb1.position() - 1);
                                bb2.position(bb2.position() - 1);
                                rc = this.compareDefaultTuple(bb1, bb2, false);
                                break;
                            }
                            default: {
                                this.mLog.info((Object)("Unsupported DataType for binary comparison, switching to object deserialization: " + DataType.genTypeToNameMap().get(dt1) + "(" + dt1 + ")"));
                                Tuple t1 = this.mFact.newTuple();
                                Tuple t2 = this.mFact.newTuple();
                                try {
                                    t1.readFields(new DataInputStream(new ByteArrayInputStream(bb1.array(), s1, bb1.limit())));
                                    t2.readFields(new DataInputStream(new ByteArrayInputStream(bb2.array(), s2, bb2.limit())));
                                }
                                catch (IOException ioe) {
                                    this.mLog.error((Object)("Unable to instantiate tuples for comparison: " + ioe.getMessage()));
                                    throw new RuntimeException(ioe.getMessage(), ioe);
                                }
                                return this.compareTuple(t1, t2);
                            }
                        }
                        break block30;
                    }
                    rc = dt1 < dt2 ? -1 : 1;
                }
                if (rc == 0) continue;
                if (!this.mWholeTuple && !this.mAsc[i]) {
                    rc *= -1;
                    continue;
                }
                if (!this.mWholeTuple || this.mAsc[0]) continue;
                rc *= -1;
            }
            return rc;
        }

        public int compare(Object o1, Object o2) {
            NullableTuple nt1 = (NullableTuple)o1;
            NullableTuple nt2 = (NullableTuple)o2;
            int rc = 0;
            if (!nt1.isNull() && !nt2.isNull()) {
                rc = this.compareTuple((Tuple)nt1.getValueAsPigType(), (Tuple)nt2.getValueAsPigType());
            } else {
                rc = nt1.isNull() && nt2.isNull() ? 0 : (nt1.isNull() ? -1 : 1);
                if (this.mWholeTuple && !this.mAsc[0]) {
                    rc *= -1;
                }
            }
            return rc;
        }

        private int compareTuple(Tuple t1, Tuple t2) {
            int sz1 = t1.size();
            int sz2 = t2.size();
            if (sz2 < sz1) {
                return 1;
            }
            if (sz2 > sz1) {
                return -1;
            }
            for (int i = 0; i < sz1; ++i) {
                try {
                    int c = DataType.compare(t1.get(i), t2.get(i));
                    if (c == 0) continue;
                    if (!this.mWholeTuple && !this.mAsc[i]) {
                        c *= -1;
                    } else if (this.mWholeTuple && !this.mAsc[0]) {
                        c *= -1;
                    }
                    return c;
                }
                catch (ExecException e) {
                    throw new RuntimeException("Unable to compare tuples", e);
                }
            }
            return 0;
        }
    }
}

