/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.avro.AvroStorageDataConversionUtilities;

public class AvroRecordWriter
extends RecordWriter<NullWritable, Object> {
    private Schema schema = null;
    private DataFileWriter<GenericData.Record> writer;
    private Path out;
    private Configuration conf;

    public AvroRecordWriter(Path o, Configuration c) throws IOException {
        this.out = o;
        this.conf = c;
    }

    static void configureDataFileWriter(DataFileWriter<GenericData.Record> writer, JobConf job) throws UnsupportedEncodingException {
        if (FileOutputFormat.getCompressOutput((JobConf)job)) {
            int level = job.getInt("avro.mapred.deflate.level", 1);
            String codecName = job.get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec(level) : CodecFactory.fromString(codecName);
            writer.setCodec(factory);
        }
        writer.setSyncInterval(job.getInt("avro.mapred.sync.interval", 64000));
        for (Map.Entry e : job) {
            if (((String)e.getKey()).startsWith("avro.meta.text.")) {
                writer.setMeta(((String)e.getKey()).substring("avro.meta.text.".length()), (String)e.getValue());
            }
            if (!((String)e.getKey()).startsWith("avro.meta.binary.")) continue;
            writer.setMeta(((String)e.getKey()).substring("avro.meta.binary.".length()), URLDecoder.decode((String)e.getValue(), "ISO-8859-1").getBytes("ISO-8859-1"));
        }
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        this.writer.close();
    }

    public void write(NullWritable key, Object value) throws IOException, InterruptedException {
        if (value instanceof GenericData.Record) {
            this.writer.append((GenericData.Record)value);
        } else if (value instanceof Tuple) {
            this.writer.append(AvroStorageDataConversionUtilities.packIntoAvro((Tuple)value, this.schema));
        }
    }

    public void prepareToWrite(Schema s) throws IOException {
        if (s == null) {
            throw new IOException(((Object)((Object)this)).getClass().getName() + ".prepareToWrite called with null schema");
        }
        this.schema = s;
        GenericDatumWriter datumWriter = new GenericDatumWriter(s);
        this.writer = new DataFileWriter(datumWriter);
        AvroRecordWriter.configureDataFileWriter(this.writer, new JobConf(this.conf));
        this.writer.create(s, (OutputStream)this.out.getFileSystem(this.conf).create(this.out));
    }
}

