/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

class DNFExpression
extends LogicalExpression {
    final DNFExpressionType type;

    DNFExpression(String name, OperatorPlan plan, DNFExpressionType type) {
        super(name, plan);
        this.type = type;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        throw new FrontendException("DNF expression does not accept any visitor");
    }

    @Override
    public boolean isEqual(Operator other) {
        if (other != null && other instanceof DNFExpression) {
            DNFExpression otherexp = (DNFExpression)other;
            if (this.type != otherexp.type) {
                return false;
            }
            try {
                List<Operator> thisChildren = this.plan.getSuccessors(this);
                List<Operator> thatChildren = this.plan.getSuccessors(otherexp);
                if (thisChildren == null && thatChildren == null) {
                    return true;
                }
                if (thisChildren == null || thatChildren == null) {
                    return false;
                }
                if (thisChildren.size() != thatChildren.size()) {
                    return false;
                }
                for (int i = 0; i < thisChildren.size(); ++i) {
                    if (thisChildren.get(i).isEqual(thatChildren.get(i))) continue;
                    return false;
                }
            }
            catch (FrontendException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 5);
        this.fieldSchema.stampFieldSchema();
        return this.fieldSchema;
    }

    @Override
    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        throw new FrontendException("Deepcopy not expected");
    }

    static enum DNFExpressionType {
        AND,
        OR;

    }
}

