/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.OptimizerUtils;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class PushDownForEachFlatten
extends Rule {
    public PushDownForEachFlatten(String name) {
        super(name, false);
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOForEach foreach = new LOForEach(plan);
        plan.add(foreach);
        return plan;
    }

    @Override
    public Transformer getNewTransformer() {
        return new PushDownForEachFlattenTransformer();
    }

    class PushDownForEachFlattenTransformer
    extends Transformer {
        private OperatorSubPlan subPlan;

        PushDownForEachFlattenTransformer() {
        }

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LOForEach foreach = (LOForEach)matched.getSources().get(0);
            LOGenerate gen = OptimizerUtils.findGenerate(foreach);
            if (!OptimizerUtils.hasFlatten(gen)) {
                return false;
            }
            for (LogicalExpressionPlan p : gen.getOutputPlans()) {
                if (!OptimizerUtils.planHasNonDeterministicUdf(p)) continue;
                return false;
            }
            List<Operator> succs = PushDownForEachFlatten.this.currentPlan.getSuccessors(foreach);
            if (succs == null || succs.size() != 1) {
                return false;
            }
            List<Long> uids = this.getNonFlattenFieldUids(gen);
            Operator succ = succs.get(0);
            if (!(succ instanceof LOSort || succ instanceof LOJoin || succ instanceof LOCross)) {
                return false;
            }
            if (succ instanceof LOSort) {
                List<LogicalExpressionPlan> exprs = gen.getOutputPlans();
                for (LogicalExpressionPlan expr : exprs) {
                    if (this.isPureProjection(expr)) continue;
                    return false;
                }
                LOSort sort = (LOSort)succ;
                List<LogicalExpressionPlan> exps = sort.getSortColPlans();
                for (int i = 0; i < exps.size(); ++i) {
                    LogicalExpressionPlan exp = exps.get(i);
                    ProjectExpression proj = (ProjectExpression)exp.getOperators().next();
                    if (uids.contains(proj.getFieldSchema().uid)) continue;
                    return false;
                }
                return true;
            }
            List<Operator> preds = PushDownForEachFlatten.this.currentPlan.getPredecessors(succ);
            for (Operator op : preds) {
                if (op == foreach || !(op instanceof LOForEach) || !OptimizerUtils.hasFlatten(OptimizerUtils.findGenerate((LOForEach)op))) continue;
                return false;
            }
            if (((LogicalRelationalOperator)succ).getSchema() == null) {
                return false;
            }
            if (succ instanceof LOCross) {
                return true;
            }
            LOJoin join = (LOJoin)succ;
            for (int i = 0; i < preds.size(); ++i) {
                Operator op = preds.get(i);
                if (op != foreach) continue;
                Collection<LogicalExpressionPlan> exprs = join.getJoinPlan(i);
                for (LogicalExpressionPlan expr : exprs) {
                    List<ProjectExpression> projs = this.getProjectExpressions(expr);
                    for (ProjectExpression proj : projs) {
                        if (uids.contains(proj.getFieldSchema().uid)) continue;
                        return false;
                    }
                }
                break;
            }
            return true;
        }

        private List<ProjectExpression> getProjectExpressions(LogicalExpressionPlan expr) {
            List<Operator> ops = expr.getSinks();
            ArrayList<ProjectExpression> projs = new ArrayList<ProjectExpression>(ops.size());
            for (Operator op : ops) {
                if (!(op instanceof ProjectExpression)) continue;
                projs.add((ProjectExpression)op);
            }
            return projs;
        }

        private List<Long> getNonFlattenFieldUids(LOGenerate gen) throws FrontendException {
            ArrayList<Long> uids = new ArrayList<Long>();
            List<LogicalExpressionPlan> exprs = gen.getOutputPlans();
            for (int i = 0; i < exprs.size(); ++i) {
                LogicalExpressionPlan expr = exprs.get(i);
                if (gen.getFlattenFlags()[i]) continue;
                LogicalExpression e = (LogicalExpression)expr.getSources().get(0);
                uids.add(e.getFieldSchema().uid);
            }
            return uids;
        }

        private boolean isPureProjection(LogicalExpressionPlan expr) {
            if (expr.size() != 1) {
                return false;
            }
            return expr.getSinks().get(0) instanceof ProjectExpression;
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.subPlan;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.subPlan = new OperatorSubPlan(PushDownForEachFlatten.this.currentPlan);
            LOForEach foreach = (LOForEach)matched.getSources().get(0);
            Operator next = PushDownForEachFlatten.this.currentPlan.getSuccessors(foreach).get(0);
            if (next instanceof LOSort) {
                Operator pred = PushDownForEachFlatten.this.currentPlan.getPredecessors(foreach).get(0);
                ArrayList<Operator> succs = new ArrayList<Operator>();
                succs.addAll(PushDownForEachFlatten.this.currentPlan.getSuccessors(next));
                Pair<Integer, Integer> pos1 = PushDownForEachFlatten.this.currentPlan.disconnect(pred, foreach);
                Pair<Integer, Integer> pos2 = PushDownForEachFlatten.this.currentPlan.disconnect(foreach, next);
                PushDownForEachFlatten.this.currentPlan.connect(pred, (Integer)pos1.first, next, (Integer)pos2.second);
                if (succs != null) {
                    for (Operator succ : succs) {
                        Pair<Integer, Integer> pos = PushDownForEachFlatten.this.currentPlan.disconnect(next, succ);
                        PushDownForEachFlatten.this.currentPlan.connect(next, (Integer)pos.first, foreach, 0);
                        PushDownForEachFlatten.this.currentPlan.connect(foreach, 0, succ, (Integer)pos.second);
                    }
                } else {
                    PushDownForEachFlatten.this.currentPlan.connect(next, foreach);
                }
                this.subPlan.add(foreach);
                this.subPlan.add(next);
            } else if (next instanceof LOCross || next instanceof LOJoin) {
                List<Operator> preds = PushDownForEachFlatten.this.currentPlan.getPredecessors(next);
                ArrayList<Integer> fieldsToBeFlattaned = new ArrayList<Integer>();
                HashMap<Integer, LogicalSchema> cachedUserDefinedSchema = new HashMap<Integer, LogicalSchema>();
                boolean[] flags = null;
                int fieldCount = 0;
                for (Operator op : preds) {
                    if (op == foreach) {
                        LOGenerate gen = OptimizerUtils.findGenerate(foreach);
                        flags = gen.getFlattenFlags();
                        for (int i = 0; i < flags.length; ++i) {
                            if (flags[i]) {
                                fieldsToBeFlattaned.add(fieldCount);
                                if (gen.getUserDefinedSchema() != null && gen.getUserDefinedSchema().get(i) != null) {
                                    cachedUserDefinedSchema.put(fieldCount, gen.getUserDefinedSchema().get(i));
                                    gen.getUserDefinedSchema().set(i, null);
                                }
                                ++fieldCount;
                                continue;
                            }
                            ++fieldCount;
                        }
                        continue;
                    }
                    fieldCount += ((LogicalRelationalOperator)op).getSchema().size();
                }
                boolean[] flattenFlags = new boolean[fieldCount];
                ArrayList<LogicalSchema> mUserDefinedSchema = null;
                if (cachedUserDefinedSchema != null) {
                    mUserDefinedSchema = new ArrayList<LogicalSchema>();
                    for (int i = 0; i < fieldCount; ++i) {
                        mUserDefinedSchema.add(null);
                    }
                }
                for (Integer i : fieldsToBeFlattaned) {
                    flattenFlags[i.intValue()] = true;
                    if (!cachedUserDefinedSchema.containsKey(i)) continue;
                    mUserDefinedSchema.set(i, (LogicalSchema)cachedUserDefinedSchema.get(i));
                }
                LOForEach newForeach = new LOForEach(PushDownForEachFlatten.this.currentPlan);
                LogicalPlan innerPlan = new LogicalPlan();
                ArrayList<LogicalExpressionPlan> exprs = new ArrayList<LogicalExpressionPlan>(fieldCount);
                LOGenerate gen = new LOGenerate(innerPlan, exprs, flattenFlags);
                if (mUserDefinedSchema != null) {
                    gen.setUserDefinedSchema(mUserDefinedSchema);
                }
                innerPlan.add(gen);
                newForeach.setInnerPlan(innerPlan);
                for (int i = 0; i < fieldCount; ++i) {
                    LogicalExpressionPlan expr = new LogicalExpressionPlan();
                    expr.add(new ProjectExpression(expr, i, -1, gen));
                    exprs.add(expr);
                    LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, newForeach, i);
                    innerPlan.add(innerLoad);
                    innerPlan.connect(innerLoad, gen);
                }
                newForeach.setAlias(((LogicalRelationalOperator)next).getAlias());
                Operator opAfterX = null;
                List<Operator> succs = PushDownForEachFlatten.this.currentPlan.getSuccessors(next);
                if (succs == null || succs.size() == 0) {
                    PushDownForEachFlatten.this.currentPlan.add(newForeach);
                    PushDownForEachFlatten.this.currentPlan.connect(next, newForeach);
                } else {
                    opAfterX = succs.get(0);
                    PushDownForEachFlatten.this.currentPlan.insertBetween(next, newForeach, opAfterX);
                }
                for (int i = 0; i < flags.length; ++i) {
                    flags[i] = false;
                }
                this.subPlan.add(foreach);
                this.subPlan.add(next);
                this.subPlan.add(newForeach);
            }
        }
    }
}

