/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jython;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.apache.pig.scripting.jython.JythonScriptEngine;
import org.apache.pig.scripting.jython.JythonUtils;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.core.PyTableCode;

public class JythonFunction
extends EvalFunc<Object> {
    private static boolean logOnce = true;
    private PyFunction function;
    private Schema schema;
    private int num_parameters;
    private String scriptFilePath;
    private String outputSchemaFunc;

    public JythonFunction(String filename, String functionName) throws IOException {
        boolean found = false;
        try {
            PyObject schemaFunctionDef;
            PyObject outputSchemaFunctionDef;
            PyFunction f;
            this.function = f = JythonScriptEngine.getFunction(filename, functionName);
            this.num_parameters = ((PyBaseCode)f.func_code).co_argcount;
            PyObject outputSchemaDef = f.__findattr__("outputSchema".intern());
            if (outputSchemaDef != null) {
                this.schema = Utils.getSchemaFromString(outputSchemaDef.toString());
                this.logOnce("Schema '" + outputSchemaDef.toString() + "' defined for func " + functionName);
                found = true;
            }
            if ((outputSchemaFunctionDef = f.__findattr__("outputSchemaFunction".intern())) != null) {
                if (found) {
                    throw new ExecException("multiple decorators for " + functionName);
                }
                this.scriptFilePath = filename;
                this.outputSchemaFunc = outputSchemaFunctionDef.toString();
                this.logOnce("Schema Function '" + this.outputSchemaFunc + "' defined for func " + functionName);
                this.schema = null;
                found = true;
            }
            if ((schemaFunctionDef = f.__findattr__("schemaFunction".intern())) != null) {
                if (found) {
                    throw new ExecException("multiple decorators for " + functionName);
                }
                throw new ExecException("unregistered " + functionName);
            }
            if (!found && outputSchemaFunctionDef == null) {
                this.logOnce("No schema defined for function '" + functionName + "' in " + filename);
            }
        }
        catch (ParserException pe) {
            throw new ExecException("Could not parse schema for script function " + pe, pe);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize: " + filename, e);
        }
        catch (Exception e) {
            throw new ExecException("Could not initialize: " + filename, e);
        }
    }

    private void logOnce(String msg) {
        if (logOnce) {
            this.getLogger().info((Object)msg);
        }
        logOnce = false;
    }

    @Override
    public Object exec(Tuple tuple) throws IOException {
        try {
            if (tuple == null || this.num_parameters == 0 && !((PyTableCode)this.function.func_code).varargs) {
                PyObject out = this.function.__call__();
                return JythonUtils.pythonToPig(out);
            }
            PyObject[] params = JythonUtils.pigTupleToPyTuple(tuple).getArray();
            return JythonUtils.pythonToPig(this.function.__call__(params));
        }
        catch (PyException e) {
            throw new ExecException("Error executing function", e);
        }
        catch (Exception e) {
            throw new IOException("Error executing function", e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.outputSchemaFunc != null) {
            try {
                PyFunction pf = JythonScriptEngine.getFunction(this.scriptFilePath, this.outputSchemaFunc);
                PyObject schemaFunctionDef = pf.__findattr__("schemaFunction".intern());
                if (schemaFunctionDef == null) {
                    throw new IllegalStateException("Function: " + this.outputSchemaFunc + " is not a schema function");
                }
                Object newSchema = pf.__call__(Py.java2py((Object)input)).__tojava__(Object.class);
                if (newSchema instanceof ResourceSchema) {
                    return Schema.getPigSchema((ResourceSchema)newSchema);
                }
                if (newSchema instanceof Schema) {
                    return (Schema)newSchema;
                }
                return Utils.getSchemaFromString(newSchema.toString());
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not find function: " + this.outputSchemaFunc + "()", ioe);
            }
        }
        return new Schema(new Schema.FieldSchema(null, 50));
    }
}

