/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.optimizer.ProjectionPatcher;
import org.apache.pig.newplan.logical.optimizer.SchemaPatcher;
import org.apache.pig.newplan.logical.rules.AddForEach;
import org.apache.pig.newplan.logical.rules.ColumnMapKeyPrune;
import org.apache.pig.newplan.logical.rules.DuplicateForEachColumnRewrite;
import org.apache.pig.newplan.logical.rules.FilterAboveForeach;
import org.apache.pig.newplan.logical.rules.GroupByConstParallelSetter;
import org.apache.pig.newplan.logical.rules.ImplicitSplitInserter;
import org.apache.pig.newplan.logical.rules.LimitOptimizer;
import org.apache.pig.newplan.logical.rules.LoadTypeCastInserter;
import org.apache.pig.newplan.logical.rules.LogicalExpressionSimplifier;
import org.apache.pig.newplan.logical.rules.MergeFilter;
import org.apache.pig.newplan.logical.rules.MergeForEach;
import org.apache.pig.newplan.logical.rules.PartitionFilterOptimizer;
import org.apache.pig.newplan.logical.rules.PushDownForEachFlatten;
import org.apache.pig.newplan.logical.rules.PushUpFilter;
import org.apache.pig.newplan.logical.rules.SplitFilter;
import org.apache.pig.newplan.logical.rules.StreamTypeCastInserter;
import org.apache.pig.newplan.optimizer.PlanOptimizer;
import org.apache.pig.newplan.optimizer.Rule;

public class LogicalPlanOptimizer
extends PlanOptimizer {
    private static final Log LOG = LogFactory.getLog(LogicalPlanOptimizer.class);
    private Set<String> mRulesOff = null;
    private boolean allRulesDisabled = false;
    private SetMultimap<RulesReportKey, String> rulesReport = TreeMultimap.create();

    public LogicalPlanOptimizer(OperatorPlan p, int iterations, Set<String> turnOffRules) {
        super(p, null, iterations);
        HashSet hashSet = this.mRulesOff = turnOffRules == null ? new HashSet() : turnOffRules;
        if (this.mRulesOff.contains("all")) {
            this.allRulesDisabled = true;
        }
        this.ruleSets = this.buildRuleSets();
        LOG.info(this.rulesReport);
        this.addListeners();
    }

    protected List<Set<Rule>> buildRuleSets() {
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        HashSet<Rule> s = new HashSet<Rule>();
        Rule r = new ImplicitSplitInserter("ImplicitSplitInserter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new DuplicateForEachColumnRewrite("DuplicateForEachColumnRewrite");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PartitionFilterOptimizer("NewPartitionFilterOptimizer");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new LogicalExpressionSimplifier("FilterLogicExpressionSimplifier");
        this.checkAndAddRule(s, r);
        ls.add(s);
        s = new HashSet();
        r = new LoadTypeCastInserter("LoadTypeCastInserter");
        this.checkAndAddRule(s, r);
        r = new StreamTypeCastInserter("StreamTypeCastInserter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new SplitFilter("SplitFilter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PushUpFilter("PushUpFilter");
        this.checkAndAddRule(s, r);
        r = new FilterAboveForeach("PushUpFilter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        this.checkAndAddRule(s, r);
        r = new MergeFilter("MergeFilter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PartitionFilterOptimizer("PartitionFilterOptimizer");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PushDownForEachFlatten("PushDownForEachFlatten");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new ColumnMapKeyPrune("ColumnMapKeyPrune");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new AddForEach("AddForEach");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new MergeForEach("MergeForEach");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new GroupByConstParallelSetter("GroupByConstParallelSetter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new LimitOptimizer("LimitOptimizer");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        return ls;
    }

    private void checkAndAddRule(Set<Rule> ruleSet, Rule rule) {
        Preconditions.checkArgument(ruleSet != null);
        Preconditions.checkArgument(rule != null && rule.getName() != null);
        if (rule.isMandatory()) {
            ruleSet.add(rule);
            this.rulesReport.put(RulesReportKey.RULES_ENABLED, rule.getName());
        } else if (!this.allRulesDisabled && !this.mRulesOff.contains(rule.getName())) {
            ruleSet.add(rule);
            this.rulesReport.put(RulesReportKey.RULES_ENABLED, rule.getName());
        } else {
            this.rulesReport.put(RulesReportKey.RULES_DISABLED, rule.getName());
        }
    }

    private void addListeners() {
        this.addPlanTransformListener(new SchemaPatcher());
        this.addPlanTransformListener(new ProjectionPatcher());
    }

    private static enum RulesReportKey {
        RULES_ENABLED,
        RULES_DISABLED;

    }
}

