/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jython;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.jython.JythonFunction;
import org.apache.pig.tools.pigstats.PigStats;
import org.python.core.ClasspathPyImporter;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.modules.zipimport.zipimporter;
import org.python.util.PythonInterpreter;

public class JythonScriptEngine
extends ScriptEngine {
    private static final Log LOG = LogFactory.getLog(JythonScriptEngine.class);
    private static final Pattern p = Pattern.compile("^\\s*def\\s+(\\w+)\\s*.+");
    private static final Pattern p1 = Pattern.compile("^\\s*if\\s+__name__\\s+==\\s+[\"']__main__[\"']\\s*:\\s*$");

    private static File resolvePyModulePath(String path, Object loader) {
        File file = new File(path);
        if (!file.exists() && loader != null) {
            if (path.startsWith("__pyclasspath__/") && loader instanceof ClasspathPyImporter) {
                URL resource = ScriptEngine.class.getResource(path = path.replaceFirst("__pyclasspath__/", ""));
                if (resource == null) {
                    resource = ScriptEngine.class.getResource(File.separator + path);
                }
                if (resource != null) {
                    return new File(resource.getFile());
                }
            } else if (loader instanceof zipimporter) {
                zipimporter importer = (zipimporter)loader;
                return new File(importer.archive);
            }
        }
        return file;
    }

    @Override
    public void registerFunctions(String path, String namespace, PigContext pigContext) throws IOException {
        Interpreter.setMain(false);
        Interpreter.init(path, pigContext);
        pigContext.scriptJars.add(JythonScriptEngine.getJarPath(PythonInterpreter.class));
        PythonInterpreter pi = Interpreter.interpreter;
        PyList locals = ((PyStringMap)pi.getLocals()).items();
        namespace = namespace == null ? "" : namespace + ".";
        try {
            for (PyTuple item : locals) {
                String key = (String)item.get(0);
                Object value = item.get(1);
                FuncSpec funcspec = null;
                if (key.startsWith("__") || key.equals("schemaFunction") || key.equals("outputSchema") || key.equals("outputSchemaFunction") || !(value instanceof PyFunction) || ((PyFunction)value).__findattr__("schemaFunction") != null) continue;
                PyObject obj = ((PyFunction)value).__findattr__("outputSchema");
                if (obj != null) {
                    Utils.getSchemaFromString(obj.toString());
                }
                funcspec = new FuncSpec(JythonFunction.class.getCanonicalName() + "('" + path + "','" + key + "')");
                pigContext.registerFunction(namespace + key, funcspec);
                LOG.info((Object)("Register scripting UDF: " + namespace + key));
            }
        }
        catch (ParserException pe) {
            throw new IOException("Error parsing schema for script function from the decorator", pe);
        }
        pigContext.addScriptFile(path);
        Interpreter.setMain(true);
    }

    public static PyFunction getFunction(String path, String functionName) throws IOException {
        Interpreter.setMain(false);
        Interpreter.init(path, null);
        return (PyFunction)Interpreter.interpreter.get(functionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, List<PigStats>> main(PigContext pigContext, String scriptFile) throws IOException {
        File f;
        if (System.getProperty("python.cachedir.skip") == null) {
            System.setProperty("python.cachedir.skip", "false");
        }
        PigServer pigServer = new PigServer(pigContext, false);
        String jythonJar = JythonScriptEngine.getJarPath(PythonInterpreter.class);
        if (jythonJar != null) {
            pigServer.registerJar(jythonJar);
        }
        if (!(f = new File(scriptFile)).canRead()) {
            throw new IOException("Can't read file: " + scriptFile);
        }
        FileInputStream fis1 = new FileInputStream(scriptFile);
        if (JythonScriptEngine.hasFunction(fis1)) {
            this.registerFunctions(scriptFile, null, pigContext);
        }
        Interpreter.setMain(true);
        FileInputStream fis = new FileInputStream(scriptFile);
        try {
            this.load(fis, scriptFile, pigServer.getPigContext());
        }
        finally {
            fis.close();
        }
        return this.getPigStatsMap();
    }

    public void load(InputStream script, String scriptFile, PigContext pigContext) throws IOException {
        Interpreter.execfile(script, scriptFile, pigContext);
    }

    @Override
    protected String getScriptingLang() {
        return "jython";
    }

    @Override
    protected Map<String, Object> getParamsFromVariables() throws IOException {
        PyFrame frame = Py.getFrame();
        PyList locals = ((PyStringMap)frame.getLocals()).items();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (PyTuple item : locals) {
            String key = (String)item.get(0);
            Object obj = item.get(1);
            if (obj == null) continue;
            String value = item.get(1).toString();
            vars.put(key, value);
        }
        return vars;
    }

    private static boolean hasFunction(InputStream is) throws IOException {
        boolean hasFunction = false;
        boolean hasMain = false;
        InputStreamReader in = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            if (p.matcher(line).matches()) {
                hasFunction = true;
            } else if (p1.matcher(line).matches()) {
                hasMain = true;
            }
            line = br.readLine();
        }
        if (hasFunction && !hasMain) {
            String msg = "Embedded script cannot mix UDFs with top level code. Please use if __name__ == '__main__': construct";
            throw new IOException(msg);
        }
        return hasFunction;
    }

    private static class DirDeleter
    extends Thread {
        private final File dir;

        public DirDeleter(File file) {
            this.dir = file;
        }

        @Override
        public void run() {
            try {
                DirDeleter.delete(this.dir);
            }
            catch (Exception e) {
                LOG.warn((Object)"on cleanup", (Throwable)e);
            }
        }

        private static boolean delete(File file) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    DirDeleter.delete(f);
                }
            }
            return file.delete();
        }
    }

    private static class Interpreter {
        static final PythonInterpreter interpreter;
        static final ArrayList<String> filesLoaded;
        static final String JVM_JAR;

        private Interpreter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void init(String path, PigContext pigContext) throws IOException {
            if (!filesLoaded.contains(path)) {
                interpreter.exec("def outputSchema(schema_def):\n    def decorator(func):\n        func.outputSchema = schema_def\n        return func\n    return decorator\n\n");
                interpreter.exec("def outputSchemaFunction(schema_def):\n    def decorator(func):\n        func.outputSchemaFunction = schema_def\n        return func\n    return decorator\n");
                interpreter.exec("def schemaFunction(schema_def):\n     def decorator(func):\n         func.schemaFunction = schema_def\n         return func\n     return decorator\n\n");
                InputStream is = ScriptEngine.getScriptAsStream(path);
                if (is == null) {
                    throw new IllegalStateException("unable to create a stream for path: " + path);
                }
                try {
                    Interpreter.execfile(is, path, pigContext);
                }
                finally {
                    is.close();
                }
            }
        }

        static void execfile(InputStream script, String path, PigContext pigContext) throws ExecException {
            try {
                Map<String, String> after;
                Map<String, String> before;
                if (pigContext != null) {
                    String[] argv;
                    try {
                        argv = (String[])ObjectSerializer.deserialize(pigContext.getProperties().getProperty("pig.cmd.args.remainders"));
                    }
                    catch (IOException e) {
                        throw new ExecException("Cannot deserialize command line arguments", e);
                    }
                    PySystemState state = Py.getSystemState();
                    state.argv.clear();
                    if (argv != null) {
                        for (String str : argv) {
                            state.argv.append((PyObject)new PyString(str));
                        }
                    } else {
                        LOG.warn((Object)"pig.cmd.args.remainders is empty. This is not expected unless on testing.");
                    }
                }
                Map<String, String> map = before = pigContext != null ? Interpreter.getModuleState() : null;
                if (before != null) {
                    HashSet<String> includePyModules = new HashSet<String>();
                    for (String string : before.keySet()) {
                        if (!string.endsWith(".py") && !string.endsWith("$py.class")) continue;
                        includePyModules.add(string);
                    }
                    before.keySet().removeAll(includePyModules);
                }
                interpreter.execfile(script, path);
                Map<String, String> map2 = after = pigContext != null ? Interpreter.getModuleState() : null;
                if (after != null && pigContext != null) {
                    after.keySet().removeAll(before.keySet());
                    for (Map.Entry entry : after.entrySet()) {
                        String modulename = (String)entry.getKey();
                        String modulepath = (String)entry.getValue();
                        if (modulepath.equals(JVM_JAR)) continue;
                        if (modulepath.endsWith(".jar") || modulepath.endsWith(".zip")) {
                            pigContext.scriptJars.add(modulepath);
                            continue;
                        }
                        pigContext.addScriptFile(modulename, modulepath);
                    }
                }
            }
            catch (PyException e) {
                if (e.match(Py.SystemExit)) {
                    PyObject value = e.value;
                    if (PyException.isExceptionInstance((PyObject)e.value)) {
                        value = value.__findattr__("code");
                    }
                    if (new PyInteger(0).equals((Object)value)) {
                        LOG.info((Object)"Script invoked sys.exit(0)");
                        return;
                    }
                }
                String message = "Python Error. " + (Object)((Object)e);
                throw new ExecException(message, 1121, e);
            }
        }

        static String get(String name) {
            return interpreter.get(name).toString();
        }

        static void setMain(boolean isMain) {
            if (isMain) {
                interpreter.set("__name__", (Object)"__main__");
            } else {
                interpreter.set("__name__", (Object)"__lib__");
            }
        }

        private static Map<String, String> getModuleState() {
            HashMap<String, String> files = new HashMap<String, String>();
            PyStringMap modules = (PyStringMap)Py.getSystemState().modules;
            for (PyObject kvp : modules.iteritems().asIterable()) {
                PyTuple tuple = (PyTuple)kvp;
                String name = tuple.get(0).toString();
                Object value = tuple.get(1);
                try {
                    PyObject dict;
                    String fileEntry = null;
                    PyObject loader = null;
                    if (value instanceof PyJavaPackage) {
                        fileEntry = ((PyJavaPackage)value).__file__;
                    } else if (value instanceof PyObject && (dict = ((PyObject)value).getDict()) != null) {
                        fileEntry = dict.__finditem__("__file__");
                        loader = dict.__finditem__("__loader__");
                    }
                    if (fileEntry == null) continue;
                    File file = JythonScriptEngine.resolvePyModulePath(fileEntry.toString(), loader);
                    if (file.exists()) {
                        String apath = file.getAbsolutePath();
                        if (apath.endsWith(".jar") || apath.endsWith(".zip")) {
                            files.put(apath, apath);
                            continue;
                        }
                        int pos = apath.lastIndexOf(File.separatorChar + name.replace('.', File.separatorChar));
                        if (pos > 0) {
                            files.put(apath.substring(pos), apath);
                            continue;
                        }
                        files.put(apath, apath);
                        continue;
                    }
                    LOG.warn((Object)("module file does not exist: " + name + ", " + file));
                }
                catch (Exception e) {
                    LOG.warn((Object)("exception while retrieving module state: " + value), (Throwable)e);
                }
            }
            return files;
        }

        static {
            filesLoaded = new ArrayList();
            String rpath = Object.class.getResource("Object.class").getPath();
            JVM_JAR = rpath.replaceAll("^file:(.*)!/java/lang/Object.class$", "$1");
            try {
                String skip = System.getProperty("python.cachedir.skip", "false");
                if (skip.equalsIgnoreCase("true")) {
                    LOG.warn((Object)"jython cachedir skipped, jython may not work");
                } else {
                    File tmp = null;
                    String cdir = System.getProperty("python.cachedir");
                    if (cdir != null && !(tmp = new File(cdir)).canWrite()) {
                        LOG.error((Object)"CACHEDIR: not writable");
                        throw new RuntimeException("python.cachedir not writable: " + cdir);
                    }
                    if (tmp == null) {
                        tmp = File.createTempFile("pig_jython_", "");
                        tmp.delete();
                        if (!tmp.mkdirs()) {
                            LOG.warn((Object)"unable to create a tmp dir for the cache, jython may not work");
                        } else {
                            LOG.info((Object)("created tmp python.cachedir=" + tmp));
                            System.setProperty("python.cachedir", tmp.getAbsolutePath());
                        }
                        Runtime.getRuntime().addShutdownHook(new DirDeleter(tmp));
                    }
                }
                Py.getSystemState().path.append((PyObject)new PyString(System.getProperty("user.dir")));
                String jyhome = System.getenv("JYTHON_HOME");
                if (jyhome != null) {
                    Py.getSystemState().path.append((PyObject)new PyString(jyhome + File.separator + "Lib"));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"issue with jython cache dir", (Throwable)e);
            }
            interpreter = new PythonInterpreter();
        }
    }
}

