/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.data.BinInterSedes;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.io.NullableBytesWritable;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigBytesRawComparator
extends WritableComparator
implements Configurable {
    private final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean[] mAsc;
    private WritableComparator mWrappedComp = new BinInterSedes.BinInterSedesTupleRawComparator();

    public PigBytesRawComparator() {
        super(NullableBytesWritable.class);
    }

    public void setConf(Configuration conf) {
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
        ((BinInterSedes.BinInterSedesTupleRawComparator)this.mWrappedComp).setConf(conf);
    }

    public Configuration getConf() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int rc = 0;
        if (b1[s1] == 0 && b2[s2] == 0) {
            int length2;
            int offset2;
            int length1;
            int offset1;
            boolean dataByteArraysCompare = true;
            switch (b1[s1 + 2]) {
                case 13: {
                    offset1 = s1 + 4;
                    length1 = l1 - 4;
                    break;
                }
                case 12: {
                    offset1 = s1 + 5;
                    length1 = l1 - 5;
                    break;
                }
                case 11: {
                    offset1 = s1 + 7;
                    length1 = l1 - 7;
                    break;
                }
                default: {
                    length1 = 0;
                    offset1 = 0;
                    dataByteArraysCompare = false;
                }
            }
            switch (b2[s2 + 2]) {
                case 13: {
                    offset2 = s2 + 4;
                    length2 = l2 - 4;
                    break;
                }
                case 12: {
                    offset2 = s2 + 5;
                    length2 = l2 - 5;
                    break;
                }
                case 11: {
                    offset2 = s2 + 7;
                    length2 = l2 - 7;
                    break;
                }
                default: {
                    length2 = 0;
                    offset2 = 0;
                    dataByteArraysCompare = false;
                }
            }
            if (!dataByteArraysCompare) return this.mWrappedComp.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2);
            rc = WritableComparator.compareBytes((byte[])b1, (int)offset1, (int)length1, (byte[])b2, (int)offset2, (int)length2);
        } else {
            rc = b1[s1] != 0 && b2[s2] != 0 ? 0 : (b1[s1] != 0 ? -1 : 1);
        }
        if (this.mAsc[0]) return rc;
        rc *= -1;
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableBytesWritable nbw1 = (NullableBytesWritable)o1;
        NullableBytesWritable nbw2 = (NullableBytesWritable)o2;
        int rc = 0;
        rc = !nbw1.isNull() && !nbw2.isNull() ? DataType.compare(nbw1.getValueAsPigType(), nbw2.getValueAsPigType()) : (nbw1.isNull() && nbw2.isNull() ? 0 : (nbw1.isNull() ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }
}

