/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleRawComparator;

public class PigSecondaryKeyComparator
extends WritableComparator
implements Configurable {
    private final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TupleRawComparator mComparator = null;

    public void setConf(Configuration conf) {
        try {
            Class<? extends TupleRawComparator> mComparatorClass = TupleFactory.getInstance().tupleRawComparatorClass();
            this.mComparator = mComparatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.mComparator.setConf(conf);
    }

    protected PigSecondaryKeyComparator() {
        super(TupleFactory.getInstance().tupleClass());
    }

    public Configuration getConf() {
        return null;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        byte mIndex1 = b1[s1 + l1 - 1];
        byte mIndex2 = b2[s2 + l2 - 1];
        if ((mIndex1 & 0xFFFFFF80) != 0) {
            if ((mIndex1 & 0x7F) < (mIndex2 & 0x7F)) {
                return -1;
            }
            if ((mIndex1 & 0x7F) > (mIndex2 & 0x7F)) {
                return 1;
            }
        }
        int rc = 0;
        if (b1[s1] == 0 && b2[s2] == 0) {
            rc = this.mComparator.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2);
            if (rc == 0 && this.mComparator.hasComparedTupleNull()) {
                rc = (mIndex1 & 0x7F) - (mIndex2 & 0x7F);
            }
        } else {
            rc = b1[s1] != 0 && b2[s2] != 0 ? (mIndex1 & 0x7F) - (mIndex2 & 0x7F) : (b1[s1] != 0 ? -1 : 1);
        }
        return rc;
    }
}

