/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BinInterSedes;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleRawComparator;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigTupleDefaultRawComparator
extends WritableComparator
implements TupleRawComparator {
    private final Log mLog = LogFactory.getLog(this.getClass());
    private boolean[] mAsc;
    private boolean mWholeTuple;
    private boolean mHasNullField;
    private static final BinInterSedes bis = new BinInterSedes();

    public PigTupleDefaultRawComparator() {
        super(TupleFactory.getInstance().tupleClass());
    }

    public void setConf(Configuration conf) {
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
        this.mWholeTuple = this.mAsc.length == 1;
    }

    public Configuration getConf() {
        return null;
    }

    @Override
    public boolean hasComparedTupleNull() {
        return this.mHasNullField;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        Tuple t2;
        Tuple t1;
        int rc = 0;
        this.mHasNullField = false;
        try {
            t1 = bis.readTuple(new DataInputStream(new ByteArrayInputStream(b1, s1, l1)));
            t2 = bis.readTuple(new DataInputStream(new ByteArrayInputStream(b2, s2, l2)));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to instantiate tuples for comparison: " + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage(), ioe);
        }
        rc = this.compareTuple(t1, t2);
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableTuple nt1 = (NullableTuple)o1;
        NullableTuple nt2 = (NullableTuple)o2;
        int rc = 0;
        if (!nt1.isNull() && !nt2.isNull()) {
            rc = this.compareTuple((Tuple)nt1.getValueAsPigType(), (Tuple)nt2.getValueAsPigType());
        } else {
            rc = nt1.isNull() && nt2.isNull() ? 0 : (nt1.isNull() ? -1 : 1);
            if (this.mWholeTuple && !this.mAsc[0]) {
                rc *= -1;
            }
        }
        return rc;
    }

    private int compareTuple(Tuple t1, Tuple t2) {
        int sz1 = t1.size();
        int sz2 = t2.size();
        if (sz2 < sz1) {
            return 1;
        }
        if (sz2 > sz1) {
            return -1;
        }
        for (int i = 0; i < sz1; ++i) {
            try {
                int c;
                Object o1 = t1.get(i);
                Object o2 = t2.get(i);
                if (o1 == null || o2 == null) {
                    this.mHasNullField = true;
                }
                if ((c = DataType.compare(o1, o2)) == 0) continue;
                if (!this.mWholeTuple && !this.mAsc[i]) {
                    c *= -1;
                } else if (this.mWholeTuple && !this.mAsc[0]) {
                    c *= -1;
                }
                return c;
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to compare tuples", e);
            }
        }
        return 0;
    }
}

