/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BigDecimalAvg
extends EvalFunc<BigDecimal>
implements Algebraic,
Accumulator<BigDecimal> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private BigDecimal intermediateSum = null;
    private BigDecimal intermediateCount = null;

    @Override
    public BigDecimal exec(Tuple input) throws IOException {
        BigDecimal sum = BigDecimalAvg.sum(input);
        if (sum == null) {
            return null;
        }
        BigDecimal count = BigDecimalAvg.count(input);
        BigDecimal avg = null;
        if (count.compareTo(BigDecimal.ZERO) > 0) {
            avg = BigDecimalAvg.div(sum, count);
        }
        return avg;
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Tuple combine(DataBag values) throws ExecException {
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal count = BigDecimal.ZERO;
        Tuple output = mTupleFactory.newTuple(2);
        boolean sawNonNull = false;
        for (Tuple t : values) {
            BigDecimal d = (BigDecimal)t.get(0);
            if (d == null) {
                d = BigDecimal.ZERO;
            } else {
                sawNonNull = true;
            }
            sum = sum.add(d);
            count = count.add((BigDecimal)t.get(1));
        }
        if (sawNonNull) {
            output.set(0, sum);
        } else {
            output.set(0, null);
        }
        output.set(1, count);
        return output;
    }

    protected static BigDecimal count(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        Iterator<Tuple> it = values.iterator();
        BigDecimal cnt = BigDecimal.ZERO;
        while (it.hasNext()) {
            Tuple t = it.next();
            if (t == null || t.size() <= 0 || t.get(0) == null) continue;
            cnt = cnt.add(BigDecimal.ONE);
        }
        return cnt;
    }

    protected static BigDecimal sum(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                BigDecimal d = (BigDecimal)t.get(0);
                if (d == null) continue;
                sawNonNull = true;
                sum = sum.add(d);
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of BigDecimals.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return sum;
        }
        return null;
    }

    protected static BigDecimal div(BigDecimal dividend, BigDecimal divisor) {
        return dividend.divide(divisor, MathContext.DECIMAL128);
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 70));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            BigDecimal count;
            BigDecimal sum = BigDecimalAvg.sum(b);
            if (sum == null) {
                return;
            }
            if (this.intermediateSum == null || this.intermediateCount == null) {
                this.intermediateSum = BigDecimal.ZERO;
                this.intermediateCount = BigDecimal.ZERO;
            }
            if ((count = BigDecimalAvg.count(b)).compareTo(BigDecimal.ZERO) > 0) {
                this.intermediateCount = this.intermediateCount.add(count);
                this.intermediateSum = this.intermediateSum.add(sum);
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing average in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateSum = null;
        this.intermediateCount = null;
    }

    @Override
    public BigDecimal getValue() {
        BigDecimal avg = null;
        if (this.intermediateCount != null && this.intermediateCount.compareTo(BigDecimal.ZERO) > 0) {
            avg = BigDecimalAvg.div(this.intermediateSum, this.intermediateCount);
        }
        return avg;
    }

    public static class Final
    extends EvalFunc<BigDecimal> {
        @Override
        public BigDecimal exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                Tuple combined = BigDecimalAvg.combine(b);
                BigDecimal sum = (BigDecimal)combined.get(0);
                if (sum == null) {
                    return null;
                }
                BigDecimal count = (BigDecimal)combined.get(1);
                BigDecimal avg = null;
                if (count.compareTo(BigDecimal.ZERO) > 0) {
                    avg = BigDecimalAvg.div(sum, count);
                }
                return avg;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                return BigDecimalAvg.combine(b);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                Tuple t = mTupleFactory.newTuple(2);
                DataBag bg = (DataBag)input.get(0);
                BigDecimal d = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    d = (BigDecimal)tp.get(0);
                }
                t.set(0, d);
                if (d != null) {
                    t.set(1, BigDecimal.ONE);
                } else {
                    t.set(1, BigDecimal.ZERO);
                }
                return t;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

