/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.pig.FuncSpec;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.parser.LogicalPlanBuilder;
import org.apache.pig.parser.PigParserNodeAdaptor;
import org.apache.pig.parser.QueryParser;
import org.apache.pig.parser.SourceLocation;
import org.apache.pig.tools.pigstats.ScriptState;

public class QueryParserUtils {
    public static String removeQuotes(String str) {
        if (str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void attachStorePlan(String scope, LogicalPlan lp, String fileName, String func, Operator input, String alias, PigContext pigContext) throws FrontendException {
        func = func == null ? pigContext.getProperties().getProperty("pig.default.store.func", PigStorage.class.getName()) : func;
        FuncSpec funcSpec = new FuncSpec(func);
        StoreFuncInterface stoFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(funcSpec);
        fileName = QueryParserUtils.removeQuotes(fileName);
        FileSpec fileSpec = new FileSpec(fileName, funcSpec);
        String sig = alias + "_" + LogicalPlanBuilder.newOperatorKey(scope);
        stoFunc.setStoreFuncUDFContextSignature(sig);
        LOStore store = new LOStore(lp, fileSpec, stoFunc, sig);
        store.setAlias(alias);
        try {
            stoFunc.relToAbsPathForStoreLocation(fileName, QueryParserUtils.getCurrentDir(pigContext));
        }
        catch (IOException ioe) {
            FrontendException e = new FrontendException(ioe.getMessage(), ioe);
            throw e;
        }
        lp.add(store);
        lp.connect(input, store);
    }

    static Path getCurrentDir(PigContext pigContext) throws IOException {
        DataStorage dfs = pigContext.getDfs();
        ContainerDescriptor desc = dfs.getActiveContainer();
        ElementDescriptor el = dfs.asElement(desc);
        return new Path(el.toString());
    }

    static void setHdfsServers(String absolutePath, PigContext pigContext) throws URISyntaxException {
        String defaultFS = (String)pigContext.getProperties().get("fs.default.name");
        if (defaultFS == null) {
            defaultFS = (String)pigContext.getProperties().get("fs.defaultFS");
        }
        URI defaultFSURI = new URI(defaultFS);
        Configuration conf = new Configuration(true);
        ConfigurationUtil.mergeConf(conf, ConfigurationUtil.toConfiguration(pigContext.getProperties()));
        Set<String> remoteHosts = QueryParserUtils.getRemoteHosts(absolutePath, defaultFSURI, conf);
        String hdfsServersString = (String)pigContext.getProperties().get("mapreduce.job.hdfs-servers");
        if (hdfsServersString == null) {
            hdfsServersString = "";
        }
        String[] hdfsServers = hdfsServersString.split(",");
        for (String remoteHost : remoteHosts) {
            boolean existing = false;
            for (String hdfsServer : hdfsServers) {
                if (!hdfsServer.equals(remoteHost)) continue;
                existing = true;
            }
            if (existing) continue;
            if (!hdfsServersString.isEmpty()) {
                hdfsServersString = hdfsServersString + ",";
            }
            hdfsServersString = hdfsServersString + remoteHost;
        }
        if (!hdfsServersString.isEmpty()) {
            pigContext.getProperties().setProperty("mapreduce.job.hdfs-servers", hdfsServersString);
        }
    }

    static Set<String> getRemoteHosts(String absolutePath, URI defaultFSURI, Configuration conf) {
        String[] fnames;
        String defaultHost = defaultFSURI.getHost() == null ? "" : defaultFSURI.getHost().toLowerCase();
        String defaultScheme = defaultFSURI.getScheme() == null ? "" : defaultFSURI.getScheme().toLowerCase();
        HashSet<String> result = new HashSet<String>();
        for (String fname : fnames = absolutePath.split(",")) {
            String authority;
            Path path = new Path(fname.trim());
            URI uri = path.toUri();
            if (!uri.isAbsolute()) continue;
            String thisHost = uri.getHost() == null ? "" : uri.getHost().toLowerCase();
            String scheme = uri.getScheme().toLowerCase();
            if (scheme.equals(defaultScheme) && (thisHost.equals(defaultHost) || thisHost.isEmpty())) continue;
            String string = authority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
            if (scheme.equals("har")) {
                String[] parts = authority.split("-", 2);
                scheme = parts[0];
                authority = parts.length < 2 ? "" : parts[1];
                if (scheme.isEmpty() || scheme.equals(defaultScheme) && authority.equals(defaultFSURI.getAuthority())) {
                    continue;
                }
            } else if (!HadoopShims.hasFileSystemImpl(path, conf)) continue;
            result.add(scheme + "://" + authority);
        }
        return result;
    }

    static String constructFileNameSignature(String fileName, FuncSpec funcSpec) {
        return fileName + "_" + funcSpec.toString();
    }

    static String generateErrorHeader(RecognitionException ex, String filename) {
        return new SourceLocation(filename, ex.line, ex.charPositionInLine).toString();
    }

    static void replaceNodeWithNodeList(Tree oldNode, CommonTree newTree, String fileName) {
        int idx = oldNode.getChildIndex();
        CommonTree parent = (CommonTree)oldNode.getParent();
        int count = parent.getChildCount();
        ArrayList childList = new ArrayList(parent.getChildren());
        List macroList = newTree.getChildren();
        while (parent.getChildCount() > 0) {
            parent.deleteChild(0);
        }
        for (int i = 0; i < count; ++i) {
            if (i == idx) {
                if (macroList == null) continue;
                parent.addChildren(macroList);
                continue;
            }
            parent.addChild((Tree)childList.get(i));
        }
    }

    static File getFileFromImportSearchPath(String scriptPath) {
        String srchPath;
        File f = new File(scriptPath);
        if (f.exists() || f.isAbsolute() || scriptPath.startsWith("./") || scriptPath.startsWith("../")) {
            return f;
        }
        ScriptState state = ScriptState.get();
        if (state != null && state.getPigContext() != null && (srchPath = state.getPigContext().getProperties().getProperty("pig.import.search.path")) != null) {
            String[] paths;
            for (String path : paths = srchPath.split(",")) {
                File f1 = new File(path + File.separator + scriptPath);
                if (!f1.exists()) continue;
                return f1;
            }
        }
        return null;
    }

    static QueryParser createParser(CommonTokenStream tokens) {
        return QueryParserUtils.createParser(tokens, 0);
    }

    static QueryParser createParser(CommonTokenStream tokens, int lineOffset) {
        QueryParser parser = new QueryParser((TokenStream)tokens);
        PigParserNodeAdaptor adaptor = new PigParserNodeAdaptor(tokens.getSourceName(), lineOffset);
        parser.setTreeAdaptor((TreeAdaptor)adaptor);
        return parser;
    }
}

