/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMultiQueryPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiQueryOptimizer
extends MROpPlanVisitor {
    private Log log = LogFactory.getLog(this.getClass());
    private NodeIdGenerator nig = NodeIdGenerator.getGenerator();
    private String scope;
    private boolean inIllustrator = false;

    MultiQueryOptimizer(MROperPlan plan, boolean inIllustrator) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new ReverseDependencyOrderWalker<MapReduceOper, MROperPlan>(plan));
        List roots = plan.getRoots();
        this.scope = ((MapReduceOper)roots.get(0)).getOperatorKey().getScope();
        this.inIllustrator = inIllustrator;
        this.log.info((Object)("MR plan size before optimization: " + plan.size()));
    }

    @Override
    public void visit() throws VisitorException {
        super.visit();
        this.log.info((Object)("MR plan size after optimization: " + ((MROperPlan)this.mPlan).size()));
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        if (!mr.isSplitter()) {
            return;
        }
        ArrayList<MapReduceOper> mappers = new ArrayList<MapReduceOper>();
        ArrayList<MapReduceOper> multiLoadMROpers = new ArrayList<MapReduceOper>();
        ArrayList<MapReduceOper> mapReducers = new ArrayList<MapReduceOper>();
        List<MapReduceOper> successors = ((MROperPlan)this.getPlan()).getSuccessors(mr);
        for (MapReduceOper successor : successors) {
            if (successor.getUseSecondaryKey()) {
                this.log.debug((Object)("Splittee " + successor.getOperatorKey().getId() + " uses secondary key, do not merge it"));
                continue;
            }
            if (successor.getCustomPartitioner() != null) {
                this.log.debug((Object)("Splittee " + successor.getOperatorKey().getId() + " uses customPartitioner, do not merge it"));
                continue;
            }
            if (this.isMapOnly(successor)) {
                if (this.isSingleLoadMapperPlan(successor.mapPlan) && this.isSinglePredecessor(successor)) {
                    mappers.add(successor);
                    continue;
                }
                multiLoadMROpers.add(successor);
                continue;
            }
            if (this.isSingleLoadMapperPlan(successor.mapPlan) && this.isSinglePredecessor(successor)) {
                mapReducers.add(successor);
                continue;
            }
            multiLoadMROpers.add(successor);
        }
        int numSplittees = successors.size();
        if (mappers.size() == 1 && numSplittees == 1) {
            this.mergeOnlyMapperSplittee((MapReduceOper)mappers.get(0), mr);
            this.log.info((Object)"Merged the only map-only splittee.");
            return;
        }
        if (this.isMapOnly(mr) && mapReducers.size() == 1 && numSplittees == 1) {
            this.mergeOnlyMapReduceSplittee((MapReduceOper)mapReducers.get(0), mr);
            this.log.info((Object)"Merged the only map-reduce splittee.");
            return;
        }
        int numMerges = 0;
        PhysicalPlan splitterPl = this.isMapOnly(mr) ? mr.mapPlan : mr.reducePlan;
        POStore storeOp = (POStore)splitterPl.getLeaves().get(0);
        POSplit splitOp = null;
        if (mappers.size() > 0) {
            splitOp = this.getSplit();
            int n = this.mergeAllMapOnlySplittees(mappers, mr, splitOp);
            this.log.info((Object)("Merged " + n + " map-only splittees."));
            numMerges += n;
        }
        if (mapReducers.size() > 0) {
            boolean isMapOnly = this.isMapOnly(mr);
            int merged = 0;
            if (isMapOnly) {
                PhysicalOperator leaf = (PhysicalOperator)splitterPl.getLeaves().get(0);
                splitOp = leaf instanceof POStore ? this.getSplit() : (POSplit)leaf;
                merged = this.mergeMapReduceSplittees(mapReducers, mr, splitOp);
            } else {
                merged = this.mergeMapReduceSplittees(mapReducers, mr);
            }
            this.log.info((Object)("Merged " + merged + " map-reduce splittees."));
            numMerges += merged;
        }
        if (splitOp != null && numMerges < numSplittees) {
            PhysicalPlan storePlan = new PhysicalPlan();
            try {
                storePlan.addAsLeaf(storeOp);
                splitOp.addPlan(storePlan);
            }
            catch (PlanException e) {
                int errCode = 2129;
                String msg = "Internal Error. Unable to add store to the split plan for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
        }
        if (numMerges == 0 && this.isDiamondMROper(mr)) {
            int merged = this.mergeDiamondMROper(mr, ((MROperPlan)this.getPlan()).getSuccessors(mr));
            this.log.info((Object)("Merged " + merged + " diamond splitter."));
            numMerges += merged;
        }
        this.log.info((Object)("Merged " + numMerges + " out of total " + (numSplittees + 1) + " MR operators."));
    }

    private boolean isDiamondMROper(MapReduceOper mr) {
        PhysicalPlan pl;
        boolean rtn = false;
        if (this.isMapOnly(mr) && ((pl = mr.mapPlan).size() == 2 || pl.size() == 3)) {
            PhysicalOperator root = (PhysicalOperator)pl.getRoots().get(0);
            PhysicalOperator leaf = (PhysicalOperator)pl.getLeaves().get(0);
            if (root instanceof POLoad && leaf instanceof POStore) {
                if (pl.size() == 3) {
                    PhysicalOperator mid = pl.getSuccessors(root).get(0);
                    if (mid instanceof POForEach) {
                        rtn = true;
                    }
                } else {
                    rtn = true;
                }
            }
        }
        return rtn;
    }

    private int mergeDiamondMROper(MapReduceOper mr, List<MapReduceOper> succs) throws VisitorException {
        for (MapReduceOper succ : succs) {
            List<MapReduceOper> preds = ((MROperPlan)this.getPlan()).getPredecessors(succ);
            if (preds.size() == 1) continue;
            return 0;
        }
        PhysicalPlan pl = mr.mapPlan;
        PhysicalOperator leaf = (PhysicalOperator)mr.mapPlan.getLeaves().get(0);
        pl.remove(leaf);
        POStore store = (POStore)leaf;
        String ofile = store.getSFile().getFileName();
        for (MapReduceOper succ : succs) {
            List roots = succ.mapPlan.getRoots();
            ArrayList rootsCopy = new ArrayList(roots);
            for (PhysicalOperator op : rootsCopy) {
                POLoad load = (POLoad)op;
                String ifile = load.getLFile().getFileName();
                if (ofile.compareTo(ifile) != 0) continue;
                PhysicalOperator opSucc = succ.mapPlan.getSuccessors(op).get(0);
                PhysicalPlan clone = null;
                try {
                    if (this.inIllustrator) {
                        pl.setOpMap(succ.phyToMRMap);
                    }
                    clone = pl.clone();
                    if (this.inIllustrator) {
                        pl.resetOpMap();
                    }
                }
                catch (CloneNotSupportedException e) {
                    int errCode = 2127;
                    String msg = "Internal Error: Cloning of plan failed for optimization.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
                succ.mapPlan.remove(op);
                if (this.inIllustrator) {
                    for (PhysicalOperator po : pl) {
                        if (!(po instanceof POLoad)) continue;
                        succ.phyToMRMap.removeKey(po);
                    }
                }
                while (!clone.isEmpty()) {
                    PhysicalOperator oper = (PhysicalOperator)clone.getLeaves().get(0);
                    clone.remove(oper);
                    succ.mapPlan.add(oper);
                    try {
                        succ.mapPlan.connect(oper, opSucc);
                        opSucc = oper;
                    }
                    catch (PlanException e) {
                        int errCode = 2131;
                        String msg = "Internal Error. Unable to connect split plan for optimization.";
                        throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                    }
                }
            }
            if (mr.UDFs.isEmpty()) continue;
            succ.UDFs.addAll(mr.UDFs);
        }
        List<MapReduceOper> mrPreds = ((MROperPlan)this.getPlan()).getPredecessors(mr);
        if (mrPreds != null) {
            for (MapReduceOper pred : mrPreds) {
                for (MapReduceOper succ : succs) {
                    try {
                        ((MROperPlan)this.getPlan()).connect(pred, succ);
                    }
                    catch (PlanException e) {
                        int errCode = 2131;
                        String msg = "Internal Error. Unable to connect split plan for optimization.";
                        throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                    }
                }
            }
        }
        ((MROperPlan)this.getPlan()).remove(mr);
        return 1;
    }

    private void mergeOneMapPart(MapReduceOper mapper, MapReduceOper splitter) throws VisitorException {
        PhysicalPlan splitterPl = this.isMapOnly(splitter) ? splitter.mapPlan : splitter.reducePlan;
        POStore storeOp = (POStore)splitterPl.getLeaves().get(0);
        List<POStore> storePreds = splitterPl.getPredecessors(storeOp);
        PhysicalPlan pl = mapper.mapPlan;
        PhysicalOperator load = (PhysicalOperator)pl.getRoots().get(0);
        pl.remove(load);
        ArrayList<POStore> predsCopy = new ArrayList<POStore>(storePreds);
        splitterPl.remove(storeOp);
        try {
            splitterPl.merge(pl);
        }
        catch (PlanException e) {
            int errCode = 2130;
            String string = "Internal Error. Unable to merge split plans for optimization.";
            throw new OptimizerException(string, errCode, 4, (Throwable)e);
        }
        List roots = pl.getRoots();
        for (PhysicalOperator physicalOperator : predsCopy) {
            for (PhysicalOperator root : roots) {
                try {
                    splitterPl.connect(physicalOperator, root);
                }
                catch (PlanException e) {
                    int errCode = 2131;
                    String msg = "Internal Error. Unable to connect split plan for optimization.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
            }
        }
    }

    private void mergeOnlyMapperSplittee(MapReduceOper mapper, MapReduceOper splitter) throws VisitorException {
        this.mergeOneMapPart(mapper, splitter);
        this.removeAndReconnect(mapper, splitter);
    }

    private void mergeOnlyMapReduceSplittee(MapReduceOper mapReducer, MapReduceOper splitter) throws VisitorException {
        this.mergeOneMapPart(mapReducer, splitter);
        splitter.setMapDone(true);
        splitter.reducePlan = mapReducer.reducePlan;
        splitter.setReduceDone(true);
        this.removeAndReconnect(mapReducer, splitter);
    }

    private int mergeAllMapOnlySplittees(List<MapReduceOper> mappers, MapReduceOper splitter, POSplit splitOp) throws VisitorException {
        PhysicalPlan splitterPl = this.isMapOnly(splitter) ? splitter.mapPlan : splitter.reducePlan;
        PhysicalOperator storeOp = (PhysicalOperator)splitterPl.getLeaves().get(0);
        List<PhysicalOperator> storePreds = splitterPl.getPredecessors(storeOp);
        for (MapReduceOper mapper : mappers) {
            PhysicalPlan pl = mapper.mapPlan;
            PhysicalOperator load = (PhysicalOperator)pl.getRoots().get(0);
            pl.remove(load);
            splitOp.addPlan(pl);
        }
        splitOp.setInputs(storePreds);
        try {
            splitterPl.replace(storeOp, splitOp);
        }
        catch (PlanException e) {
            int errCode = 2132;
            String msg = "Internal Error. Unable to replace store with split operator for optimization.";
            throw new OptimizerException(msg, errCode, 4, (Throwable)e);
        }
        for (MapReduceOper mapper : mappers) {
            this.removeAndReconnect(mapper, splitter);
        }
        return mappers.size();
    }

    private boolean isSplitteeMergeable(MapReduceOper splittee) {
        if (splittee.isGlobalSort() || splittee.isLimitAfterSort()) {
            this.log.info((Object)"Cannot merge this splittee: it is global sort or limit after sort");
            return false;
        }
        PhysicalOperator leaf = (PhysicalOperator)splittee.mapPlan.getLeaves().get(0);
        if (!(leaf instanceof POLocalRearrange) && !(leaf instanceof POSplit)) {
            this.log.info((Object)("Cannot merge this splittee: its map plan doesn't end with LR or Split operator: " + leaf.getClass().getName()));
            return false;
        }
        if (splittee.needsDistinctCombiner()) {
            this.log.info((Object)"Cannot merge this splittee: it has distinct combiner.");
            return false;
        }
        return true;
    }

    private List<MapReduceOper> getMergeList(MapReduceOper splitter, List<MapReduceOper> mapReducers) {
        ArrayList<MapReduceOper> mergeNoCmbList = new ArrayList<MapReduceOper>();
        ArrayList<MapReduceOper> mergeCmbList = new ArrayList<MapReduceOper>();
        ArrayList<MapReduceOper> mergeDistList = new ArrayList<MapReduceOper>();
        for (MapReduceOper mrOp : mapReducers) {
            if (this.isSplitteeMergeable(mrOp)) {
                if (mrOp.combinePlan.isEmpty()) {
                    mergeNoCmbList.add(mrOp);
                    continue;
                }
                mergeCmbList.add(mrOp);
                continue;
            }
            if (!splitter.reducePlan.isEmpty() && !splitter.needsDistinctCombiner() || !mrOp.needsDistinctCombiner()) continue;
            mergeDistList.add(mrOp);
        }
        int max = Math.max(mergeNoCmbList.size(), mergeCmbList.size());
        if ((max = Math.max(max, mergeDistList.size())) == mergeDistList.size()) {
            return mergeDistList;
        }
        if (max == mergeNoCmbList.size()) {
            return mergeNoCmbList;
        }
        return mergeCmbList;
    }

    private int mergeMapReduceSplittees(List<MapReduceOper> mapReducers, MapReduceOper splitter, POSplit splitOp) throws VisitorException {
        List<MapReduceOper> mergeList = this.getMergeList(splitter, mapReducers);
        if (mergeList.size() <= 1) {
            MapReduceOper mapReducer = mapReducers.get(0);
            for (MapReduceOper mro : mapReducers) {
                if (mro.combinePlan.isEmpty()) continue;
                mapReducer = mro;
                break;
            }
            mergeList.clear();
            mergeList.add(mapReducer);
        }
        if (mergeList.size() == 1) {
            this.mergeSingleMapReduceSplittee(mergeList.get(0), splitter, splitOp);
        } else {
            this.mergeAllMapReduceSplittees(mergeList, splitter, splitOp);
        }
        return mergeList.size();
    }

    private int mergeMapReduceSplittees(List<MapReduceOper> mapReducers, MapReduceOper splitter) throws VisitorException {
        List<MapReduceOper> mergeList = this.getMergeList(splitter, mapReducers);
        if (mergeList.size() <= 1) {
            return 0;
        }
        MapReduceOper mrOper = this.getMROper();
        MapReduceOper splittee = mergeList.get(0);
        PhysicalPlan pl = splittee.mapPlan;
        POLoad load = (POLoad)pl.getRoots().get(0);
        mrOper.mapPlan.add(load);
        try {
            mrOper.mapPlan.addAsLeaf(this.getStore());
        }
        catch (PlanException e) {
            int errCode = 2137;
            String msg = "Internal Error. Unable to add store to the plan as leaf for optimization.";
            throw new OptimizerException(msg, errCode, 4, (Throwable)e);
        }
        try {
            ((MROperPlan)this.getPlan()).add(mrOper);
            ((MROperPlan)this.getPlan()).connect(splitter, mrOper);
        }
        catch (PlanException e) {
            int errCode = 2133;
            String msg = "Internal Error. Unable to connect splitter with successors for optimization.";
            throw new OptimizerException(msg, errCode, 4, (Throwable)e);
        }
        this.mergeAllMapReduceSplittees(mergeList, mrOper, this.getSplit());
        return mergeList.size() - 1;
    }

    private boolean hasSameMapKeyType(List<MapReduceOper> splittees) {
        boolean sameKeyType = true;
        for (MapReduceOper outer : splittees) {
            for (MapReduceOper inner : splittees) {
                if (inner.mapKeyType == outer.mapKeyType) continue;
                sameKeyType = false;
                break;
            }
            if (sameKeyType) continue;
            break;
        }
        return sameKeyType;
    }

    private int setIndexOnLRInSplit(int initial, POSplit splitOp, boolean sameKeyType) throws VisitorException {
        int index = initial;
        List<PhysicalPlan> pls = splitOp.getPlans();
        for (PhysicalPlan pl : pls) {
            PhysicalOperator leaf = (PhysicalOperator)pl.getLeaves().get(0);
            if (leaf instanceof POLocalRearrange) {
                POLocalRearrange lr = (POLocalRearrange)leaf;
                try {
                    lr.setMultiQueryIndex(index++);
                }
                catch (ExecException e) {
                    int errCode = 2136;
                    String msg = "Internal Error. Unable to set multi-query index for optimization.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
                if (sameKeyType) continue;
                lr.setKeyType((byte)110);
                continue;
            }
            if (!(leaf instanceof POSplit)) continue;
            POSplit spl = (POSplit)leaf;
            index = this.setIndexOnLRInSplit(index, spl, sameKeyType);
        }
        return index;
    }

    private int mergeOneMapPlanWithIndex(PhysicalPlan pl, POSplit splitOp, int index, boolean sameKeyType) throws VisitorException {
        PhysicalOperator load = (PhysicalOperator)pl.getRoots().get(0);
        pl.remove(load);
        int curIndex = index;
        PhysicalOperator leaf = (PhysicalOperator)pl.getLeaves().get(0);
        if (leaf instanceof POLocalRearrange) {
            POLocalRearrange lr = (POLocalRearrange)leaf;
            try {
                lr.setMultiQueryIndex(curIndex++);
            }
            catch (ExecException e) {
                int errCode = 2136;
                String msg = "Internal Error. Unable to set multi-query index for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
            if (!sameKeyType) {
                lr.setKeyType((byte)110);
            }
        } else if (leaf instanceof POSplit) {
            POSplit spl = (POSplit)leaf;
            curIndex = this.setIndexOnLRInSplit(index, spl, sameKeyType);
        }
        splitOp.addPlan(pl);
        return curIndex;
    }

    private void mergeOneReducePlanWithIndex(PhysicalPlan from, PhysicalPlan to, int initial, int current, byte mapKeyType) throws VisitorException {
        POPackage pk = (POPackage)from.getRoots().get(0);
        from.remove(pk);
        if (!(pk instanceof POMultiQueryPackage)) {
            this.addShiftedKeyInfoIndex(initial, pk);
        }
        int total = current - initial;
        POMultiQueryPackage pkg = (POMultiQueryPackage)to.getRoots().get(0);
        int pkCount = 0;
        if (pk instanceof POMultiQueryPackage) {
            List<POPackage> pkgs = ((POMultiQueryPackage)pk).getPackages();
            for (POPackage p : pkgs) {
                pkg.addPackage(p);
                ++pkCount;
            }
            pkg.addIsKeyWrappedList(((POMultiQueryPackage)pk).getIsKeyWrappedList());
            this.addShiftedKeyInfoIndex(initial, current, (POMultiQueryPackage)pk);
        } else {
            pkg.addPackage(pk, mapKeyType);
            pkCount = 1;
        }
        if (pkCount != total) {
            int errCode = 2146;
            String msg = "Internal Error. Inconsistency in key index found during optimization.";
            throw new OptimizerException(msg, errCode, 4);
        }
        PODemux demux = (PODemux)to.getLeaves().get(0);
        int plCount = 0;
        PhysicalOperator root = (PhysicalOperator)from.getRoots().get(0);
        if (root instanceof PODemux) {
            List<PhysicalPlan> pls = ((PODemux)root).getPlans();
            for (PhysicalPlan pl : pls) {
                demux.addPlan(pl);
                ++plCount;
            }
        } else {
            demux.addPlan(from);
            plCount = 1;
        }
        if (plCount != total) {
            int errCode = 2146;
            String msg = "Internal Error. Inconsistency in key index found during optimization.";
            throw new OptimizerException(msg, errCode, 4);
        }
        if (pkg.isSameMapKeyType()) {
            pkg.setKeyType(pk.getKeyType());
        } else {
            pkg.setKeyType((byte)110);
        }
    }

    private void addShiftedKeyInfoIndex(int index, POPackage pkg) throws OptimizerException {
        Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo = pkg.getKeyInfo();
        byte newIndex = (byte)(index | 0xFFFFFF80);
        Set<Integer> existingIndices = keyInfo.keySet();
        if (existingIndices.size() != 1) {
            int errCode = 2146;
            String msg = "Internal Error. Inconsistency in key index found during optimization.";
            throw new OptimizerException(msg, errCode, 4);
        }
        int existingIndex = existingIndices.iterator().next();
        keyInfo.put(Integer.valueOf(newIndex), keyInfo.get(existingIndex));
        if (newIndex != existingIndex) {
            keyInfo.remove(existingIndex);
        }
    }

    private int addShiftedKeyInfoIndex(int initialIndex, int onePastEndIndex, POMultiQueryPackage mpkg) throws OptimizerException {
        int numIndices;
        List<POPackage> pkgs = mpkg.getPackages();
        int end = numIndices = onePastEndIndex - initialIndex;
        if (numIndices > pkgs.size()) {
            end = pkgs.size();
        } else if (numIndices < pkgs.size()) {
            int errCode = 2146;
            String msg = "Internal Error. Inconsistency in key index found during optimization.";
            throw new OptimizerException(msg, errCode, 4);
        }
        int curIndex = initialIndex;
        for (int i = 0; i < end; ++i) {
            POPackage pkg = pkgs.get(i);
            this.addShiftedKeyInfoIndex(curIndex, pkg);
            ++curIndex;
        }
        return curIndex;
    }

    private void mergeOneCombinePlanWithIndex(PhysicalPlan from, PhysicalPlan to, int initial, int current, byte mapKeyType) throws VisitorException {
        POPackage cpk = (POPackage)from.getRoots().get(0);
        from.remove(cpk);
        PODemux demux = (PODemux)to.getLeaves().get(0);
        POMultiQueryPackage pkg = (POMultiQueryPackage)to.getRoots().get(0);
        boolean isSameKeyType = pkg.isSameMapKeyType();
        int total = current - initial;
        int pkCount = 0;
        if (cpk instanceof POMultiQueryPackage) {
            List<POPackage> pkgs = ((POMultiQueryPackage)cpk).getPackages();
            for (POPackage p : pkgs) {
                pkg.addPackage(p);
                if (!isSameKeyType) {
                    p.setKeyType((byte)110);
                }
                ++pkCount;
            }
        } else {
            pkg.addPackage(cpk);
            pkCount = 1;
        }
        pkg.setSameMapKeyType(isSameKeyType);
        if (pkCount != total) {
            int errCode = 2146;
            String msg = "Internal Error. Inconsistency in key index found during optimization.";
            throw new OptimizerException(msg, errCode, 4);
        }
        if (!isSameKeyType) {
            cpk.setKeyType((byte)110);
        }
        pkg.setKeyType(cpk.getKeyType());
        int plCount = 0;
        PhysicalOperator leaf = (PhysicalOperator)from.getLeaves().get(0);
        if (leaf instanceof PODemux) {
            List<PhysicalPlan> pls = ((PODemux)leaf).getPlans();
            for (PhysicalPlan pl : pls) {
                demux.addPlan(pl);
                POLocalRearrange lr = (POLocalRearrange)pl.getLeaves().get(0);
                try {
                    lr.setMultiQueryIndex(initial + plCount++);
                }
                catch (ExecException e) {
                    int errCode = 2136;
                    String msg = "Internal Error. Unable to set multi-query index for optimization.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
                if (isSameKeyType) continue;
                lr.setKeyType((byte)110);
            }
        } else {
            demux.addPlan(from);
            POLocalRearrange lr = (POLocalRearrange)from.getLeaves().get(0);
            try {
                lr.setMultiQueryIndex(initial + plCount++);
            }
            catch (ExecException e) {
                int errCode = 2136;
                String msg = "Internal Error. Unable to set multi-query index for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
            if (!isSameKeyType) {
                lr.setKeyType((byte)110);
            }
        }
        if (plCount != total) {
            int errCode = 2146;
            String msg = "Internal Error. Inconsistency in key index found during optimization.";
            throw new OptimizerException(msg, errCode, 4);
        }
    }

    private boolean needCombiner(List<MapReduceOper> mapReducers) {
        boolean needCombiner = false;
        for (MapReduceOper mrOp : mapReducers) {
            if (mrOp.combinePlan.isEmpty()) continue;
            needCombiner = true;
            break;
        }
        return needCombiner;
    }

    private PhysicalPlan createDemuxPlan(boolean sameKeyType, boolean isCombiner) throws VisitorException {
        PODemux demux = this.getDemux(isCombiner);
        POMultiQueryPackage pkg = this.getMultiQueryPackage(sameKeyType, isCombiner);
        PhysicalPlan pl = new PhysicalPlan();
        pl.add(pkg);
        try {
            pl.addAsLeaf(demux);
        }
        catch (PlanException e) {
            int errCode = 2137;
            String msg = "Internal Error. Unable to add demux to the plan as leaf for optimization.";
            throw new OptimizerException(msg, errCode, 4, (Throwable)e);
        }
        return pl;
    }

    private void mergeAllMapReduceSplittees(List<MapReduceOper> mergeList, MapReduceOper splitter, POSplit splitOp) throws VisitorException {
        boolean sameKeyType = this.hasSameMapKeyType(mergeList);
        this.log.debug((Object)("Splittees have the same key type: " + sameKeyType));
        PhysicalPlan redPl = this.createDemuxPlan(sameKeyType, false);
        PhysicalPlan comPl = this.needCombiner(mergeList) ? this.createDemuxPlan(sameKeyType, true) : null;
        this.log.debug((Object)("Splittees have combiner: " + (comPl != null)));
        int index = 0;
        for (MapReduceOper mrOp : mergeList) {
            int incIndex = this.mergeOneMapPlanWithIndex(mrOp.mapPlan, splitOp, index, sameKeyType);
            if (comPl != null) {
                if (!mrOp.combinePlan.isEmpty()) {
                    this.mergeOneCombinePlanWithIndex(mrOp.combinePlan, comPl, index, incIndex, mrOp.mapKeyType);
                } else {
                    int errCode = 2141;
                    String msg = "Internal Error. Cannot merge non-combiner with combiners for optimization.";
                    throw new OptimizerException(msg, errCode, 4);
                }
            }
            this.mergeOneReducePlanWithIndex(mrOp.reducePlan, redPl, index, incIndex, mrOp.mapKeyType);
            index = incIndex;
            this.log.info((Object)("Merged MR job " + mrOp.getOperatorKey().getId() + " into MR job " + splitter.getOperatorKey().getId()));
        }
        PhysicalPlan splitterPl = splitter.mapPlan;
        PhysicalOperator leaf = (PhysicalOperator)splitterPl.getLeaves().get(0);
        PhysicalOperator storeOp = (PhysicalOperator)splitterPl.getLeaves().get(0);
        List<PhysicalOperator> storePreds = splitterPl.getPredecessors(storeOp);
        if (leaf instanceof POStore) {
            splitOp.setInputs(storePreds);
            try {
                splitterPl.replace(storeOp, splitOp);
            }
            catch (PlanException e) {
                int errCode = 2132;
                String msg = "Internal Error. Unable to replace store with split operator for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
        }
        splitter.setMapDone(true);
        splitter.reducePlan = redPl;
        splitter.setReduceDone(true);
        if (comPl != null) {
            splitter.combinePlan = comPl;
        }
        for (MapReduceOper mrOp : mergeList) {
            this.removeAndReconnect(mrOp, splitter);
        }
        splitter.mapKeyType = (byte)(sameKeyType ? (int)mergeList.get((int)0).mapKeyType : 110);
        this.log.info((Object)("Requested parallelism of splitter: " + splitter.getRequestedParallelism()));
    }

    private void mergeSingleMapReduceSplittee(MapReduceOper mapReduce, MapReduceOper splitter, POSplit splitOp) throws VisitorException {
        PhysicalPlan splitterPl = splitter.mapPlan;
        PhysicalOperator leaf = (PhysicalOperator)splitterPl.getLeaves().get(0);
        PhysicalOperator storeOp = (PhysicalOperator)splitterPl.getLeaves().get(0);
        List<PhysicalOperator> storePreds = splitterPl.getPredecessors(storeOp);
        PhysicalPlan pl = mapReduce.mapPlan;
        PhysicalOperator load = (PhysicalOperator)pl.getRoots().get(0);
        pl.remove(load);
        splitOp.addPlan(pl);
        splitter.setMapDone(true);
        splitter.reducePlan = mapReduce.reducePlan;
        splitter.setReduceDone(true);
        splitter.combinePlan = mapReduce.combinePlan;
        splitter.customPartitioner = mapReduce.customPartitioner;
        if (leaf instanceof POStore) {
            splitOp.setInputs(storePreds);
            try {
                splitterPl.replace(storeOp, splitOp);
            }
            catch (PlanException e) {
                int errCode = 2132;
                String msg = "Internal Error. Unable to replace store with split operator for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
        }
        this.removeAndReconnect(mapReduce, splitter);
    }

    private void removeAndReconnect(MapReduceOper mr, MapReduceOper newMR) throws VisitorException {
        List<MapReduceOper> mapperSuccs = ((MROperPlan)this.getPlan()).getSuccessors(mr);
        List<MapReduceOper> mapperPreds = ((MROperPlan)this.getPlan()).getPredecessors(mr);
        ArrayList<MapReduceOper> succsCopy = null;
        ArrayList<MapReduceOper> predsCopy = null;
        if (mapperSuccs != null) {
            succsCopy = new ArrayList<MapReduceOper>(mapperSuccs);
        }
        if (mapperPreds != null) {
            predsCopy = new ArrayList<MapReduceOper>(mapperPreds);
        }
        ((MROperPlan)this.getPlan()).remove(mr);
        if (succsCopy != null) {
            for (MapReduceOper succ : succsCopy) {
                try {
                    ((MROperPlan)this.getPlan()).connect(newMR, succ);
                }
                catch (PlanException e) {
                    int errCode = 2133;
                    String msg = "Internal Error. Unable to connect map plan with successors for optimization.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
            }
        }
        if (predsCopy != null) {
            for (MapReduceOper pred : predsCopy) {
                if (newMR.getOperatorKey().equals(pred.getOperatorKey())) continue;
                try {
                    ((MROperPlan)this.getPlan()).connect(pred, newMR);
                }
                catch (PlanException e) {
                    int errCode = 2134;
                    String msg = "Internal Error. Unable to connect map plan with predecessors for optimization.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
            }
        }
        this.mergeMROperProperties(mr, newMR);
    }

    private void mergeMROperProperties(MapReduceOper from, MapReduceOper to) {
        if (from.isEndOfAllInputSetInMap()) {
            to.setEndOfAllInputInMap(true);
        }
        if (from.isEndOfAllInputSetInReduce()) {
            to.setEndOfAllInputInReduce(true);
        }
        if (from.getRequestedParallelism() > to.getRequestedParallelism()) {
            to.requestedParallelism = from.requestedParallelism;
        }
        if (!from.UDFs.isEmpty()) {
            to.UDFs.addAll(from.UDFs);
        }
        if (from.needsDistinctCombiner()) {
            to.setNeedsDistinctCombiner(true);
        }
        if (to.mapKeyType == 0) {
            to.mapKeyType = from.mapKeyType;
        }
    }

    private boolean isMapOnly(MapReduceOper mr) {
        return mr.reducePlan.isEmpty();
    }

    private boolean isSingleLoadMapperPlan(PhysicalPlan pl) {
        return pl.getRoots().size() == 1;
    }

    private boolean isSinglePredecessor(MapReduceOper mr) {
        return ((MROperPlan)this.getPlan()).getPredecessors(mr).size() == 1;
    }

    private POSplit getSplit() {
        return new POSplit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
    }

    private MapReduceOper getMROper() {
        return new MapReduceOper(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
    }

    private POStore getStore() {
        return new POStore(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
    }

    private PODemux getDemux(boolean inCombiner) {
        PODemux demux = new PODemux(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        demux.setInCombiner(inCombiner);
        return demux;
    }

    private POMultiQueryPackage getMultiQueryPackage(boolean sameMapKeyType, boolean inCombiner) {
        POMultiQueryPackage pkg = new POMultiQueryPackage(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        pkg.setInCombiner(inCombiner);
        pkg.setSameMapKeyType(sameMapKeyType);
        return pkg;
    }
}

