/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.math.BigInteger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class Mod
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 1L;

    public Mod(OperatorKey k) {
        super(k);
    }

    public Mod(OperatorKey k, int rp) {
        super(k, rp);
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMod(this);
    }

    public String name() {
        return "Mod[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    protected Number mod(Number a, Number b, byte dataType) throws ExecException {
        switch (dataType) {
            case 10: {
                return (Integer)a % (Integer)b;
            }
            case 15: {
                return (Long)a % (Long)b;
            }
            case 65: {
                return ((BigInteger)a).mod((BigInteger)b);
            }
        }
        throw new ExecException("called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    protected Result genericGetNext(byte dataType) throws ExecException {
        Result r = this.accumChild(null, dataType);
        if (r != null) {
            return r;
        }
        Result res = this.lhs.getNext(dataType);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        Number left = (Number)res.result;
        res = this.rhs.getNext(dataType);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        Number right = (Number)res.result;
        res.result = this.mod(left, right, dataType);
        return res;
    }

    public Result getNextInteger() throws ExecException {
        return this.genericGetNext((byte)10);
    }

    public Result getNextLong() throws ExecException {
        return this.genericGetNext((byte)15);
    }

    public Result getNextBigInteger() throws ExecException {
        return this.genericGetNext((byte)65);
    }

    public Mod clone() throws CloneNotSupportedException {
        Mod clone = new Mod(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

