/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.ExecType;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.utils.StructuresHelper;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTupleFrontend {
    private static final Log LOG = LogFactory.getLog(SchemaTupleFrontend.class);
    private static SchemaTupleFrontend stf;
    private static Map<StructuresHelper.Pair<StructuresHelper.SchemaKey, Boolean>, StructuresHelper.Pair<Integer, Set<SchemaTupleClassGenerator.GenContext>>> schemasToGenerate;
    private static PigContext pigContextToReset;

    private int internalRegisterToGenerateIfPossible(Schema udfSchema, boolean isAppendable, SchemaTupleClassGenerator.GenContext type) {
        StructuresHelper.Pair<StructuresHelper.SchemaKey, Boolean> key = StructuresHelper.Pair.make(new StructuresHelper.SchemaKey(udfSchema), isAppendable);
        StructuresHelper.Pair<Integer, Set<SchemaTupleClassGenerator.GenContext>> pr = schemasToGenerate.get(key);
        if (pr != null) {
            pr.getSecond().add(type);
            return pr.getFirst();
        }
        if (!SchemaTupleFactory.isGeneratable(udfSchema)) {
            LOG.debug((Object)("Given Schema is not generatable: " + udfSchema));
            return -1;
        }
        int id = SchemaTupleClassGenerator.getNextGlobalClassIdentifier();
        HashSet<SchemaTupleClassGenerator.GenContext> contexts = Sets.newHashSet();
        contexts.add(SchemaTupleClassGenerator.GenContext.FORCE_LOAD);
        contexts.add(type);
        schemasToGenerate.put(key, StructuresHelper.Pair.make(id, contexts));
        LOG.debug((Object)("Registering " + (isAppendable ? "Appendable" : "") + "Schema for generation [" + udfSchema + "] with id [" + id + "] and context: " + (Object)((Object)type)));
        return id;
    }

    private Map<StructuresHelper.Pair<StructuresHelper.SchemaKey, Boolean>, StructuresHelper.Pair<Integer, Set<SchemaTupleClassGenerator.GenContext>>> getSchemasToGenerate() {
        return schemasToGenerate;
    }

    public static void reset() {
        stf = null;
        schemasToGenerate.clear();
    }

    public static int registerToGenerateIfPossible(Schema udfSchema, boolean isAppendable, SchemaTupleClassGenerator.GenContext context) {
        if (stf == null) {
            if (pigContextToReset != null) {
                Properties prop = pigContextToReset.getProperties();
                prop.remove("pig.schematuple.classes");
                prop.remove("pig.schematuple.local.dir");
                pigContextToReset = null;
            }
            SchemaTupleBackend.reset();
            SchemaTupleClassGenerator.resetGlobalClassIdentifier();
            stf = new SchemaTupleFrontend();
        }
        if (udfSchema == null) {
            return -1;
        }
        try {
            udfSchema = udfSchema.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unable to clone Schema: " + udfSchema, e);
        }
        SchemaTupleFrontend.stripAliases(udfSchema);
        return stf.internalRegisterToGenerateIfPossible(udfSchema, isAppendable, context);
    }

    private static void stripAliases(Schema s) {
        for (Schema.FieldSchema fs : s.getFields()) {
            fs.alias = null;
            if (fs.schema == null) continue;
            SchemaTupleFrontend.stripAliases(fs.schema);
        }
    }

    public static void copyAllGeneratedToDistributedCache(PigContext pigContext, Configuration conf) {
        if (stf == null) {
            LOG.debug((Object)"Nothing registered to generate.");
            return;
        }
        SchemaTupleFrontendGenHelper stfgh = new SchemaTupleFrontendGenHelper(pigContext, conf);
        stfgh.generateAll(SchemaTupleFrontend.stf.getSchemasToGenerate());
        stfgh.internalCopyAllGeneratedToDistributedCache();
        Properties prop = pigContext.getProperties();
        String value = conf.get("pig.schematuple.classes");
        if (value != null) {
            prop.setProperty("pig.schematuple.classes", value);
        } else {
            prop.remove("pig.schematuple.classes");
        }
        value = conf.get("pig.schematuple.local.dir");
        if (value != null) {
            prop.setProperty("pig.schematuple.local.dir", value);
        } else {
            prop.remove("pig.schematuple.local.dir");
        }
    }

    protected static void lazyReset(PigContext pigContext) {
        pigContextToReset = pigContext;
    }

    static {
        schemasToGenerate = Maps.newHashMap();
        pigContextToReset = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaTupleFrontendGenHelper {
        private File codeDir = Files.createTempDir();
        private PigContext pigContext;
        private Configuration conf;

        public SchemaTupleFrontendGenHelper(PigContext pigContext, Configuration conf) {
            this.codeDir.deleteOnExit();
            LOG.debug((Object)("Temporary directory for generated code created: " + this.codeDir.getAbsolutePath()));
            this.pigContext = pigContext;
            this.conf = conf;
        }

        private void internalCopyAllGeneratedToDistributedCache() {
            LOG.info((Object)"Starting process to move generated code to distributed cache");
            if (this.pigContext.getExecType() == ExecType.LOCAL) {
                String codePath = this.codeDir.getAbsolutePath();
                LOG.info((Object)("Distributed cache not supported or needed in local mode. Setting key [pig.schematuple.local.dir] with code temp directory: " + codePath));
                this.conf.set("pig.schematuple.local.dir", codePath);
                return;
            }
            String codePath = this.codeDir.getAbsolutePath();
            this.conf.set("pig.schematuple.local.dir", codePath);
            DistributedCache.createSymlink((Configuration)this.conf);
            StringBuilder serialized = new StringBuilder();
            boolean first = true;
            for (File f : this.codeDir.listFiles()) {
                FileSystem fs;
                Path dst;
                if (first) {
                    first = false;
                } else {
                    serialized.append(",");
                }
                String symlink = f.getName();
                serialized.append(symlink);
                Path src = new Path(f.toURI());
                try {
                    dst = FileLocalizer.getTemporaryPath(this.pigContext);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error getting temporary path in HDFS", e);
                }
                try {
                    fs = dst.getFileSystem(this.conf);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get FileSystem", e);
                }
                try {
                    fs.copyFromLocalFile(src, dst);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to copy from local filesystem to HDFS, src = " + src + ", dst = " + dst, e);
                }
                String destination = dst.toString() + "#" + symlink;
                try {
                    DistributedCache.addCacheFile((URI)new URI(destination), (Configuration)this.conf);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Unable to add file to distributed cache: " + destination, e);
                }
                LOG.info((Object)("File successfully added to the distributed cache: " + symlink));
            }
            String toSer = serialized.toString();
            LOG.info((Object)("Setting key [pig.schematuple.classes] with classes to deserialize [" + toSer + "]"));
            this.conf.set("pig.schematuple.classes", toSer);
        }

        private boolean generateAll(Map<StructuresHelper.Pair<StructuresHelper.SchemaKey, Boolean>, StructuresHelper.Pair<Integer, Set<SchemaTupleClassGenerator.GenContext>>> schemasToGenerate) {
            boolean filesToShip = false;
            if (!this.conf.getBoolean("pig.schematuple", false)) {
                LOG.info((Object)"Key [pig.schematuple] is false, will not generate code.");
                return false;
            }
            LOG.info((Object)"Generating all registered Schemas.");
            for (Map.Entry<StructuresHelper.Pair<StructuresHelper.SchemaKey, Boolean>, StructuresHelper.Pair<Integer, Set<SchemaTupleClassGenerator.GenContext>>> entry : schemasToGenerate.entrySet()) {
                StructuresHelper.Pair<StructuresHelper.SchemaKey, Boolean> keyPair = entry.getKey();
                Schema s = keyPair.getFirst().get();
                StructuresHelper.Pair<Integer, Set<SchemaTupleClassGenerator.GenContext>> valuePair = entry.getValue();
                HashSet<SchemaTupleClassGenerator.GenContext> contextsToInclude = Sets.newHashSet();
                boolean isShipping = false;
                for (SchemaTupleClassGenerator.GenContext context : valuePair.getSecond()) {
                    if (!context.shouldGenerate(this.conf)) {
                        LOG.info((Object)("Skipping generation of Schema [" + s + "], as key value [" + context.key() + "] was false."));
                        continue;
                    }
                    isShipping = true;
                    contextsToInclude.add(context);
                }
                if (!isShipping) continue;
                int id = valuePair.getFirst();
                boolean isAppendable = keyPair.getSecond();
                SchemaTupleClassGenerator.generateSchemaTuple(s, isAppendable, id, this.codeDir, contextsToInclude.toArray(new SchemaTupleClassGenerator.GenContext[0]));
                filesToShip = true;
            }
            return filesToShip;
        }
    }
}

