/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.ExecType;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.datastorage.SeekableInputStream;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.datastorage.HPath;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.ResourceNotFoundException;

public class FileLocalizer {
    private static final Log log = LogFactory.getLog(FileLocalizer.class);
    public static final String LOCAL_PREFIX = "file:";
    public static final int STYLE_UNIX = 0;
    public static final int STYLE_WINDOWS = 1;
    static Random r = new Random();
    private static ThreadLocal<ContainerDescriptor> relativeRoot = new ThreadLocal<ContainerDescriptor>(){};
    static File localTempDir = null;

    static String checkDefaultPrefix(ExecType execType, String fileSpec) {
        if (fileSpec.startsWith(LOCAL_PREFIX)) {
            return fileSpec;
        }
        return (execType == ExecType.LOCAL ? LOCAL_PREFIX : "") + fileSpec;
    }

    public static InputStream openDFSFile(String fileName) throws IOException {
        Configuration conf = (Configuration)PigMapReduce.sJobConfInternal.get();
        if (conf == null) {
            throw new RuntimeException("can't open DFS file while executing locally");
        }
        return FileLocalizer.openDFSFile(fileName, ConfigurationUtil.toProperties(conf));
    }

    public static InputStream openDFSFile(String fileName, Properties properties) throws IOException {
        HDataStorage dds = new HDataStorage(properties);
        ElementDescriptor elem = dds.asElement(fileName);
        return FileLocalizer.openDFSFile(elem);
    }

    public static long getSize(String fileName) throws IOException {
        Configuration conf = (Configuration)PigMapReduce.sJobConfInternal.get();
        if (conf == null) {
            throw new RuntimeException("can't open DFS file while executing locally");
        }
        return FileLocalizer.getSize(fileName, ConfigurationUtil.toProperties(conf));
    }

    public static long getSize(String fileName, Properties properties) throws IOException {
        HDataStorage dds = new HDataStorage(properties);
        ElementDescriptor elem = dds.asElement(fileName);
        ElementDescriptor[] allElems = FileLocalizer.getFileElementDescriptors(elem);
        long size = 0L;
        for (int i = 0; i < allElems.length; ++i) {
            Map<String, Object> stats = allElems[i].getStatistics();
            size += ((Long)stats.get("pig.path.length")).longValue();
        }
        return size;
    }

    private static InputStream openDFSFile(ElementDescriptor elem) throws IOException {
        ElementDescriptor[] elements;
        block6: {
            elements = null;
            if (elem.exists()) {
                try {
                    if (!elem.getDataStorage().isContainer(elem.toString())) {
                        if (elem.systemElement()) {
                            throw new IOException("Attempt is made to open system file " + elem.toString());
                        }
                        return elem.open();
                    }
                    break block6;
                }
                catch (DataStorageException e) {
                    throw new IOException("Failed to determine if elem=" + elem + " is container", e);
                }
            }
            if (!FileLocalizer.globMatchesFiles(elem, elem.getDataStorage())) {
                throw new IOException(elem.toString() + " does not exist");
            }
            elements = FileLocalizer.getFileElementDescriptors(elem);
            return new DataStorageInputStreamIterator(elements);
        }
        elements = FileLocalizer.getFileElementDescriptors(elem);
        return new DataStorageInputStreamIterator(elements);
    }

    private static ElementDescriptor[] getFileElementDescriptors(ElementDescriptor elem) throws DataStorageException {
        DataStorage store = elem.getDataStorage();
        ElementDescriptor[] elems = store.asCollection(elem.toString());
        ArrayList<ElementDescriptor> paths = new ArrayList<ElementDescriptor>();
        ArrayList<ElementDescriptor> filePaths = new ArrayList<ElementDescriptor>();
        for (int m = 0; m < elems.length; ++m) {
            paths.add(elems[m]);
        }
        for (int j = 0; j < paths.size(); ++j) {
            ElementDescriptor fullPath = store.asElement(store.getActiveContainer(), (ElementDescriptor)paths.get(j));
            if (fullPath.systemElement()) continue;
            if (fullPath instanceof ContainerDescriptor) {
                for (ElementDescriptor child : (ContainerDescriptor)fullPath) {
                    paths.add(child);
                }
                continue;
            }
            filePaths.add(fullPath);
        }
        elems = new ElementDescriptor[filePaths.size()];
        filePaths.toArray(elems);
        return elems;
    }

    private static InputStream openLFSFile(ElementDescriptor elem) throws IOException {
        return FileLocalizer.openDFSFile(elem);
    }

    @Deprecated
    public static InputStream open(String fileName, ExecType execType, DataStorage storage) throws IOException {
        if (!(fileName = FileLocalizer.checkDefaultPrefix(execType, fileName)).startsWith(LOCAL_PREFIX)) {
            ElementDescriptor elem = storage.asElement(FileLocalizer.fullPath(fileName, storage));
            return FileLocalizer.openDFSFile(elem);
        }
        fileName = fileName.substring(LOCAL_PREFIX.length());
        ElementDescriptor elem = storage.asElement(FileLocalizer.fullPath(fileName, storage));
        return FileLocalizer.openLFSFile(elem);
    }

    @Deprecated
    public static String fullPath(String fileName, DataStorage storage) {
        String fullPath;
        try {
            if (fileName.charAt(0) != '/') {
                ContainerDescriptor currentDir = storage.getActiveContainer();
                ElementDescriptor elem = storage.asElement(currentDir.toString(), fileName);
                fullPath = elem.toString();
            } else {
                fullPath = fileName;
            }
        }
        catch (DataStorageException e) {
            fullPath = fileName;
        }
        return fullPath;
    }

    public static InputStream open(String fileSpec, PigContext pigContext) throws IOException {
        fileSpec = FileLocalizer.checkDefaultPrefix(pigContext.getExecType(), fileSpec);
        if (!fileSpec.startsWith(LOCAL_PREFIX)) {
            ElementDescriptor elem = pigContext.getDfs().asElement(FileLocalizer.fullPath(fileSpec, pigContext));
            return FileLocalizer.openDFSFile(elem);
        }
        fileSpec = fileSpec.substring(LOCAL_PREFIX.length());
        ElementDescriptor elem = pigContext.getLfs().asElement(FileLocalizer.fullPath(fileSpec, pigContext));
        return FileLocalizer.openLFSFile(elem);
    }

    public static SeekableInputStream open(String fileSpec, long offset, PigContext pigContext) throws IOException {
        ElementDescriptor elem;
        fileSpec = FileLocalizer.checkDefaultPrefix(pigContext.getExecType(), fileSpec);
        if (!fileSpec.startsWith(LOCAL_PREFIX)) {
            elem = pigContext.getDfs().asElement(FileLocalizer.fullPath(fileSpec, pigContext));
        } else {
            fileSpec = fileSpec.substring(LOCAL_PREFIX.length());
            elem = pigContext.getLfs().asElement(FileLocalizer.fullPath(fileSpec, pigContext));
        }
        if (elem.exists() && !elem.getDataStorage().isContainer(elem.toString())) {
            try {
                if (elem.systemElement()) {
                    throw new IOException("Attempt is made to open system file " + elem.toString());
                }
                SeekableInputStream sis = elem.sopen();
                sis.seek(offset, SeekableInputStream.FLAGS.SEEK_SET);
                return sis;
            }
            catch (DataStorageException e) {
                throw new IOException("Failed to determine if elem=" + elem + " is container", e);
            }
        }
        throw new IOException("Currently seek is supported only in a file, not in glob or directory.");
    }

    public static OutputStream create(String fileSpec, PigContext pigContext) throws IOException {
        return FileLocalizer.create(fileSpec, false, pigContext);
    }

    public static OutputStream create(String fileSpec, boolean append, PigContext pigContext) throws IOException {
        boolean res;
        fileSpec = FileLocalizer.checkDefaultPrefix(pigContext.getExecType(), fileSpec);
        if (!fileSpec.startsWith(LOCAL_PREFIX)) {
            ElementDescriptor elem = pigContext.getDfs().asElement(fileSpec);
            return elem.create();
        }
        File f = new File(fileSpec = fileSpec.substring(LOCAL_PREFIX.length())).getParentFile();
        if (f != null && !(res = f.mkdirs())) {
            log.warn((Object)("FileLocalizer.create: failed to create " + f));
        }
        return new FileOutputStream(fileSpec, append);
    }

    public static boolean delete(String fileSpec, PigContext pigContext) throws IOException {
        fileSpec = FileLocalizer.checkDefaultPrefix(pigContext.getExecType(), fileSpec);
        ElementDescriptor elem = null;
        elem = !fileSpec.startsWith(LOCAL_PREFIX) ? pigContext.getDfs().asElement(fileSpec) : pigContext.getLfs().asElement(fileSpec);
        elem.delete();
        return true;
    }

    public static void setInitialized(boolean initialized) {
        if (!initialized) {
            relativeRoot.set(null);
        }
    }

    private static synchronized ContainerDescriptor relativeRoot(PigContext pigContext) throws DataStorageException {
        if (relativeRoot.get() == null) {
            String tdir = pigContext.getProperties().getProperty("pig.temp.dir", "/tmp");
            relativeRoot.set(pigContext.getDfs().asContainer(tdir + "/temp" + r.nextInt()));
        }
        return relativeRoot.get();
    }

    public static void deleteTempFiles() {
        if (relativeRoot.get() != null) {
            try {
                relativeRoot.get().delete();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            FileLocalizer.setInitialized(false);
        }
    }

    public static Path getTemporaryPath(PigContext pigContext) throws IOException {
        return FileLocalizer.getTemporaryPath(pigContext, "");
    }

    public static Path getTemporaryPath(PigContext pigContext, String suffix) throws IOException {
        ContainerDescriptor relative = FileLocalizer.relativeRoot(pigContext);
        if (!FileLocalizer.relativeRoot(pigContext).exists()) {
            FileLocalizer.relativeRoot(pigContext).create();
        }
        ElementDescriptor elem = pigContext.getDfs().asElement(relative.toString(), "tmp" + r.nextInt() + suffix);
        return ((HPath)elem).getPath();
    }

    public static String hadoopify(String filename, PigContext pigContext) throws IOException {
        ElementDescriptor localElem;
        if (filename.startsWith(LOCAL_PREFIX)) {
            filename = filename.substring(LOCAL_PREFIX.length());
        }
        if (!(localElem = pigContext.getLfs().asElement(filename)).exists()) {
            throw new FileNotFoundException(filename);
        }
        ElementDescriptor distribElem = pigContext.getDfs().asElement(FileLocalizer.getTemporaryPath(pigContext).toString());
        int suffixStart = filename.lastIndexOf(46);
        if (suffixStart != -1) {
            distribElem = pigContext.getDfs().asElement(distribElem.toString() + filename.substring(suffixStart));
        }
        if (distribElem.exists()) {
            distribElem.delete();
        }
        localElem.copy(distribElem, null, false);
        return distribElem.toString();
    }

    public static String fullPath(String filename, PigContext pigContext) throws IOException {
        try {
            if (filename.charAt(0) != '/') {
                ContainerDescriptor currentDir = pigContext.getDfs().getActiveContainer();
                ElementDescriptor elem = pigContext.getDfs().asElement(currentDir.toString(), filename);
                return elem.toString();
            }
            return filename;
        }
        catch (DataStorageException e) {
            return filename;
        }
    }

    public static boolean fileExists(String filename, PigContext context) throws IOException {
        return FileLocalizer.fileExists(filename, context.getFs());
    }

    @Deprecated
    public static boolean fileExists(String filename, DataStorage store) throws IOException {
        ElementDescriptor elem = store.asElement(filename);
        return elem.exists() || FileLocalizer.globMatchesFiles(elem, store);
    }

    public static boolean isFile(String filename, PigContext context) throws IOException {
        return !FileLocalizer.isDirectory(filename, context.getDfs());
    }

    @Deprecated
    public static boolean isFile(String filename, DataStorage store) throws IOException {
        return !FileLocalizer.isDirectory(filename, store);
    }

    public static boolean isDirectory(String filename, PigContext context) throws IOException {
        return FileLocalizer.isDirectory(filename, context.getDfs());
    }

    @Deprecated
    public static boolean isDirectory(String filename, DataStorage store) throws IOException {
        ElementDescriptor elem = store.asElement(filename);
        return elem instanceof ContainerDescriptor;
    }

    private static boolean globMatchesFiles(ElementDescriptor elem, DataStorage fs) throws IOException {
        ElementDescriptor[] elems = fs.asCollection(elem.toString());
        switch (elems.length) {
            case 0: {
                return false;
            }
            case 1: {
                return !elems[0].equals(elem);
            }
        }
        return true;
    }

    public static Random getR() {
        return r;
    }

    public static void setR(Random r) {
        FileLocalizer.r = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseCygPath(String path, int style) {
        String[] command = style == 1 ? new String[]{"cygpath", "-w", path} : new String[]{"cygpath", "-u", path};
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            return null;
        }
        int exitVal = 0;
        try {
            exitVal = p.waitFor();
        }
        catch (InterruptedException e) {
            return null;
        }
        if (exitVal != 0) {
            return null;
        }
        String line = null;
        BufferedReader br = null;
        try {
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            br = new BufferedReader(isr);
            line = br.readLine();
            isr.close();
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        return line;
    }

    public static FetchFileRet fetchFile(Properties properties, String filePath) throws IOException {
        return FileLocalizer.fetchFilesInternal(properties, filePath, false)[0];
    }

    public static FetchFileRet[] fetchFiles(Properties properties, String filePath) throws IOException {
        return FileLocalizer.fetchFilesInternal(properties, filePath, true);
    }

    private static FetchFileRet[] fetchFilesInternal(Properties properties, String filePath, boolean multipleFiles) throws IOException {
        Path path = new Path(filePath);
        URI uri = path.toUri();
        Configuration conf = new Configuration();
        ConfigurationUtil.mergeConf(conf, ConfigurationUtil.toConfiguration(properties));
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Object srcFs = !"true".equals(properties.getProperty("pig.jars.relative.to.dfs")) && uri.getScheme() == null || uri.getScheme().equals("local") ? localFs : path.getFileSystem(conf);
        FileStatus[] files = multipleFiles ? srcFs.globStatus(path) : new FileStatus[]{srcFs.getFileStatus(path)};
        if (files == null || files.length == 0) {
            throw new ExecException("file '" + filePath + "' does not exist.", 101, 2);
        }
        FetchFileRet[] fetchFiles = new FetchFileRet[files.length];
        int idx = 0;
        for (FileStatus file : files) {
            String pathname = file.getPath().toUri().getPath();
            String filename = file.getPath().getName();
            if (srcFs == localFs) {
                fetchFiles[idx++] = new FetchFileRet(new File(pathname), false);
                continue;
            }
            File dest = new File(localTempDir, filename);
            dest.deleteOnExit();
            try {
                srcFs.copyToLocalFile(file.getPath(), new Path(dest.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new ExecException("Could not copy " + filePath + " to local destination " + dest, 101, 2, e);
            }
            fetchFiles[idx++] = new FetchFileRet(dest, true);
        }
        return fetchFiles;
    }

    public static FetchFileRet fetchResource(String name) throws IOException, ResourceNotFoundException {
        BufferedOutputStream outputStream;
        File dest;
        FetchFileRet localFileRet = null;
        InputStream resourceStream = PigContext.getClassLoader().getResourceAsStream(name);
        if (resourceStream != null) {
            int len;
            dest = new File(localTempDir, name);
            dest.getParentFile().mkdirs();
            dest.deleteOnExit();
            outputStream = new BufferedOutputStream(new FileOutputStream(dest));
            byte[] buffer = new byte[1024];
            while ((len = resourceStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, len);
            }
        } else {
            throw new ResourceNotFoundException(name);
        }
        ((OutputStream)outputStream).close();
        localFileRet = new FetchFileRet(dest, false);
        return localFileRet;
    }

    static {
        boolean success = true;
        try {
            File f = File.createTempFile("pig", "tmp");
            success &= f.delete();
            success &= f.mkdir();
            localTempDir = f;
            localTempDir.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!success) {
            throw new RuntimeException("Error creating FileLocalizer temp directory.");
        }
    }

    public static class FetchFileRet {
        public File file;
        public boolean didFetch;

        public FetchFileRet(File file, boolean didFetch) {
            this.file = file;
            this.didFetch = didFetch;
        }
    }

    public static class DataStorageInputStreamIterator
    extends InputStream {
        InputStream current;
        ElementDescriptor[] elements;
        int currentElement;

        public DataStorageInputStreamIterator(ElementDescriptor[] elements) {
            this.elements = elements;
        }

        private boolean isEOF() throws IOException {
            if (this.current == null) {
                if (this.currentElement == this.elements.length) {
                    return true;
                }
                this.current = this.elements[this.currentElement++].open();
            }
            return false;
        }

        private void doNext() throws IOException {
            this.current.close();
            this.current = null;
        }

        public int read() throws IOException {
            while (!this.isEOF()) {
                int rc = this.current.read();
                if (rc != -1) {
                    return rc;
                }
                this.doNext();
            }
            return -1;
        }

        public int available() throws IOException {
            if (this.isEOF()) {
                return 0;
            }
            return this.current.available();
        }

        public void close() throws IOException {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
            this.currentElement = this.elements.length;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = 0;
            while (!this.isEOF() && len > 0) {
                int rc = this.current.read(b, off, len);
                if (rc <= 0) {
                    this.doNext();
                    continue;
                }
                off += rc;
                len -= rc;
                count += rc;
            }
            return count == 0 ? (this.isEOF() ? -1 : 0) : count;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public long skip(long n) throws IOException {
            while (!this.isEOF() && n > 0L) {
                n -= this.current.skip(n);
            }
            return n;
        }
    }
}

