/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.impl.io.PigNullableWritable;

public class NullablePartitionWritable
extends PigNullableWritable {
    private int partitionIndex;
    private PigNullableWritable key;

    public NullablePartitionWritable() {
    }

    public NullablePartitionWritable(PigNullableWritable k) {
        this.setKey(k);
    }

    public void setKey(PigNullableWritable k) {
        this.key = k;
    }

    public PigNullableWritable getKey() {
        return this.key;
    }

    public void setPartition(int n) {
        this.partitionIndex = n;
    }

    public int getPartition() {
        return this.partitionIndex;
    }

    public int compareTo(Object o) {
        return this.key.compareTo(((NullablePartitionWritable)o).getKey());
    }

    public void readFields(DataInput in) throws IOException {
        String c = in.readUTF();
        try {
            this.key = HDataType.getWritableComparable(c);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.key.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.key.getClass().getName());
        this.key.write(out);
    }

    public boolean isNull() {
        return this.key.isNull();
    }

    public void setNull(boolean isNull) {
        this.key.setNull(isNull);
    }

    public byte getIndex() {
        return this.key.getIndex();
    }

    public void setIndex(byte index) {
        this.key.setIndex(index);
    }

    public Object getValueAsPigType() {
        return this.key.getValueAsPigType();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Partition: " + this.partitionIndex + " " + this.key.toString();
    }
}

